from gtk import *
from gnome.ui import *
import GTK, GDK

import Mavric
import Mavric.gui

class Controller:
    def __init__(self, root):
        """root = root node of tree data model
           (One-to-one mapping between controller and model,
            but one-to-many between controller and viewer)"""
        assert root.data.get('controller') == None
        root['controller'] = self
        self.root = root
        self.viewers = []

    def __del__(self):
        del self.root['controller']

    def toggle_rooted(self):
        root = self.root
        rooted = 1
        if root.back != None:
            rooted = 0

        if rooted:
            if root.next.next.next == root:  # basal dichotomy
                newroot = root.next.back
                newroot.isroot = 1
                phylo.connect(newroot, root.next.next.back)
                self.root = newroot
                for n in root.fnodes(): n.unlink()
            else:
                p = root.fnodes()[-2]
                q = p.next.back
                p.next.unlink()
                p.next = root
                phylo.connect(root, q)

        else:  # convert to rooted
            if root.next != None: # root is an internal node
                p = phylo.Fnode(data=root.data)
                q = root.fnodes()[-1]
                q.next = p
                p.next = root
                phylo.connect(root.back, p)
                root.back = None
            else:
                root.isroot = 0
                self.root = root.back
                self.root.isroot = 1
                self.toggle_rooted()

    def update_viewers(self):
        for v in self.viewers:
            v.update()

class Viewer(GtkScrolledWindow):
    def __init__(self, controller, width=100, height=100):
        GtkScrolledWindow.__init__(self)
        self.set_policy(GTK.POLICY_AUTOMATIC, GTK.POLICY_AUTOMATIC)
        
        self.controller = controller
        self.prefs = {
            'Style':                  SQUARED,
            'BranchColor':            'darkblue',
            'BranchHighlightColor':   'lightblue',
            'NodeColor':              'darkred',
            'ShowBranchLengths':      0,
            'ScaledBranches':         0,
            'AutoFit':                1,
            'LeafLabelColor':         'darkblue',
            'LeafLabelFont':          'fixed',
            'LengthLabelColor':       'darkred',
            'LengthLabelFont':        'fixed',
            'BranchWidth':            5,
            'TreeOrientation':        EAST,
            'UnitHorizontal':         20,
            'UnitVertical':           20
            }

        self.canvas = GnomeCanvas()
        self.add(self.canvas)
        self.connect('size_allocate', self.size_allocate_cb)
        self.set_usize(100,100)

    def size_allocate_cb(self, widget, event):
        return FALSE

    def event_cb(self, widget, event):
        return FALSE

    def keypress_cb(self, widget, event):
        v = self.get_vadjustment()
        h = self.get_hadjustment()
        if event.keyval == GDK.Page_Up:
            v.clamp_page(v.value-v.page_size+v.step_increment, v.value)

        elif event.keyval == GDK.Page_Down:
            v.clamp_page(v.value+v.page_size-v.step_increment,
                         v.value+2*v.page_size-v.step_increment)
            
        elif event.keyval == GDK.Up:
            v.clamp_page(v.value-(0.1*v.page_size)+v.step_increment, v.value)

        elif event.keyval == GDK.Down:
            v.clamp_page(v.value+(0.1*v.page_size)-v.step_increment,
                         v.value+2*v.page_size-v.step_increment)

        elif event.keyval == GDK.Right:
            h.clamp_page(h.value+(0.1*h.page_size)-h.step_increment,
                         h.value+2*h.page_size-h.step_increment)

        elif event.keyval == GDK.Left:
            h.clamp_page(h.value-(0.1*h.page_size)+h.step_increment, h.value)

        return FALSE

    def update(self, widget=None, event=None, autofit=0):
        autofit = self.prefs['AutoFit']
        if autofit:
            x1,y1, x2,y2 = self.get_allocation()
            w = (x2-x1)*0.9; h = (y2-y1)*0.9
        else:
            w = None; h = None
        if self.canvas:
            self.canvas.update(w, h)

    def destroy(self):
        if self.canvas: self.canvas.destroy()
        self.canvas = None
        GtkScrolledWindow.destroy(self)

    def get_viewable_rect(self):
        height = self.get_vadjustment().page_size
        width = self.get_hadjustment().page_size
        return width, height

    def toggle_branchlengths(self):
        self.prefs['ShowBranchLengths'] = not self.prefs['ShowBranchLengths']
        self.update()

    def toggle_scaled(self):
        self.prefs['ScaledBranches'] = not self.prefs['ScaledBranches']
        self.update()

    def toggle_rooted(self):
        self.controller.toggle_rooted()
        
        
