#!/usr/bin/env python
import gtk, GTK, GDK, gnome.ui
import libglade
import Mavric
import Mavric.gui

widgets = {}
glade_xml = libglade.GladeXML('glade/main.glade')
tree = Mavric.phylo.pectinate_tree(20)
leaves = tree.leaves()
for i in range(len(leaves)):
    leaf = leaves[i]
    leaf.label = 'taxon_%d' % (i+1)
view = Mavric.gui.treeview.TreeView(tree)

def get_widget(s):
    if widgets.has_key(s):
        return widgets[s]
    else:
        w = glade_xml.get_widget(s)
        widgets[s] = w
        return w
    
def mainquit(*args, **kwargs):
    gtk.mainquit()

def connect_file_menu(app):
    def on_newtree_dialog_delete(widget, event):
        print widget
        widget.hide()
    def on_file1_activate(widget):
        w = get_widget('newtree_dialog')
        w.show()
        print w
        
    glade_xml.get_widget('exit1').connect('activate', mainquit)
    glade_xml.get_widget('file1').connect('activate',
                                          on_file1_activate)
    glade_xml.get_widget('newtree_dialog').connect(
        'delete_event', on_newtree_dialog_delete)

def connect_view_menu(app):
    view = app.view
    def on_view_menu_activate(widget, rooted_state_menuitem, view):
        rooted = view.get_rooted_state()
        menuitem_label = rooted_state_menuitem.children()[0]
        if rooted == 1:
            menuitem_label.set_text('Convert to unrooted')
        else:
            menuitem_label.set_text('Convert to rooted')

    rooted_state_menuitem = glade_xml.get_widget('rooted_state1')
    if view == None:
        rooted_state_menuitem.set_sensitive(0)
    else:
        rooted_state_menuitem.connect('activate',
                                      view.toggle_rooted)
        view_menu = glade_xml.get_widget('view1')
        view_menu.connect('activate', on_view_menu_activate,
                          rooted_state_menuitem, view)

def main():
    app = glade_xml.get_widget('app')
    app.connect('delete_event', mainquit)

    app.view = view
    app.set_contents(view)

    connect_file_menu(app)
    connect_view_menu(app)

    app.show_all()

    gtk.mainloop()

if __name__ == '__main__': main()
