# Mavric -- a module for manipulating and visualizing phylogenies

# Copyright (C) 2000 Rick Ree
# Email : rree@oeb.harvard.edu
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

from toolkit import *
from constants import *
import os

class SaveFileSelection(GtkFileSelection):
    def __init__(self, savefunc, parent=None, title='Save As...',):
        GtkFileSelection.__init__(self, title=title)

        self.parent = parent
        self.savefunc = savefunc

        b = GtkCheckButton(label='Append to file')
        b.show()
        self.append_button = b
        self.main_vbox.pack_end(b)

        self.cancel_button.connect('clicked', self.hide)
        self.ok_button.connect('clicked', self.ok_cb)

    def ok_cb(self, button):
        filename = self.get_filename()
        append = self.append_button.get_active() 
        if (not append) and os.path.isfile(filename):

            d = GnomeOkCancelDialog('Overwrite %s?' % filename,
                                    self.overwrite_cb,
                                    self.parent)
            d.set_close(click_closes=TRUE)
            d.run_and_close()
        else:
            mode = 'w'
            if append: mode = 'a+'
            self.savefunc(filename, mode)
        self.hide()

    def overwrite_cb(self, cancel):
        if not cancel:
            filename = self.get_filename()
            self.savefunc(filename, 'w')

class OpenFileSelection(GtkFileSelection):
    def __init__(self, openfunc, parent=None, title='Open...'):
        GtkFileSelection.__init__(self, title=title)

        self.parent = parent

        self.openfunc = openfunc

        self.cancel_button.connect('clicked', self.hide)
        self.ok_button.connect('clicked', self.ok_cb)

    def ok_cb(self, button):
        filename = self.get_filename()
        if os.path.isfile(filename):
            self.openfunc(filename)
        else:
            d = GnomeErrorDialog(error='Unable to open %s' % filename,
                                 parent=self.parent)
            d.set_close(click_closes=TRUE)
            d.run_and_close()
        self.hide()

    def hide(self, button=None):
        self.selection_entry.delete_text(0,-1)
        GtkFileSelection.hide(self)

