/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.FiltreExtension;
import Patristic.FrameDate;
import Patristic.JComponentCellEditor;
import Patristic.JComponentCellRenderer;
import Patristic.Loader;
import Patristic.Matrix;
import Patristic.MyTableModel2;
import Patristic.Opener;
import Patristic.PatristicApplet;
import Patristic.PatristicComputer;
import Patristic.PatristicComputerThread;
import Patristic.PlotFrame;
import Patristic.Polytomy;
import Patristic.ProgressBar;
import Patristic.Saver;
import Patristic.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Timer;
import net.iharder.dnd.FileDrop;

public class Patristic
extends JPanel {
    private JFrame frame = null;
    private PatristicApplet applet = null;
    private static final String PREVIOUS = "previous";
    private JMenuBar bar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem open = new JMenuItem("Open tree");
    private JMenu subLoad = new JMenu("Import");
    private JMenuItem loadMega = new JMenuItem("Mega");
    private JMenuItem loadDip = new JMenuItem("DIP");
    private JMenuItem loadPhylip = new JMenuItem("Phylip");
    private JMenu subPaup = new JMenu("PAUP");
    private JMenu subLoadM = new JMenu("Matrix");
    private JMenuItem loadMatrix1A = new JMenuItem("Ajusted");
    private JMenuItem loadMatrix1P = new JMenuItem("Patristic");
    private JMenuItem load = new JMenuItem("Column");
    private JMenu subSave = new JMenu("Save");
    private JMenuItem saveMat = new JMenuItem("Save matrix");
    private JMenuItem saveCol = new JMenuItem("Save column");
    private JMenuItem saveStep = new JMenuItem("Save steps");
    private JMenuItem saveTime = new JMenuItem("Save time");
    private JMenuItem saveDip = new JMenuItem("Save DIP");
    private JMenuItem saveR = new JMenuItem("Save multiple column");
    private JMenuItem delete = new JMenuItem("Delete");
    private JMenuItem close = new JMenuItem("Close");
    private JMenu graphMenu = new JMenu("Plot");
    private JMenuItem showPlot = new JMenuItem("Distance vs. Distance");
    private JMenuItem showTime = new JMenuItem("Distance vs. Time");
    private JMenu editMenu = new JMenu("Edit");
    private JMenuItem polytomy = new JMenuItem("Polytomy");
    private JMenuItem editDate = new JMenuItem("Time");
    private JMenuItem loadDate = new JMenuItem("Load time");
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem help = new JMenuItem("Help");
    private JTextField motif = new JTextField(40);
    private JButton launch = new JButton("Analyse");
    private Object[] tree;
    private int nbTip = 0;
    private int treep = 0;
    Vector tempName;
    int nbName = 0;
    final String fileSeparator = System.getProperty("file.separator");
    String[] columnIdentifiers = new String[]{"tree", "filename", "Matrix"};
    private MyTableModel2 myTableModel;
    private Table table;
    private JScrollPane scrollInput;
    private File path = new File(".");
    private JToolBar toolBar = null;
    Connection db = null;

    public Patristic(PatristicApplet applet) {
        this(applet, null);
    }

    public Patristic(PatristicApplet applet, GraphicsConfiguration gc) {
        this.applet = applet;
        if (!this.isApplet()) {
            new FileDrop((Component)this.motif, new FileDrop.Listener(){

                public void filesDropped(File[] files) {
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            String[] columnNames;
                            Opener open = new Opener(files[i].getCanonicalPath());
                            Patristic.this.path = new File(files[i].getAbsolutePath().substring(0, files[i].getCanonicalPath().lastIndexOf(Patristic.this.fileSeparator)));
                            String fileSeparator = System.getProperty("file.separator");
                            String fileName = files[i].getCanonicalPath().substring(files[0].getCanonicalPath().lastIndexOf(fileSeparator) + 1);
                            Patristic.access$102(Patristic.this, Patristic.this.stringToArray(open.getText(), open.isNexus()));
                            if (open.isNexus()) {
                                columnNames = open.getName(Patristic.this.nbTip);
                            } else {
                                columnNames = new String[Patristic.this.nbTip];
                                for (int j = 0; j < Patristic.this.nbName; ++j) {
                                    columnNames[j] = (String)Patristic.this.tempName.elementAt(j);
                                }
                            }
                            Matrix mat = PatristicComputer.getDistances(Patristic.this.tree, columnNames, fileName);
                            Patristic.this.myTableModel.addRow(mat);
                            Patristic.this.saveMat.setEnabled(true);
                            Patristic.this.saveCol.setEnabled(true);
                            Patristic.this.showTime.setEnabled(true);
                            Patristic.this.saveDip.setEnabled(true);
                            Patristic.this.saveR.setEnabled(true);
                            Patristic.this.saveTime.setEnabled(true);
                            Patristic.this.delete.setEnabled(true);
                            Patristic.this.saveStep.setEnabled(true);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.frame = new JFrame();
            this.frame.setDefaultCloseOperation(3);
        }
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 200));
        this.initialize();
        this.showPatristic();
    }

    public static JFrame createFrame(GraphicsConfiguration gc) {
        JFrame frame = new JFrame(gc);
        return frame;
    }

    public void showPatristic() {
        this.myTableModel.setColumnIdentifiers(this.columnIdentifiers);
        this.table.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.table.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        if (!this.isApplet()) {
            this.frame.getContentPane().add((Component)this, "Center");
            this.frame.setTitle("Patristic");
            this.frame.pack();
            this.frame.setVisible(true);
        }
    }

    public void initialize() {
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        this.bar = this.createBar();
        top.add((Component)this.bar, "North");
        this.toolBar = this.createToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        top.add((Component)this.toolBar, "Center");
        top.add((Component)this.motif, "South");
        this.myTableModel = new MyTableModel2();
        this.table = new Table(this.myTableModel);
        this.scrollInput = new JScrollPane(this.table);
        this.add((Component)this.scrollInput, "Center");
    }

    private JMenuBar createBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.fileMenu);
        this.fileMenu.add(this.open);
        this.open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.openFile();
            }
        });
        this.fileMenu.add(this.subLoad);
        this.loadMega.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.loadMega();
            }
        });
        this.subLoad.add(this.loadMega);
        this.subLoad.add(this.loadDip);
        this.loadDip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.loadDip();
            }
        });
        this.subLoad.add(this.loadPhylip);
        this.loadPhylip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.loadPhylip();
            }
        });
        this.subLoad.add(this.subPaup);
        this.subLoadM.add(this.loadMatrix1A);
        this.loadMatrix1A.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.loadMatrix(Loader.UPPERMATRIX);
            }
        });
        this.subLoadM.add(this.loadMatrix1P);
        this.loadMatrix1P.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.loadMatrix(Loader.LOWERMATRIX);
            }
        });
        this.subPaup.add(this.subLoadM);
        this.subPaup.add(this.load);
        this.load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.loadColumn();
            }
        });
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.subSave);
        this.saveMat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.save("matrix");
            }
        });
        this.saveMat.setEnabled(false);
        this.subSave.add(this.saveMat);
        this.subSave.add(this.saveTime);
        this.saveTime.setEnabled(false);
        this.saveTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.save("time");
            }
        });
        this.saveCol.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.save("line");
            }
        });
        this.saveCol.setEnabled(false);
        this.subSave.add(this.saveCol);
        this.saveR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.saveR();
            }
        });
        this.saveR.setEnabled(false);
        this.subSave.add(this.saveR);
        this.saveDip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.saveDip();
            }
        });
        this.saveDip.setEnabled(false);
        this.subSave.add(this.saveDip);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.delete);
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.delete();
            }
        });
        this.delete.setEnabled(false);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.close);
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.close();
            }
        });
        menuBar.add(this.graphMenu);
        this.graphMenu.add(this.showPlot);
        this.showPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.showPlot();
            }
        });
        this.editMenu.add(this.editDate);
        this.editDate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.editDate();
            }
        });
        this.editMenu.add(this.loadDate);
        this.loadDate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.loadDate();
            }
        });
        this.graphMenu.add(this.showTime);
        this.showTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Patristic.this.showTime();
            }
        });
        this.showTime.setEnabled(false);
        menuBar.add(this.editMenu);
        this.editMenu.add(this.polytomy);
        this.polytomy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Matrix list = null;
                if (Patristic.this.check() == 1) {
                    for (int i = 0; i < Patristic.this.myTableModel.getRowCount(); ++i) {
                        if (Patristic.this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                        list = (Matrix)Patristic.this.myTableModel.getValueAt(i, -1);
                        break;
                    }
                    Polytomy frame = new Polytomy(list);
                    frame.pack();
                    frame.setVisible(true);
                }
            }
        });
        menuBar.add(this.helpMenu);
        this.helpMenu.add(this.help);
        this.help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        return menuBar;
    }

    protected JToolBar createToolBar() {
        JButton button = null;
        JToolBar toolBar = new JToolBar("ToolBar");
        button = this.makeNavigationButton("Open16", "Load a tree", "Tree");
        toolBar.add(button);
        button = this.makeNavigationButton("Save16", "Save matrix", "Matrix");
        toolBar.add(button);
        button = this.makeNavigationButton("Delete16", "Delete tree", "Delete");
        toolBar.add(button);
        button = this.makeNavigationButton("Zoom16", "Show plot", "Plot");
        toolBar.add(button);
        button = this.makeNavigationButton("Edit16", "Edit Time", "edTime");
        toolBar.add(button);
        button = this.makeNavigationButton("Import16", "Compute", "compute");
        toolBar.add(button);
        return toolBar;
    }

    protected JButton makeNavigationButton(String imageName, String toolTipText, String altText) {
        String imgLocation = "/toolbarButtonGraphics/general/" + imageName + ".gif";
        URL imageURL = Patristic.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(altText);
        button.setToolTipText(toolTipText);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Tree")) {
                    Patristic.this.openFile();
                } else if (e.getActionCommand().equals("Mega")) {
                    Patristic.this.loadMega();
                } else if (e.getActionCommand().equals("Matrix")) {
                    Patristic.this.save("matrix");
                } else if (e.getActionCommand().equals("Time")) {
                    Patristic.this.save("time");
                } else if (e.getActionCommand().equals("Column")) {
                    Patristic.this.save("line");
                } else if (e.getActionCommand().equals("Delete")) {
                    Patristic.this.delete();
                } else if (e.getActionCommand().equals("Plot")) {
                    Patristic.this.showPlotButton();
                } else if (e.getActionCommand().equals("edTime")) {
                    Patristic.this.editDate();
                } else if (e.getActionCommand().equals("compute")) {
                    Patristic.this.compute();
                }
            }
        });
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            System.err.println("Resource not found: " + imgLocation);
        }
        return button;
    }

    private Object[] stringToArray(String str, boolean nexus) {
        Vector<String> arrayTemp = new Vector<String>();
        this.tempName = new Vector();
        int cellNb = -1;
        String wordTemp = "";
        this.nbTip = 0;
        this.nbName = 0;
        boolean bootstrap = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.substring(i, i + 1).compareTo(":") == 0 || str.substring(i, i + 1).compareTo(",") == 0 || str.substring(i, i + 1).compareTo("(") == 0 || str.substring(i, i + 1).compareTo(")") == 0 || str.substring(i, i + 1).compareTo(";") == 0) {
                ++cellNb;
                if (wordTemp.compareTo("") != 0) {
                    if (str.substring(i, i + 1).compareTo(":") == 0) {
                        if (!nexus) {
                            if (!arrayTemp.lastElement().equals(")")) {
                                this.tempName.add(wordTemp);
                                ++this.nbName;
                                arrayTemp.add(cellNb, String.valueOf(this.nbName));
                                ++this.nbTip;
                            } else {
                                arrayTemp.add(cellNb, wordTemp);
                            }
                            ++cellNb;
                        } else {
                            if (!arrayTemp.lastElement().equals(")")) {
                                ++this.nbTip;
                            }
                            arrayTemp.add(cellNb, wordTemp);
                            ++cellNb;
                        }
                    } else {
                        arrayTemp.add(cellNb, wordTemp);
                        ++cellNb;
                    }
                }
                wordTemp = "";
                arrayTemp.add(cellNb, str.substring(i, i + 1));
                continue;
            }
            wordTemp = wordTemp + str.substring(i, i + 1);
        }
        return arrayTemp.toArray();
    }

    private boolean isNumber(String nb) {
        try {
            Double.parseDouble(nb);
        }
        catch (NumberFormatException err) {
            return false;
        }
        return true;
    }

    private int check() {
        int nbChecked = 0;
        for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
            if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
            ++nbChecked;
        }
        return nbChecked;
    }

    private void loadDate() {
        Matrix theList = null;
        int nbTaxa = 0;
        if (this.check() == 1) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                theList = (Matrix)this.myTableModel.getValueAt(i, -1);
                break;
            }
            nbTaxa = theList.getNames().length;
            String[] date = new String[nbTaxa];
            JFileChooser opener = new JFileChooser();
            opener.setCurrentDirectory(this.path);
            opener.addChoosableFileFilter(new FiltreExtension("date", "Date file"));
            int returnVal = opener.showOpenDialog(this);
            if (returnVal == 0) {
                String pathFilename = opener.getSelectedFile().toString();
                this.path = opener.getCurrentDirectory();
                try {
                    String line = "";
                    boolean eof = false;
                    BufferedReader in = new BufferedReader(new FileReader(pathFilename));
                    int i = 0;
                    while (!eof) {
                        line = in.readLine();
                        if (line == null) {
                            eof = true;
                            continue;
                        }
                        if (line.equals("")) continue;
                        date[i] = line;
                        ++i;
                    }
                    in.close();
                    theList.setDate(date);
                    FrameDate frameDate = new FrameDate(theList);
                    frameDate.setVisible(true);
                }
                catch (IOException err) {
                    System.out.println("IO " + err.getMessage());
                }
                catch (NullPointerException err) {
                    err.printStackTrace();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "1 tree is needed");
        }
    }

    private void openFile() {
        JFileChooser opener = new JFileChooser();
        opener.setMultiSelectionEnabled(true);
        opener.setCurrentDirectory(this.path);
        opener.addChoosableFileFilter(new FiltreExtension("nex", "Nexus file"));
        opener.addChoosableFileFilter(new FiltreExtension("ph", "Ph file"));
        opener.addChoosableFileFilter(new FiltreExtension("tre", "Tre file"));
        int returnVal = opener.showOpenDialog(this);
        if (returnVal == 0) {
            File[] files = opener.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                String[] columnNames;
                this.path = opener.getCurrentDirectory();
                Opener open = new Opener(files[i].getAbsolutePath());
                String fileName = files[i].getAbsolutePath().substring(files[i].getAbsolutePath().lastIndexOf(this.fileSeparator) + 1);
                this.tree = this.stringToArray(open.getText(), open.isNexus());
                if (open.isNexus()) {
                    columnNames = open.getName(this.nbTip);
                } else {
                    columnNames = new String[this.nbTip];
                    for (int j = 0; j < this.nbName; ++j) {
                        columnNames[j] = (String)this.tempName.elementAt(j);
                    }
                }
                System.out.println("doing it");
                Matrix m = PatristicComputer.compute(open.getText(), "tree" + this.treep);
                this.myTableModel.addRow(m);
            }
        }
    }

    private void loadMega() {
        boolean begin = false;
        String pathFilename = "";
        JFileChooser opener = new JFileChooser();
        opener.setCurrentDirectory(this.path);
        opener.addChoosableFileFilter(new FiltreExtension("mega", "Mega file"));
        int returnVal = opener.showOpenDialog(this);
        if (returnVal == 0) {
            pathFilename = opener.getSelectedFile().toString();
            this.path = opener.getCurrentDirectory();
            Loader loader = new Loader(pathFilename, Loader.MEGA);
            this.myTableModel.addRow(loader.getList());
            this.saveMat.setEnabled(true);
            this.saveCol.setEnabled(true);
            this.showTime.setEnabled(true);
            this.saveDip.setEnabled(true);
            this.saveR.setEnabled(true);
            this.saveTime.setEnabled(true);
            this.delete.setEnabled(true);
            this.saveStep.setEnabled(true);
        }
    }

    private void loadColumn() {
        String pathFilename = "";
        JFileChooser opener = new JFileChooser();
        opener.setCurrentDirectory(this.path);
        opener.addChoosableFileFilter(new FiltreExtension("nex", "Nexus file"));
        int returnVal = opener.showOpenDialog(this);
        if (returnVal == 0) {
            pathFilename = opener.getSelectedFile().toString();
            this.path = opener.getCurrentDirectory();
            Loader loader = new Loader(pathFilename, Loader.COLUMN);
            this.myTableModel.addRow(loader.getList());
            this.saveMat.setEnabled(true);
            this.saveCol.setEnabled(true);
            this.showTime.setEnabled(true);
            this.saveDip.setEnabled(true);
            this.saveR.setEnabled(true);
            this.saveTime.setEnabled(true);
            this.delete.setEnabled(true);
            this.saveStep.setEnabled(true);
        }
    }

    private void loadDip() {
        String pathFilename = "";
        JFileChooser opener = new JFileChooser();
        opener.setCurrentDirectory(this.path);
        opener.addChoosableFileFilter(new FiltreExtension("dip", "Dip file"));
        int returnVal = opener.showOpenDialog(this);
        if (returnVal == 0) {
            pathFilename = opener.getSelectedFile().toString();
            this.path = opener.getCurrentDirectory();
            Loader loader = new Loader(pathFilename, Loader.DIPLOMO);
            this.myTableModel.addRow(loader.getList());
            this.saveMat.setEnabled(true);
            this.saveCol.setEnabled(true);
            this.showTime.setEnabled(true);
            this.saveDip.setEnabled(true);
            this.saveR.setEnabled(true);
            this.saveTime.setEnabled(true);
            this.delete.setEnabled(true);
            this.saveStep.setEnabled(true);
        }
    }

    private void loadPhylip() {
        String pathFilename = "";
        JFileChooser opener = new JFileChooser();
        opener.setCurrentDirectory(this.path);
        opener.addChoosableFileFilter(new FiltreExtension("tre", "Phylip file"));
        int returnVal = opener.showOpenDialog(this);
        if (returnVal == 0) {
            pathFilename = opener.getSelectedFile().toString();
            this.path = opener.getCurrentDirectory();
            Loader loader = new Loader(pathFilename, Loader.PHYLIP);
            this.myTableModel.addRow(loader.getList());
            this.saveMat.setEnabled(true);
            this.saveCol.setEnabled(true);
            this.showTime.setEnabled(true);
            this.saveDip.setEnabled(true);
            this.saveR.setEnabled(true);
            this.saveTime.setEnabled(true);
            this.delete.setEnabled(true);
            this.saveStep.setEnabled(true);
        }
    }

    private void loadMatrix(int what) {
        String pathFilename = "";
        JFileChooser opener = new JFileChooser();
        opener.setCurrentDirectory(this.path);
        opener.addChoosableFileFilter(new FiltreExtension("txt", "Nexus file"));
        int returnVal = opener.showOpenDialog(this);
        if (returnVal == 0) {
            pathFilename = opener.getSelectedFile().toString();
            this.path = opener.getCurrentDirectory();
            Loader loader = new Loader(pathFilename, what);
            this.myTableModel.addRow(loader.getList());
            this.saveMat.setEnabled(true);
            this.saveCol.setEnabled(true);
            this.showTime.setEnabled(true);
            this.saveDip.setEnabled(true);
            this.saveR.setEnabled(true);
            this.saveTime.setEnabled(true);
            this.delete.setEnabled(true);
            this.saveStep.setEnabled(true);
        }
    }

    private void save(String format) {
        String formatSend = "";
        Matrix theList = null;
        if (this.check() == 1) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                theList = (Matrix)this.myTableModel.getValueAt(i, -1);
                break;
            }
            if (format.compareTo("matrix") == 0) {
                formatSend = theList.toMatrix();
            } else if (format.compareTo("line") == 0) {
                formatSend = theList.toColumn("line");
            } else if (format.compareTo("time") == 0) {
                formatSend = theList.toColumn("time");
            } else if (format.compareTo("step") == 0) {
                formatSend = theList.toColumn("step");
            }
            Saver save = new Saver(formatSend, this.path);
            this.path = save.getPathFileChooser();
        } else {
            JOptionPane.showMessageDialog(this, "1 tree is needed");
        }
    }

    private void saveDip() {
        Matrix theList = null;
        StringBuffer str = new StringBuffer();
        int nb = this.check();
        boolean addNames = true;
        if (nb >= 1) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                theList = (Matrix)this.myTableModel.getValueAt(i, -1);
                str.append(theList.toDipFormat(addNames));
                if (nb <= 1) continue;
                addNames = false;
            }
            Saver save = new Saver(str.toString(), this.path);
            this.path = save.getPathFileChooser();
        } else {
            JOptionPane.showMessageDialog(this, "1 tree at least is needed");
        }
    }

    private void saveR() {
        Matrix theList = null;
        StringBuffer str = new StringBuffer();
        int nb = this.check();
        boolean addNames = true;
        int nbb = 0;
        str.append("tax1,tax2");
        if (nb >= 1) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                theList = (Matrix)this.myTableModel.getValueAt(i, -1);
                nbb = theList.getNames().length;
                str.append("," + theList.getFileName());
            }
            for (int j = 0; j < nbb; ++j) {
                for (int k = j + 1; k < nbb; ++k) {
                    str.append("\n" + theList.getNames()[j] + "," + theList.getNames()[k] + ",");
                    for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                        if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                        theList = (Matrix)this.myTableModel.getValueAt(i, -1);
                        str.append(theList.getMatrix()[j][k] + ",");
                    }
                }
            }
            Saver save = new Saver(str.toString(), this.path);
            this.path = save.getPathFileChooser();
        } else {
            JOptionPane.showMessageDialog(this, "1 tree at least is needed");
        }
    }

    private void editDate() {
        Matrix theList = null;
        if (this.check() == 1) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                theList = (Matrix)this.myTableModel.getValueAt(i, -1);
                break;
            }
            FrameDate frameDate = new FrameDate(theList);
            frameDate.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "1 tree is needed");
        }
    }

    private void delete() {
        int result = JOptionPane.showConfirmDialog(null, "Are you sure?", "", 0);
        if (result == 0) {
            for (int i = this.myTableModel.getRowCount() - 1; i >= 0; --i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                this.myTableModel.removeRow(i);
            }
        }
    }

    private void showPlotButton() {
        Matrix theList1 = null;
        Matrix theList2 = null;
        if (this.check() == 1) {
            this.showTime();
        } else if (this.check() == 2) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                if (theList1 == null) {
                    theList1 = (Matrix)this.myTableModel.getValueAt(i, -1);
                    continue;
                }
                theList2 = (Matrix)this.myTableModel.getValueAt(i, -1);
            }
            PlotFrame plot = new PlotFrame(theList1, theList2);
            plot.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "2 trees are needed");
        }
    }

    private void showPlot() {
        Matrix theList1 = null;
        Matrix theList2 = null;
        if (this.check() == 2) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0) continue;
                if (theList1 == null) {
                    theList1 = (Matrix)this.myTableModel.getValueAt(i, -1);
                    continue;
                }
                theList2 = (Matrix)this.myTableModel.getValueAt(i, -1);
            }
            PlotFrame plot = new PlotFrame(theList1, theList2);
            plot.setVisible(true);
        } else if (this.myTableModel.getRowCount() == 2) {
            theList1 = (Matrix)this.myTableModel.getValueAt(0, -1);
            theList2 = (Matrix)this.myTableModel.getValueAt(1, -1);
            PlotFrame plot = new PlotFrame(theList1, theList2);
            plot.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "2 trees are needed");
        }
    }

    private void showTime() {
        Matrix list = null;
        boolean pb = false;
        if (this.check() == 1) {
            int i;
            for (i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.table.getModel().getValueAt(i, 0).toString().compareTo("true") != 0 || list != null) continue;
                list = (Matrix)this.myTableModel.getValueAt(i, -1);
            }
            for (i = 0; i < list.getDate().length; ++i) {
                if (!list.getDate()[i].equals("")) continue;
                JOptionPane.showMessageDialog(this, "Date not set: \n" + list.getNames()[i]);
                pb = true;
                break;
            }
            if (!pb) {
                PlotFrame plot = new PlotFrame(list);
                plot.setVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(this, "1 tree is needed");
        }
    }

    private void close() {
        int result = JOptionPane.showConfirmDialog(null, "Are you sure?", "", 0);
        if (result == 0) {
            System.exit(0);
        }
    }

    private void compute() {
        if (this.motif.getText().compareTo("") != 0) {
            this.tree = this.stringToArray(this.motif.getText(), false);
            String[] columnNames = new String[this.nbTip];
            for (int i = 0; i < this.nbName; ++i) {
                columnNames[i] = (String)this.tempName.elementAt(i);
            }
            ++this.treep;
            Matrix mat = PatristicComputer.getDistances(this.tree, columnNames, "tree" + this.treep);
            this.myTableModel.addRow(mat);
            this.saveMat.setEnabled(true);
            this.saveCol.setEnabled(true);
            this.showTime.setEnabled(true);
            this.saveDip.setEnabled(true);
            this.saveR.setEnabled(true);
            this.saveTime.setEnabled(true);
            this.delete.setEnabled(true);
            this.saveStep.setEnabled(true);
        }
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public static void main(String[] args) {
        Patristic patristicFrame = new Patristic(null, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    public static Image loadImage(String fileName) {
        return Toolkit.getDefaultToolkit().getImage("toolbarButtonGraphics" + File.separator + "general" + File.separator + fileName);
    }

    static /* synthetic */ Object[] access$102(Patristic x0, Object[] x1) {
        x0.tree = x1;
        return x1;
    }

    class TimerListener
    implements ActionListener {
        ProgressBar progressBar;
        PatristicComputerThread task;
        Timer timer;

        TimerListener(ProgressBar progressBar, PatristicComputerThread task, Timer timer) {
            this.progressBar = progressBar;
            this.task = task;
            this.timer = timer;
        }

        public void actionPerformed(ActionEvent evt) {
            this.progressBar.progressBar.setValue(this.task.getCurrent());
            if (this.task.isDone()) {
                Toolkit.getDefaultToolkit().beep();
                this.timer.stop();
                Patristic.this.myTableModel.addRow(this.task.getMatrix());
                this.progressBar.setVisible(false);
                Patristic.this.saveMat.setEnabled(true);
                Patristic.this.saveCol.setEnabled(true);
                Patristic.this.showTime.setEnabled(true);
                Patristic.this.saveDip.setEnabled(true);
                Patristic.this.saveR.setEnabled(true);
                Patristic.this.saveTime.setEnabled(true);
                Patristic.this.delete.setEnabled(true);
                Patristic.this.saveStep.setEnabled(true);
            }
        }
    }
}

