/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.tree.Node;
import Patristic.tree.Tree;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static Tree createTree(String newick) throws Exception {
        Vector<Node> taxa = new Vector<Node>();
        if (!newick.endsWith(";")) {
            newick = newick + ";";
        }
        String[] newickArray = Utils.stringToArray(newick);
        Stack<Node> stack = new Stack<Node>();
        boolean isBoot = false;
        Pattern p = Pattern.compile("^:(.+)\\[(.+)\\]$");
        Matcher m = p.matcher("");
        for (int i = 0; i < newickArray.length && !newickArray[i].equals(";"); ++i) {
            if (newickArray[i].equals("(")) {
                Node node = new Node();
                if (!stack.empty()) {
                    ((Node)stack.peek()).getChildren().addElement(node);
                    node.setParent((Node)stack.peek());
                }
                stack.push(node);
                continue;
            }
            if (newickArray[i].equals(")")) {
                if (newickArray[i + 1].equals(";")) break;
                if (newickArray[i + 1].startsWith(":")) {
                    m.reset(newickArray[i + 1]);
                    if (m.find()) {
                        ((Node)stack.peek()).setBrlens(Double.valueOf(m.group(1)));
                        ((Node)stack.peek()).setBootstrap(Double.valueOf(m.group(2)));
                        isBoot = true;
                    } else {
                        ((Node)stack.peek()).setBrlens(Double.valueOf(newickArray[i + 1].substring(1)));
                    }
                    ++i;
                } else if (newickArray[i + 1].contains(":")) {
                    String[] temp = newickArray[i + 1].split(":");
                    ((Node)stack.peek()).setBrlens(Double.valueOf(temp[1]));
                    ((Node)stack.peek()).setBootstrap(Double.valueOf(temp[0]));
                    ++i;
                    isBoot = true;
                }
                stack.pop();
                continue;
            }
            if (newickArray[i].equals(",")) continue;
            String[] split = newickArray[i].split(":");
            Node node = new Node(split[0]);
            taxa.addElement(node);
            if (split.length != 1) {
                node.setBrlens(Double.valueOf(split[1]));
            }
            ((Node)stack.peek()).getChildren().addElement(node);
            node.setParent((Node)stack.peek());
        }
        Tree tree = new Tree(newick);
        tree.setTree((Node)stack.pop());
        if (newick.contains(":")) {
            tree.isBrlens = true;
        }
        tree.isBootstrap = isBoot;
        tree.setTaxa(taxa);
        return tree;
    }

    private static String[] stringToArray(String str) throws Exception {
        Vector<String> arrayTemp = new Vector<String>();
        String wordTemp = "";
        int bracket = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ',' || str.charAt(i) == '(' || str.charAt(i) == ')' || str.charAt(i) == ';') {
                if (wordTemp.compareTo("") != 0) {
                    arrayTemp.add(wordTemp);
                }
                wordTemp = "";
                arrayTemp.add(str.substring(i, i + 1));
                if (str.charAt(i) == '(') {
                    ++bracket;
                    continue;
                }
                if (str.charAt(i) != ')') continue;
                --bracket;
                continue;
            }
            wordTemp = wordTemp + str.substring(i, i + 1);
        }
        if (bracket > 0) {
            throw new Exception("Newick tree malformated: more (");
        }
        if (bracket < 0) {
            throw new Exception("Newick tree malformated: more )");
        }
        return arrayTemp.toArray(new String[arrayTemp.size()]);
    }
}

