/*
 * Decompiled with CFR 0.152.
 */
package Patristic.tree;

import Patristic.tree.Node;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree {
    private String tree = "default";
    public double depth = -1.0;
    public int length = -1;
    public boolean isBootstrap = false;
    public boolean isBrlens = false;
    private Node root = null;
    private Vector<Node> refTaxa = new Vector();
    private Hashtable<String, Node> nameLookup = new Hashtable();

    public Tree(String t) {
        this.tree = t;
    }

    public Tree() {
        this.tree = "default";
    }

    public void setTree(Node node) {
        this.root = node;
    }

    public void setTaxa(Vector<Node> vec) {
        this.refTaxa = vec;
    }

    public void setNameLookup(Hashtable<String, Node> lookup) {
        this.nameLookup = lookup;
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node r) {
        this.root = r;
    }

    public double getDepth() {
        if (this.depth == -1.0) {
            return this.getDepth(this.root);
        }
        return this.depth;
    }

    public int getLength() {
        if (this.length == -1) {
            return this.getLength(this.root);
        }
        return this.length;
    }

    public int getLength(Node tree) {
        int depth = 0;
        int max = 0;
        max = this.getLengthAux(tree, depth, max);
        return max;
    }

    private int getLengthAux(Node tree, int depth, int max) {
        if (tree != null) {
            if (tree.getName() != null & ++depth > max) {
                max = depth;
            }
            Iterator<Node> it = tree.getChildren().iterator();
            while (it.hasNext()) {
                max = this.getLengthAux(it.next(), depth, max);
            }
            --depth;
        }
        return max;
    }

    public double getDepth(Node tree) {
        double depth = 0.0;
        double max = 0.0;
        max = this.getDepthAux(tree, depth, max);
        return max;
    }

    private double getDepthAux(Node tree, double depth, double max) {
        if (tree != null) {
            if (tree.getName() != null & (depth += tree.getBrlens()) > max) {
                max = depth;
            }
            Iterator<Node> it = tree.getChildren().iterator();
            while (it.hasNext()) {
                max = this.getDepthAux(it.next(), depth, max);
            }
            depth -= tree.getBrlens();
        }
        return max;
    }

    public String getNewick() {
        StringBuffer newick = new StringBuffer();
        this.getNewick(this.root, newick);
        return newick.toString();
    }

    private void getNewick(Node tree, StringBuffer newick) {
        if (tree == null) {
            return;
        }
        if (tree.getName() != null) {
            newick.append(tree.getName()).append(":").append(tree.getBrlens());
            return;
        }
        newick.append("(");
        Iterator<Node> it = tree.getChildren().iterator();
        while (it.hasNext()) {
            this.getNewick(it.next(), newick);
            if (!it.hasNext()) continue;
            newick.append(",");
        }
        newick.append("):").append(tree.getBrlens());
    }

    public Vector<Node> getTaxa() {
        return this.refTaxa;
    }

    public Hashtable<String, Node> getNameLookup() {
        return this.nameLookup;
    }

    public void reroot(Node node) {
        if (node.getParent().isRoot()) {
            return;
        }
        this.reroot(node.getParent());
        this.setRoot(node.getParent());
    }

    private void reroot_aux(Node node) {
        if (node.isRoot() || node.isLeaf()) {
            return;
        }
        if (!node.getParent().isRoot()) {
            this.reroot_aux(node.getParent());
        }
        double brlens = node.getParent().getBrlens();
        node.getParent().setBrlens(node.getBrlens());
        node.setBrlens(brlens);
        double bootstrap = node.getParent().getBootstrap();
        node.getParent().setBootstrap(node.getBootstrap());
        node.setBootstrap(bootstrap);
        Node parent = node.getParent();
        parent.removeChild(node);
        node.addChild(parent);
        parent.setParent(node);
    }
}

