/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class FrameMatrix
extends JFrame {
    public JScrollPane scroll;
    private JTextPane textPane = new JTextPane();
    String[][] data;
    Vector columnName;
    JTable table;
    int rowFrom;
    int rowTo;
    int columnFrom;
    int columnTo;
    Matrix localList;
    Vector<String> time = new Vector();

    public FrameMatrix(Matrix list) {
        this.localList = list;
        for (int i = 0; i < list.getDate().length; ++i) {
            this.time.addElement(list.getDate()[i]);
        }
        this.setSize(600, 400);
        this.setResizable(true);
        this.setTitle("Patristic distances: " + list.getFileName() + " (SBL:" + list.getSBL() + ")");
        Container pane = this.getContentPane();
        this.columnName = new Vector(list.getNames().length + 1);
        this.columnName.add("");
        for (int i = 0; i < list.getNames().length; ++i) {
            this.columnName.add(list.getNames()[i]);
        }
        MyDefaultTableModel model = new MyDefaultTableModel(list.toArrayVector(), this.columnName);
        this.table = new JTable(model);
        this.table.setModel(model);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    System.err.println("MOVE");
                    FrameMatrix.this.tableMousePressed(evt);
                } else if (evt.getButton() == 3) {
                    System.err.println("DELEETE");
                    FrameMatrix.this.deleteRow(evt);
                    FrameMatrix.this.deleteColumn(evt);
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    FrameMatrix.this.tableMouseReleased(evt);
                }
            }
        });
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.scroll = new JScrollPane(this.table);
        pane.add((Component)this.scroll, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FrameMatrix.this.changeMatrix();
            }
        });
    }

    private void changeMatrix() {
        this.localList.setMatrix(this.toSimpleMatrix());
    }

    private void tableMousePressed(MouseEvent evt) {
        this.rowFrom = this.table.rowAtPoint(evt.getPoint());
    }

    private void deleteRow(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (this.time.size() != 0) {
            this.time.remove(row);
        }
        ((MyDefaultTableModel)this.table.getModel()).removeRow(row);
        ((MyDefaultTableModel)this.table.getModel()).fireTableRowsDeleted(row, row);
    }

    private void deleteColumn(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        this.removeColumnAndData(this.table, row);
    }

    public void removeColumnAndData(JTable table, int vColIndex) {
        MyDefaultTableModel model = (MyDefaultTableModel)table.getModel();
        TableColumn col = table.getColumnModel().getColumn(vColIndex + 1);
        int columnModelIndex = col.getModelIndex();
        Vector<Vector> data = model.getDataVector();
        Vector colIds = model.getColumnIdentifiers();
        table.removeColumn(col);
        colIds.removeElementAt(columnModelIndex);
        for (int r = 0; r < data.size(); ++r) {
            Vector row = data.get(r);
            row.removeElementAt(columnModelIndex);
        }
        model.setDataVector(data, colIds);
        Enumeration<TableColumn> enume = table.getColumnModel().getColumns();
        while (enume.hasMoreElements()) {
            TableColumn c = enume.nextElement();
            if (c.getModelIndex() < columnModelIndex) continue;
            c.setModelIndex(c.getModelIndex() - 1);
        }
        model.fireTableStructureChanged();
    }

    private void tableMouseReleased(MouseEvent evt) {
        this.rowTo = this.table.rowAtPoint(evt.getPoint());
        this.columnTo = this.table.columnAtPoint(evt.getPoint());
        if (this.rowTo != this.rowFrom && this.rowTo > -1 && this.rowTo < this.table.getRowCount()) {
            String element = this.time.remove(this.rowFrom);
            if (this.rowFrom > this.rowTo) {
                System.out.println("1");
                this.time.insertElementAt(element, this.rowTo);
            } else {
                System.out.println("22");
                this.time.insertElementAt(element, this.rowTo);
            }
            ((DefaultTableModel)this.table.getModel()).moveRow(this.rowFrom, this.rowFrom, this.rowTo);
            this.table.moveColumn(this.rowFrom + 1, this.rowTo + 1);
            this.rowFrom = this.rowTo;
        }
    }

    private BigDecimal[][] toSimpleMatrix() {
        BigDecimal[][] temp = new BigDecimal[this.columnName.size() - 1][this.columnName.size() - 1];
        BigDecimal[][] temp2 = new BigDecimal[this.columnName.size() - 1][this.columnName.size() - 1];
        String[] newOrderName = new String[this.columnName.size() - 1];
        String[] tempDate = this.time.toArray(new String[this.time.size()]);
        for (int j = 0; j < this.columnName.size() - 1; ++j) {
            newOrderName[j] = ((DefaultTableModel)this.table.getModel()).getValueAt(j, 0).toString();
        }
        this.localList.setNames(newOrderName);
        for (int i = 0; i < this.columnName.size() - 1; ++i) {
            for (int j = 1; j < this.columnName.size(); ++j) {
                temp[i][j - 1] = new BigDecimal(((DefaultTableModel)this.table.getModel()).getValueAt(i, j).toString());
            }
        }
        this.localList.setDate(tempDate);
        return temp;
    }

    class MyDefaultTableModel
    extends DefaultTableModel {
        public MyDefaultTableModel(Vector data, Vector names) {
            super(data, names);
        }

        public Vector getColumnIdentifiers() {
            return this.columnIdentifiers;
        }
    }
}

