/*
 * Decompiled with CFR 0.152.
 */
package Patristic;

import Patristic.Matrix;
import Patristic.Utils;
import Patristic.tree.Node;
import Patristic.tree.Tree;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatristicComputer {
    static BigDecimal sbl = new BigDecimal("0");

    public static Matrix compute(String nexus, String fileName) {
        Matrix matrix = null;
        try {
            Tree tree = Utils.createTree(nexus);
            BigDecimal[][] matrixClade = new BigDecimal[tree.getTaxa().size()][tree.getTaxa().size()];
            long begin = System.currentTimeMillis();
            for (int i = 0; i < tree.getTaxa().size(); ++i) {
                for (int j = 0; j < tree.getTaxa().size(); ++j) {
                    matrixClade[i][j] = new BigDecimal("0");
                }
            }
            Vector names = new Vector();
            PatristicComputer.computeAux(tree.getRoot(), tree.getTaxa().size(), matrixClade, names);
            matrix = new Matrix(names.toArray(new String[names.size()]), fileName);
            matrix.setMatrix(matrixClade);
            long end = System.currentTimeMillis();
            long time = end - begin;
            System.out.println("Processing time " + time);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return matrix;
    }

    private static void computeAux(Node node, int N, BigDecimal[][] matrixClade, Vector names) {
        if (node.getName() != null) {
            names.add(node.getName());
            for (int i = 0; i < N; ++i) {
                if (i == names.size() - 1) continue;
                matrixClade[names.size() - 1][i] = matrixClade[names.size() - 1][i].add(BigDecimal.valueOf(node.getBrlens()));
                matrixClade[i][names.size() - 1] = matrixClade[names.size() - 1][i];
            }
        }
        Iterator<Node> it = node.getChildren().iterator();
        while (it.hasNext()) {
            PatristicComputer.computeAux(it.next(), N, matrixClade, names);
        }
        if (node.getName() == null) {
            Vector<Integer> children = new Vector<Integer>();
            PatristicComputer.getChildrenName(node, children, names);
            for (int i = 0; i < N; ++i) {
                for (int j = i + 1; j < N; ++j) {
                    if (!(children.contains(i) ^ children.contains(j))) continue;
                    matrixClade[i][j] = matrixClade[i][j].add(BigDecimal.valueOf(node.getBrlens()));
                    matrixClade[j][i] = matrixClade[i][j];
                }
            }
        }
    }

    private static void getChildrenName(Node node, Vector<Integer> clusters, Vector names) {
        if (node.getName() != null) {
            clusters.add(names.indexOf(node.getName()));
        }
        Iterator<Node> it = node.getChildren().iterator();
        while (it.hasNext()) {
            PatristicComputer.getChildrenName(it.next(), clusters, names);
        }
    }

    public static Matrix getDistances(Object[] nexus, String[] names, String fileName) {
        Matrix matrix = new Matrix(names, fileName);
        BigDecimal[][] matrixClade = new BigDecimal[names.length][names.length];
        long begin = System.currentTimeMillis();
        for (int i = 0; i < names.length; ++i) {
            for (int j = 0; j < names.length; ++j) {
                matrixClade[i][j] = new BigDecimal("0");
            }
        }
        Vector cladeList = new Vector();
        Vector<String> cladeOpen = new Vector<String>();
        Vector stack = new Vector();
        String word = "";
        for (int i = 0; i < nexus.length; ++i) {
            int j;
            int z;
            int j2;
            word = nexus[i].toString();
            if (word.equalsIgnoreCase("(")) {
                cladeList.addElement(new Vector());
                cladeOpen.addElement("true");
                continue;
            }
            if (PatristicComputer.isNumber(word) && (nexus[i - 1].toString().equals("(") || nexus[i - 1].toString().equals(","))) {
                for (int j3 = 0; j3 < cladeList.size(); ++j3) {
                    if (!cladeOpen.elementAt(j3).equals("true")) continue;
                    ((Vector)cladeList.elementAt(j3)).add(word);
                }
                continue;
            }
            if (word.equals(":") || word.equals(",") || word.equals(")") || PatristicComputer.isNumber(word) && nexus[i - 1].toString().equals(")")) continue;
            if (PatristicComputer.isNumber(word) && PatristicComputer.isNumber(nexus[i - 2].toString()) && nexus[i - 3].toString().equals(")")) {
                sbl = sbl.add(new BigDecimal(word).abs());
                Vector clade = new Vector();
                for (j2 = cladeOpen.size() - 1; j2 >= 0; --j2) {
                    if (!cladeOpen.elementAt(j2).equals("true")) continue;
                    cladeOpen.setElementAt("false", j2);
                    clade = (Vector)cladeList.elementAt(j2);
                    break;
                }
                for (z = 0; z < names.length; ++z) {
                    for (j = z + 1; j < names.length; ++j) {
                        if (clade.contains(String.valueOf(j + 1)) && clade.contains(String.valueOf(z + 1)) || !clade.contains(String.valueOf(j + 1)) && !clade.contains(String.valueOf(z + 1))) continue;
                        matrixClade[j][z] = matrixClade[j][z].add(new BigDecimal(word).abs());
                        matrixClade[z][j] = matrixClade[z][j].add(new BigDecimal(word).abs());
                    }
                }
                continue;
            }
            if (PatristicComputer.isNumber(word) && PatristicComputer.isNumber(nexus[i - 2].toString())) {
                sbl = sbl.add(new BigDecimal(word).abs());
                int taxon = Integer.parseInt(nexus[i - 2].toString());
                for (int y = 0; y < names.length; ++y) {
                    if (y == taxon - 1) continue;
                    matrixClade[taxon - 1][y] = matrixClade[taxon - 1][y].add(new BigDecimal(word).abs());
                }
                for (int x = 0; x < names.length; ++x) {
                    if (x == taxon - 1) continue;
                    matrixClade[x][taxon - 1] = matrixClade[x][taxon - 1].add(new BigDecimal(word).abs());
                }
                continue;
            }
            if (!PatristicComputer.isNumber(word) || !nexus[i - 2].toString().equals(")")) continue;
            sbl = sbl.add(new BigDecimal(word).abs());
            Vector clade = new Vector();
            for (j2 = cladeOpen.size() - 1; j2 >= 0; --j2) {
                if (!cladeOpen.elementAt(j2).equals("true")) continue;
                cladeOpen.setElementAt("false", j2);
                clade = (Vector)cladeList.elementAt(j2);
                break;
            }
            for (z = 0; z < names.length; ++z) {
                for (j = z + 1; j < names.length; ++j) {
                    if (clade.contains(String.valueOf(j + 1)) && clade.contains(String.valueOf(z + 1)) || !clade.contains(String.valueOf(j + 1)) && !clade.contains(String.valueOf(z + 1))) continue;
                    matrixClade[j][z] = matrixClade[j][z].add(new BigDecimal(word).abs());
                    matrixClade[z][j] = matrixClade[z][j].add(new BigDecimal(word).abs());
                }
            }
        }
        long end = System.currentTimeMillis();
        long time = end - begin;
        System.out.println("Processing time " + time);
        matrix.setMatrix(matrixClade);
        matrix.setSbl(sbl);
        return matrix;
    }

    private static boolean isNumber(String nb) {
        try {
            Double.parseDouble(nb);
        }
        catch (NumberFormatException err) {
            return false;
        }
        return true;
    }
}

