<?php 

/*
LabWiki 1.2.1, 22 August 2012, by Santosh Patnaik, MD, PhD. Based on QwikiWiki 1.5 of David Barrett
*/

/*

Configure LabWiki here

*/

// Change appropriately. Note that the password and username will be stored without encryption, so protect this _config.php file. The 'sinceDate' value can be something like '20 May 2011' to indicate the date of the wiki installation
$QW_CONFIG['title'] = 'My lab wiki';
$QW_CONFIG['adminName'] = 'xxx'; 
$QW_CONFIG['adminPassword'] = 'xxx';
$QW_CONFIG['sinceDate'] = 'xxx';

// Allowed IP addresses - users from only these IP addresses will see the 'edit this page' link. Note that they can still edit the page by typing in the right web address, unless you set the right parameter in the next configurable variable in the next section (below). If you don't want this type of restriction, empty the array - deleting all comma-separated, double-quote-enclosed addresses. Else, put in addresses in comma-separated, double-quotes, such as - '129.98.50.211', '127.0.0.1', '129.98.51.136'

$QW_CONFIG['ipArray'] = array();

// Set web-page encoding; generally, leave as it is
$QW_CONFIG['encoding'] = 'utf-8';

// Debugging - Enable this if you want to allow 'debug=true' to be added to any URI such as to output debugging information.

$QW_CONFIG['enableDebugging'] = false;

// PHP error notifications - Enable (true) to view PHP errors/notices

$QW_CONFIG['enablePHPErrs'] = false;

// If you want the above IP addresses to really be used to restrict editing (and not just showing the link; see above section), set the variable below to 'yes'; else, set to false by typing in 'no' (without the quotes)

$QW_CONFIG['ipRestrictsEditing'] = 'no';

// Set this to be the name of the page that is mapped to the 'home' or 'front' page

$QW_CONFIG['startPage'] = 'Home';

// Global navigation; depending on the template used, is a list of key pages / links presented to the user at top of all pages. This is an array of text blocks that will be run through the Wiki-parser. Thus it can be any wiki page name, URL, HTML tag, etc.

$QW_CONFIG['globalNav'] = array(
'_Home_', 
'_What_is_Wiki_',
'_Adding_or_editing_content_',
'<a href="recentchanges.php">All documents</a>',
'<a href="index.php?page=Disclaimer">Disclaimer</a>',
'<a href="../index.htm">My Lab</a>'
);

// Wiki locking - For outward-facing wikis, disables editing on pages that are not password-protected. Enable this if you want to prevent all non-admin modifications. This is a useful feature if you're using LabWiki to just create your own personal website, and don't want to allow anyone else to edit it. Alternatively, if leave the globalEditLock disabled, you can selectively protect pages from public editing by clicking the appropriate checkbox while editing a page in admin mode (logged in with the admin password)

$QW_CONFIG['globalEditLock'] = false;

// File attachments - If enabled, editors can upload files to a private directory created for that page. Thus stored, typing the name of the file into the page source creates a link to that file. If the file happens to be an image (gif, jpg, png, jpeg), it will also be embedded inline. For security reasons, you can set the list of acceptable file extensions (so as to prevent, say, .php files from being uploaded).

$QW_CONFIG['enableAttach'] = true;
$QW_CONFIG['maxUploadSize'] = 10 * 1024 * 1024; // 10MB
$QW_CONFIG['acceptableExtensions'] = array(
'gif', 'jpg', 'zip', 'doc', 'txt', 'mov', 'psd', 'ppt', 'pdf', 'xls', 'tif', 'png', 'jpeg'
);

// Meta tags - content and keywords; these are addede to the <head> block of the HTML pages and are used by search engines, etc.

$QW_CONFIG['metaContent'] = 'Methods, protocols, techniques, tutorials and other information for biomedical students and researchers';

$QW_CONFIG['metaKeywords'] = 'protocols, molecular biology, rna, dna, protein, cell biology, glycobiology, spectrometry, page, blotting, antibodies, how, writing, presentation, transfection, ligation, purification, probe, mouse, cell, biomedical, biology, methods, techniques, protocol, links, bioinformatics, wiki, glycosylation, development, cancer';

// Template

$QW_CONFIG['templateFilename'] = '_widelogo_template.php';
$QW_CONFIG['templateLogo'] = 'LabWiki_logo.gif';

// Note that further customization may require editing the template file specified above

// Stylesheet

$QW_CONFIG['stylesheetFilename'] = 'labstyle.css';

// Acceptable HTML tags - other tags will be stripped. For XHTML compatibility, the b and i tags should not be allowed

$QW_CONFIG['acceptableHTMLTags'] = '<span><a><em><strong><col><colgroup><img><code><br><p><table><tr><td><div><sup><sub>';

// Lockfile expiration - specify the timeout duration for lockfiles. When a page is being edited, a lockfile is created (so others cannot edit or delete it). If this is too short, people might lose the lock while still editing. If this is too long, dead locks (from starting to edit and closing the window, for example) will block out any editing.

$QW_CONFIG['editLockfileExpiration'] = 60 * 30; // a half hour

// QwikiTag patterns - set this to be the list of word patterns to automatically treat as wiki pages. Note, this the first matching pattern will be used as the display name of the wiki page and also the name of the file on disk (after appending '.qwiki'). Thus, make sure you only match patterns that you want to visually display, and that make valid filenames.

$QW_CONFIG['tagPatternArray'] = array( 
//'/(^|[^\w_\/]+)([A-Z]+[a-z\d]+[A-Z]+\w*)($|[^\w_\/]+)/', // CamelBack
'/(^|\W+)_([\w-]+(?:_[\w-]+)*)_($|\W+)/' // Underscore
);

// To enable CamelBack, remove the two slashes (//) at front of the top line above. That is any word in camel-case (such as WhatIsThis, NaCl, etc.) will be looked up as a possible wiki page

// Pattern used to validate the file name given by the 'page' request parameter

$QW_CONFIG['pageNamePattern'] = '/^[a-z0-9](\.|_|-|\w)*$/i';

$QW_CONFIG['headPatternArray'] = array(
'/^([A-Z]+\S*( [^a-z\d\s]+\S*)( [^a-z\s]+\S*)*)$/' // minimum two words, first letter of all in upper case
);

// Ignored QwikiTags - One downside of all wikis is how they occasionaly tag words as links even when you don't want them to be. If you find yourself suffering from this, add the offending word in the 'ignoreTagPatternArray' and it will never be be linked as a wiki page.

$QW_CONFIG['ignoreQwikiTagArray'] = array( 
'DoNotLinkMe', '_Do_Not_Link_Me_'
);

// Redirect QwikiTags - these pages will be redirected to another page; enter names of pages and corresponding red-rected-to pages in this format, with multiple pairs separated by commas - 'about_john'=>'regarding_john', '1234'=>'1235' - else leave empty

$QW_CONFIG['redirectTagArray'] = array( 
);

// For page numbering - maximum listing of Wiki-pages on the 'recent changes' page
$QW_CONFIG['itemPerPage'] = 50;

/*
Note that the email functions are not well tested
 ====Suggest not using them====
- 'adminSig' will be attached to outgoing email messages (assuming you stick with the default text) on the mailing list
- 'emailFrom' is the address from which LabWiki attributes its email
*/
$QW_CONFIG['emailEnable'] = false;

$QW_CONFIG['adminSig'] = 'xxx';
$QW_CONFIG['emailFrom'] = 'none@setup.com';
$QW_CONFIG['emailEnableHTML'] = true;

// Email templates
// All email sent follows template messages contained in the files named below. These
// message templates embed the following system-inserted variables:
// - QW_HOMELINK - URL of the LabWiki installation 
// - QW_PAGELINK - URL of the page that changed
// - QW_TITLE - Title of the page that changed
// - QW_PAGE - Name of the page that changed
// - QW_CSS - CSS contents of the current style
// - QW_BODYTEXT - text (unformatted) contents of the page itself
// - QW_BODYHTML - HTML contents of the page itself
// - QW_ADMINSIG - Contents of QW['adminSig'], defined above
// - QW_UNSUBSCRIBELINK - URL to unsubscribe from the mailing list
// - QW_RESUBSCRIBELINK - URL to resubscribe to the mailing list
//
$QW_CONFIG['emailSubscribeSubject']            = "Subscribed to 'QW_PAGE' on QW_TITLE";
$QW_CONFIG['emailUnsubscribeSubject']          = "Unsubscribed from 'QW_PAGE' on QW_TITLE";
$QW_CONFIG['emailChangedSubject']              = "'QW_PAGE' changed on QW_TITLE";
$QW_CONFIG['emailSubscribeBodyTextFilename']   = "_subscribemessage.txt";
$QW_CONFIG['emailSubscribeBodyHTMLFilename']   = "_subscribemessage.html";
$QW_CONFIG['emailUnsubscribeBodyTextFilename'] = "_unsubscribemessage.txt";
$QW_CONFIG['emailUnsubscribeBodyHTMLFilename'] = "_unsubscribemessage.html";
$QW_CONFIG['emailChangedBodyTextFilename']     = "_changedmessage.txt";
$QW_CONFIG['emailChangedBodyHTMLFilename']     = "_changedmessage.html";

