<?php 

/*
LabWiki 1.2.1, 22 August 2012, by Santosh Patnaik, MD, PhD. Based on QwikiWiki 1.5 of David Barrett
*/

error_reporting(E_ALL | (defined('E_STRICT') ? E_STRICT : 0));

////////////////////////////////////////////////////////////////////////////////
//////////////////////// Verify Installation ///////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// If it's not already installed, QWRedirect to the installer
if( !is_file( "data/INSTALLCOMPLETE" ) )
{
	// Redirect to the installer
	$url = ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/install.php";
	header("Location: $url" );
	?><p>Please wait, redirecting to <a href="<?php echo $url; ?>">here</a>.</p><?php
	exit;
}

////////////////////////////////////////////////////////////////////////////////
/////////////////////////// Include Libraries //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
include('_config.php');
ini_set('display_errors', $QW_CONFIG['enablePHPErrs']);
include('_util.php');
include('_wikiLib.php');
include('_render.php');
include('_mailinglistLib.php');
	
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////// Set Globals /////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Global variables
$QW['homeLink'] = ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
$homeLinkLength = strlen( $QW['homeLink'] );
if( $QW['homeLink'][$homeLinkLength-1] == '/' ) {$QW['homeLink'] = substr( $QW['homeLink'], 0, $homeLinkLength-1 );}
$QW['globalLockPath'] = 'data/GLOBALLOCK';

// Detect the input
if ( count( $_GET ) ) {$QW_REQUEST = $_GET;}
else {$QW_REQUEST = $_POST;}
	
// Strip all the $QW_REQUEST_VAR slashes
if( count( $QW_REQUEST ) ) {QWStripArraySlashes( $QW_REQUEST );}

// Pick out the useful request vars
$QW['requestFrom']     = trim(QWSafeGet( $QW_REQUEST, 'from' ));
$QW['requestFrom'] = str_replace(array('/', ':', '<', '>', '?', '|', '\\', '*', '"', "\n", "\r", "\t"), '', $QW['requestFrom']);
$QW['requestPage']     = trim(QWSafeGet( $QW_REQUEST, 'page' ));
$QW['requestPage'] = str_replace(array('/', ':', '<', '>', '?', '|', '\\', '*', '"', "\n", "\r", "\t"), '', $QW['requestPage']);
$QW['requestAction']   = trim(QWSafeGet( $QW_REQUEST, 'action' ));
$QW['requestPassword'] = trim(QWSafeGet( $QW_REQUEST, 'password' ));
$QW['requestConfirm']  = trim(QWSafeGet( $QW_REQUEST, 'confirm' ));
$QW['requestWikiData'] = trim(QWSafeGet( $QW_REQUEST, 'wikidata' ));
$QW['requestFilename'] = trim(QWSafeGet( $QW_REQUEST, 'filename' ));
$QW['requestDebug']    = trim(QWSafeGet( $QW_REQUEST, 'debug' ));
if(!empty($QW['requestDebug'])){$QW['requestDebug'] = 'true';}
$QW['requestQuery']    = trim(QWSafeGet( $QW_REQUEST, 'query' ));
$QW['requestEmail']    = trim(QWSafeGet( $QW_REQUEST, 'email' ));
$QW['requestHTML']     = trim(QWSafeGet( $QW_REQUEST, 'html' ));
$QW['requestNotify']   = trim(QWSafeGet( $QW_REQUEST, 'notify' ));
$QW['requestHelp']     = trim(QWSafeGet( $QW_REQUEST, 'help' ));
if(!empty($QW['requestHelp'])){$QW['requestHelp'] = 'true';}
$QW['requestProtect']  = trim(QWSafeGet( $QW_REQUEST, 'protect' ));
$QW['requestUsername'] = trim(QWSafeGet( $QW_REQUEST, 'username' ));

// Determine which page we're using:
if( !$QW['requestPage'] || !QWValidPageName( $QW['requestPage'] )) {
	$QW['page'] = $QW_CONFIG['startPage'];
} else {
	$QW['page'] = $QW['requestPage'];
}

// Get the file associated with this page
$QW['pagePath']  = QWCreateDataPath( $QW['page'], '.qwiki' );
$QW['lockPath']  = QWCreateDataPath( $QW['page'], '.lock' );
$QW['passPath']  = QWCreateDataPath( $QW['page'], '.pass' );
$QW['mailPath']  = QWCreateDataPath( $QW['page'], '.mail' );
$QW['attachDir'] = QWCreateDataPath( $QW['page'], '_attach' );	
$QW['fromPagePath']  = ( $QW['requestFrom'] && $QW['requestFrom'] != $QW['page'] ) ? 
                   	 QWCreateDataPath( $QW['requestFrom'], '.qwiki' ) : 
                   	 "";
$QW['fromPassPath']  = ( $QW['requestFrom'] && $QW['requestFrom'] != $QW['page'] ) ? 
                   	 QWCreateDataPath( $QW['requestFrom'], '.pass' ) : 
                   	 "";
                   	
// Strip all the $_COOKIE slashes
QWStripArraySlashes( $_COOKIE );
	
// Pick out the useful cookie variables
$QW['cookiePassword']    = QWSafeGet( $_COOKIE, 'password' );
$QW['cookieRecentPages'] = QWSafeGet( $_COOKIE, 'recentpages' );
if( $QW['cookieRecentPages'] ) $QW['cookieRecentPageList'] = unserialize( $QW['cookieRecentPages'] );
else                           $QW['cookieRecentPageList'] = array( $QW_CONFIG['startPage'] );

// See if the user is authenticated, implicitly or otherwise
$QW['encryptedPassword'] = md5( $QW_CONFIG['adminPassword'] );
$QW['pageIsProtected'] = $QW_CONFIG['globalEditLock'] || ( $QW['fromPassPath'] ? is_file( $QW['fromPassPath'] ) : is_file( $QW['passPath'] ) );
$QW['userIsAuthenticated'] = ($QW['cookiePassword'] == $QW['encryptedPassword']);

// Prepare to append URLs
$QW['debugURLSuffix'] = ( $QW['requestDebug'] ? "&amp;debug=true" : "" );
$QW['helpURLSuffix'] = ( $QW['requestHelp'] ? "&amp;help=true" : "" );
$QW['URLSuffix'] = $QW['debugURLSuffix'] . $QW['helpURLSuffix'];
$QW['hrefTarget'] = "";

// NoOp template functions
function QWNoOp( ) { }
$QW_TEMPLATE['getTitle'] = "QWNoOp";
$QW_TEMPLATE['injectBody'] = "QWNoOp";
$QW_TEMPLATE['commandList'] = "QWNoOp";