<?php

/*
LabWiki 1.2.1, 22 August 2012, by Santosh Patnaik, MD, PhD. Based on QwikiWiki 1.5 of David Barrett
*/

header('Content-Type: text/html; charset=utf-8'); 
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="content-type" content="text/html; charset=
<?php
echo ($QW_CONFIG['encoding']);
?>
" />
<meta http-equiv="Content-Language" content="en-us" />
<title>
<?php 
$page_name = str_replace("_", " ", $QW['page']);
echo (htmlspecialchars($page_name) .' - '.htmlspecialchars($QW_CONFIG['title']));
?>
</title>
<meta name="description" content="
<?php
echo (htmlspecialchars($QW_CONFIG['metaContent']) . ' - ');
$page_name = str_replace("_", " ", $QW['page']);
echo htmlspecialchars(" $page_name");
?>
" />
<meta name="keywords" content="
<?php
echo (htmlspecialchars($QW_CONFIG['metaKeywords']) . ', ');
$page_name = str_replace("_", " ", $QW['page']);
echo htmlspecialchars(" $page_name");
?>
" />
<link rel="stylesheet" type="text/css" href="
<?php
echo ($QW_CONFIG['stylesheetFilename']);
?>
" />
<style type="text/css" media="all">
/*<![CDATA[*/
@import "
<?php
echo ($QW_CONFIG['stylesheetFilename']);
?>
";
/*]]>*/
</style>
<link rel="icon" href="../favicon.ico" type="image/x-icon" />
<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon" />
<script type="text/javascript" charset="
<?php
echo ($QW_CONFIG['encoding']);
?>
">
//<![CDATA[
<!--//

function confirmdelete(deletePage) 
{
if (confirm('Are you sure?')) {location = deletePage;}
}

function confirmsubmit()
{
var agree = confirm ("Are you sure?");
if (agree)
 return true ;
else
 return false ;
}

<?php
// when backup maintenance mode ... backups.php
if(isset($extra_javascript)){echo ($extra_javascript);}
?>

// -->
//]]>
</script>
</head>
<body class="QWBody">
<div class="QWBody">
<div class="QWGlobalNav">
<strong><?php echo date("F j, Y"); ?></strong> | 
<?php
				// Process the global nav list
				$list = $QW_CONFIG['globalNav'];
				array_walk( $list, "QWFormatQwikiBlockInPlace" );
				echo QWFormatHTMLList( $list, " | " );
?>
<br />
<strong>Recently viewed: </strong>
<?php 
$list = $QW['cookieRecentPageList'];
$list = QWUnduplicateArray( $list );
foreach ($list as $key => $value)
{
$path = 'data/'.$value.'.qwiki';
if (file_exists($path)){$list2[]=$value;}
}
$list2 = array_unique( $list2 );
QWTruncateArrayInPlace( $list2, 5 );
$list2 = array_reverse( $list2 );
array_walk( $list2, "QWFormatQwikiPageNameInPlace" );
echo QWFormatHTMLList( $list2, " > " );
?>
</div>

<div class="QWTitleBox">
<?php 
echo htmlspecialchars($QW_TEMPLATE['getTitle']( ));
if(is_file( $QW['pagePath'] ) and !isset($on_listing_page)){
$modified_date = date("F d, Y", filemtime($QW['pagePath']));
echo(" | Last modified: " . $modified_date);} 
?>
<br />
</div>
		
<div class="main">
<?php echo $QW_TEMPLATE['injectBody']( ); ?>
</div>
		
<div class="QWTitleBox">
<form class="QWForm" method="post" action="search.php"<?php echo htmlspecialchars($QW['hrefTarget']) ?>>
<div>
<input type="hidden" name="debug" value="<?php echo htmlspecialchars($QW['requestDebug']) ?>" />
<input type="hidden" name="help" value="<?php echo htmlspecialchars($QW['requestHelp']) ?>" />
<input type="text" name="query" size="15" maxlength="50"  value="<?php echo (!empty($QW['requestQuery']) ? htmlspecialchars($QW['requestQuery']) : '') ?>"/>
<input type="submit" name="action" value="Search" />
</div>
</form>
</div>

<div class="QWCommandList">
<span>&#8721; accuracy, clarity, cost, ease, logic | <?php include("hitcounter.php"); ?> wiki pages served since <?php echo (isset($QW_CONFIG['sinceDate']) ? $QW_CONFIG['sinceDate'] : ' a while'); ?> |</span> <?php echo QWFormatHTMLList( $QW_TEMPLATE['commandList']( ), " | " ) ?>
</div>		

</div>
</body>
</html>
