<?php

/*
LabWiki 1.2.1, 22 August 2012, by Santosh Patnaik, MD, PhD. Based on QwikiWiki 1.5 of David Barrett
*/

include( "_global.php" );

// Disable Caching
QWDisableCaching();

// Update the list of recently viewed pages
$recentlyViewedPages[] = $QW['page'];
if ( isset( $QW['cookieRecentPageList'] ) ) {$QW['cookieRecentPageList'] = array_merge( array( $QW['page'] ), $QW['cookieRecentPageList'] );}
else {$QW['cookieRecentPageList'] = array( $QW['page'] );}
$QW['cookieRecentPageList'] = QWUnduplicateArray( $QW['cookieRecentPageList'] );
QWTruncateArrayInPlace( $QW['cookieRecentPageList'], 20 ); // only keep a history of 20 pages
setcookie( "recentpages", serialize( $QW['cookieRecentPageList'] ), time()+60*60*24*30 );


// QWTIndexFormatGlobalNav
$QW_TEMPLATE['getGlobalNavPageNameList'] = "QWTIndexFormatGlobalNav";
function QWTIndexFormatGlobalNav( )
{global $QW_CONFIG;
return QWFormatQwikiText( $QW_CONFIG['globalNav'] );}
// QWTIndexFormatTitle
$QW_TEMPLATE['getTitle'] = "QWTIndexFormatTitle";
function QWTIndexFormatTitle( )
{global $QW;
return "Document: " . QWCleanQwikiPageName( $QW['page'] );}

// QWTIndexFormatBody
$QW_TEMPLATE['injectBody'] = "QWTIndexFormatBody";
function QWTIndexFormatBody( )
{global $QW;
return QWFormatQwikiFile( $QW['pagePath'] );}

// QWTIndexFormatCommandList
$QW_TEMPLATE['commandList'] = "QWTIndexFormatCommandList";
function QWTIndexFormatCommandList( )
{
 global $QW, $QW_CONFIG;	
 if($QW['userIsAuthenticated'])
   {
   $commandList[]='<a href="logout.php?page='.htmlspecialchars($QW['page']).$QW['URLSuffix'].'">Admin logout</a>';
   $commandList[] = '<a href="backups.php?page='.htmlspecialchars($QW['page']).'">Backup maintainance</a>';
   if(!QWLockExists($QW['lockPath']))
     {
     $commandList[] = '<a href="javascript:confirmdelete(\'delete.php?page='.htmlspecialchars($QW['page']).'\');" title="Delete this page">Delete this page</a>';
     }
   }
   else{$commandList[]='<a href="login.php?page='.htmlspecialchars($QW['page']).$QW['URLSuffix'].'">Admin login</a>';}
 if($QW['requestFrom']){$fromSuffix="&amp;from=". htmlspecialchars($QW[requestFrom]);}
   else{$fromSuffix="";}
 if(!$QW['pageIsProtected']||$QW['userIsAuthenticated'])
   {
   if(QWLockExists($QW['lockPath'])) 
	 {
	 if(QWHoldsLockfile($QW['globalLockPath'],$QW['lockPath'],$_SERVER['REMOTE_ADDR']))
	   {$commandList[]='<a href="edit.php?page='.htmlspecialchars($QW['page']).$fromSuffix.$QW['URLSuffix'].'">(Continue editing this page)</a>';}
     else{$commandList[]="(Page is being edited)";}
	 }
   else          
	 {
	 if (empty($QW_CONFIG['ipArray']))
	 {
	 $commandList[] = '<a href="edit.php?page='.htmlspecialchars($QW['page']).$fromSuffix.$QW['URLSuffix'].'">Edit this page</a>';
	 }
	 else
	 {
       if(empty($_SERVER["HTTP_X_FORWARDED_FOR"]))
         {$IP=$_SERVER["REMOTE_ADDR"];}
       else{$IP=$_SERVER["HTTP_X_FORWARDED_FOR"];} 
       $lh = gethostbyaddr($_SERVER['REMOTE_ADDR']);
       $test=$IP.".".$lh;
       // if clause to show 'edit' link based on IP address checking
       if(in_array($test, $QW_CONFIG['ipArray']) || in_array($IP, $QW_CONFIG['ipArray']))
         {$commandList[] = '<a href="edit.php?page='.htmlspecialchars($QW['page']).$fromSuffix.$QW['URLSuffix'].'">Edit this page</a>';
         }
       }
     }
   }

if( $QW_CONFIG['emailEnable'] ) {$commandList[] = '<a href="mailinglist.php?page='.htmlspecialchars($QW['page']).$QW['URLSuffix'].'"><em>'.htmlspecialchars($QW['page']).'</em> mailing list</a>';}
return $commandList;
}

// Include the template
include( $QW_CONFIG['templateFilename'] );

// Output debugging, if requested
if( $QW_CONFIG['enableDebugging'] && $QW['requestDebug'] ) echo QWFormatDebug( );