<?php

/*
LabWiki 1.2.1, 22 August 2012, by Santosh Patnaik, MD, PhD. Based on QwikiWiki 1.5 of David Barrett
*/

include("_global.php");

////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// Disable Caching //////////////////////////////
////////////////////////////////////////////////////////////////////////////////
QWDisableCaching( );

////////////////////////////////////////////////////////////////////////////////
//////////////////////////// Define Template Functions /////////////////////////
////////////////////////////////////////////////////////////////////////////////

// QWTRecentChangesFormatGlobalNav
$QW_TEMPLATE['getGlobalNavPageNameList'] = "QWTRecentChangesFormatGlobalNav";
function QWTRecentChangesFormatGlobalNav( )
{
	// Output from the config file
	global $QW_CONFIG;
	return QWFormatQwikiText( $QW_CONFIG['globalNav'] );
}

// QWTRecentChangesFormatTitle
$QW_TEMPLATE['getTitle'] = "QWTRecentChangesFormatTitle";
function QWTRecentChangesFormatTitle( )
{
	// Output a title
	global $QW;
	return 'All documents in this wiki';
}

// for subheading
$on_listing_page = 1;

// QWTRecentChangesInjectBody
$QW_TEMPLATE['injectBody'] = "QWTRecentChangesInjectBody";

//function to count file number and total file size in directory; no recursion
function count_size($dir) 
{ 
$FileCount = 0;
$TotalSize = 0; 
$handle = opendir($dir);
while (false!==($item = readdir($handle)))
{
if(is_file($dir . '/' . $item)) { $FileCount++; $TotalSize += filesize($dir . '/' . $item); } 
} 
closedir($handle);
return $FileCount . '/' . QWFormatFileSize( $TotalSize );

}
function QWTRecentChangesInjectBody( )
{   global $QW, $QW_CONFIG;
    echo ('<div style="align: center; margin:auto;">');
    // get the list - alphabetical or by modification date 
	if (!isset($_GET['alpha'])){$list = QWGetRecentlyChangedQwikiPageNameList( );}
	else {$list = QWGetQwikiPageNameList();}
    $total_items = count($list);
	$now = time( );
	// start table and show header based on type of listing
	echo ("<table class=\"QWInnerSection\"><tr><td colspan='4'>");
	if (!isset($_GET['alpha'])){echo ('Sorted in descending order by modification date. <a href="recentchanges.php?alpha=yes'. $QW['URLSuffix'].'">Sort alphabetically?</a>');}
	else {echo ('Sorted in ascending order by name. <a href="recentchanges.php?'. $QW['URLSuffix']. '">Sort by modification date?</a>');}
    echo ("</td></tr><tr class=\"QWInnerSectionTitle\"><td>Page name:</td><td>Attachments?</td><td>Last modified:</td><td>&nbsp;</td></tr>");
    // identify page number
    if(!isset($_GET['page_no'])){$page_no = 1;} else {$page_no = intval(htmlspecialchars($_GET['page_no']));}
	if(empty($page_no)){$page_no = 1;}
    // max items to show per page
    $max_items = isset($QW_CONFIG['itemPerPage']) ? intval($QW_CONFIG['itemPerPage']) : 50;
    // identify which items to show; first item of this subset
    $from = (($page_no * $max_items) - $max_items);
    // generate this subset array
    $list_subset = array_slice ($list, $from, $max_items);
    // loop across the list for those items and output
    foreach( $list_subset as $pageName )
     {
     // get the path and timestamp
     $path = QWCreateDataPath( $pageName, '.qwiki' );
     $then = filemtime( $path );
     $delta = QWFormatRelativeDate( $now, $then );
     $modified_date = date("F d, Y", $then);
     // check for attachments
     if (file_exists('data/'.$pageName.'_attach'))
      {
      $dir = 'data/'.$pageName.'_attach';
      $check_attach = count_size ($dir);
      }
     else {$check_attach = "-";}
     // uutput the row
     echo "<tr><td>" . QWFormatQwikiPageName( $pageName ) . "</td><td>$check_attach</td><td>$modified_date</td><td>".$delta."</td></tr>";
     }
	// page numbering
	echo  ("<tr><td colspan='4'>");
    $total_pages = ceil($total_items / $max_items); 
    if($total_pages >1)
     {echo ("Page " . $page_no. " of " . $total_pages . "<br />"); 
      if($page_no > 1)
       {$prev = ($page_no - 1); 
       if (!isset($_GET['alpha'])){echo ("<a href=\"" . $_SERVER['PHP_SELF'] . "?page_no=$prev". $QW['URLSuffix']. "\">&laquo;Previous</a>&nbsp;");}
       else {echo ("<a href=\"" . $_SERVER['PHP_SELF'] . "?alpha=yes&amp;page_no=$prev". $QW['URLSuffix']. "\">&laquo;Previous</a>&nbsp;");}
       }
      for($i = 1; $i <= $total_pages; $i++)
       {if(($page_no) == $i){echo ("$i&nbsp;");}
       else 
        {if (!isset($_GET['alpha'])){echo ("<a href=\"" . $_SERVER['PHP_SELF'] . "?page_no=$i". $QW['URLSuffix']. "\">$i</a>&nbsp;");}
         else {echo ("<a href=\"" . $_SERVER['PHP_SELF'] . "?alpha=yes&amp;page_no=$i". $QW['URLSuffix']. "\">$i</a>&nbsp;");}
        }
       }  
      if($page_no < $total_pages)
       {$next = ($page_no + 1); 
       if (!isset($_GET['alpha'])){echo ("<a href=\"" . $_SERVER['PHP_SELF'] . "?page_no=$next". $QW['URLSuffix']. "\">Next&raquo;</a>");}
       else {echo ("<a href=\"" . $_SERVER['PHP_SELF'] . "?alpha=yes&amp;page_no=$next". $QW['URLSuffix']. "\">Next&raquo;</a>");}
       }
     }
    echo ('</td></tr><tr><td colspan="4">');
    // help content
	if (!isset($_GET['alpha'])){$help_format = "recentchanges.php?page_no=".$page_no."&amp;nothing=nothing".$QW['URLSuffix'];}
	 else {$help_format = "recentchanges.php?alpha=yes&page_no=".$page_no."&amp;nothing=nothing".$QW['URLSuffix'];}
	QWFormatHelp
	( "This page simply lists all pages in the system, sorted alphabetically or by the time since it was last changed."
	,$help_format
    );
    echo ("</td></tr></table>");
    echo ('</div>');
}

// QWTListFormatCommandList
$QW_TEMPLATE['commandList'] = "QWTListFormatCommandList";
function QWTListFormatCommandList( )
{
 global $QW, $QW_CONFIG, $_SERVER;	
 if($QW['userIsAuthenticated'])
   {
   $commandList[]='<a href="logout.php?page='.htmlspecialchars($QW['page']).$QW['URLSuffix'].'">Admin logout</a>';
   }
 else{$commandList[]='<a href="login.php?page='.htmlspecialchars($QW['page']).$QW['URLSuffix'].'">Admin login</a>';}

return $commandList;
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////// Fill Template ///////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// Include the template
include( $QW_CONFIG['templateFilename'] );

// Output debugging, if requested
if( $QW_CONFIG['enableDebugging'] && $QW['requestDebug'] ) echo QWFormatDebug( );