<?php 

/*
LabWiki 1.2.1, 22 August 2012, by Santosh Patnaik, MD, PhD. Based on QwikiWiki 1.5 of David Barrett
*/

include("_global.php");
QWDisableCaching();

// QWTSearchFormatGlobalNav
$QW_TEMPLATE['getGlobalNavPageNameList'] = "QWTSearchFormatGlobalNav";
function QWTSearchFormatGlobalNav( )
{
// Output from the config file
	global $QW_CONFIG;
	return QWFormatQwikiText( $QW_CONFIG['globalNav'] );
}
// QWTSearchFormatTitle
$QW_TEMPLATE['getTitle'] = "QWTSearchFormatTitle";
function QWTSearchFormatTitle( )
{
// Output a title
	global $QW;
	return htmlspecialchars( "Searching: $QW[requestQuery]" );
}
$QW['pagePath'] = "Search";
// QWTSearchInjectBody
$QW_TEMPLATE['injectBody'] = "QWTSearchInjectBody";


function QWTSearchInjectBody( )
{
global $QW, $QW_CONFIG;
// Strip out any non alphanumeric, non-whitespace data
$safeQuery = preg_replace( "/[^\w\d\s]+/", "", $QW['requestQuery'] );
if( !$safeQuery ) QWFormatMessage( "Please type a search phrase and click <em>Search</em>." );
// Output a search form
?>
<div style="align: center; text-align: center; margin: auto;">
<form class="QWForm" method="post" action="search.php">
<div>
<input type="hidden" name="debug" value="<?php echo htmlspecialchars($QW['requestDebug']); ?>" />
<input type="hidden" name="help" value="<?php echo htmlspecialchars($QW['requestHelp']); ?>" />
<br />
Search phrase:&nbsp;
<input type="text" name="query" value="<?php echo htmlspecialchars($QW['requestQuery']); ?>" />&nbsp;
<input type="submit" name="action" value="Search" />
</div>
</form>
<?php 
QWFormatHelp( "To search for a specific phrase, type the phrase into the <em>Search phrase</em> field above and click <em>Search</em>.  This will generate a list of all pages containing the exact phrase specified, ignoring case and punctuation.  The results list has the following columns: <em>#</em>: The number of matches found in the page, <em>Page</em>: A link to the page containing the phrase, <em>Quote</em>: A short quote of the context surrounding the first match.","search.php?query=".htmlspecialchars($QW['requestQuery']) );

// Do the query 
if( strlen( $safeQuery ) )
{  
// Compose a pattern from the keywords
$pattern = "/($safeQuery)/i";
if( is_dir( "data/" ) )
                	   {
                	       // Read the directory
                	       $dataDir = dir( "data/" );
                	       while( $filename = $dataDir->read( ) )
                	       {
                	           // Output the result
                	           if( $filename != "." && $filename != ".." )
                	           {
                	               // See if it"s a qwiki file
                	               $info = pathinfo( $filename );
                	               if( isset( $info['extension'] ) &&
                	                   !strcasecmp( $info['extension'], "qwiki" ) )
                	               {
                	                   // Found a qwiki file, do the test
                	                   $path = "data/".$filename;
                	                   $length = filesize( $path );
                	                   $fp = fopen( $path, "rb" );
                	                   $data = fread( $fp, $length );
                	                   fclose( $fp );
                	                   $num = preg_match_all( $pattern, $data, $matches );
                	                   if( $num )
                	                   {
                	                       // At least one match, note as much
                	                       $pagename = substr( $filename, 0, -strlen( $info['extension'] )-1 );
                	                       if( !isset( $results[$num] ) ) $c = 0;
                	                       else $c = count( $results[$num] );
                	                       $results[ $num ][ $c ][0] = $pagename;
                	                       
                	                       // Grab a quote around the first instance
                	                       $match = $matches[1][0];
                	                       $pos = strpos( $data, $match );
                	                       $width = 30;
                	                       $start = $pos - $width;
                	                       $afterPos = $pos + strlen( $match );
                	                       $end = $afterPos + $width;
                	                       if( $start < 0 ) $start = 0;
                	                       if( $end >= strlen( $data ) ) $end = strlen( $data );
                	                       $before = substr( $data, $start, $pos - $start );
                	                       $after = substr( $data, $afterPos, $end - $afterPos );
                	                       $quote = htmlspecialchars($before).'<span class="QWSearchMatch">'.htmlspecialchars($match).'</span>'.htmlspecialchars($after); 
                	                       $results[ $num ][ $c ][1] = $quote;
}
else
{
                	                       // Even if it"s not found in the file, check the filename
                	                       $pagename = substr( $filename, 0, -strlen( $info['extension'] )-1 );
                	                       $cleanname = QWCleanQwikiPageName( $pagename );
                	                       if( preg_match( $pattern, $cleanname, $matches ) )
{
                	                           // Matched the filename, add it without a quote
                	                           if( !isset( $results[0] ) ) $c = 0;
                	                           else $c = count( $results[0] );
                	                           $results[ 0 ][ $c ][0] = $pagename;
                	                           $results[ 0 ][ $c ][1] = "(none)";
}
}
}
}
}
$dataDir->close( );

/////////////////                	       
if( isset( $results ) && is_array( $results ) && count( $results ) )
{
echo '<table class="QWInnerSection">';
echo '<tr class="QWInnerSectionTitle"><td>#</td><td>Page</td><td>Quote</td></tr>';
                	           // Sort the results
                	           krsort( $results );
                	           
                	           // Output the results
                	           foreach( $results as $num => $list )
                	           {
                	               // Sort the list of matches with this count and output
                	               sort( $list );
                	               for( $c=0; $c<count( $list ); ++$c )
                	               {
                	                   // Output
                	                   $pagename = $list[$c][0];
                	                   $quote    = $list[$c][1];
                	                   echo "<tr><td>".$num."</td><td>" . QWFormatQwikiPageName( $pagename ) . "</td><td>...".$quote."...</td></tr>";
                	               }
                	           }
}
else
{
echo '<table class="QWInnerSection">';
echo '<tr><td><br />No matches found!<br /><br />Try another phrase. Note that wildcards are not allowed but searches are case-insensitive. Searches also pick up un-formatted data, e.g., a URL inside an <em>a</em> HTML tag.</td></tr>';
}
echo "</table>";
////////////////
}
}
//////////////////////////////////////
echo "</div>";
}

// QWTSearchFormatCommandList
$QW_TEMPLATE['commandList'] = "QWTSearchFormatCommandList";
function QWTSearchFormatCommandList( )
                {
                 global $QW, $QW_CONFIG;  
                 if($QW['userIsAuthenticated'])
                   {
                   $commandList[]='<a href="logout.php?page='.htmlspecialchars($QW['page']).$QW['URLSuffix'].'">Admin logout</a>';
                   }
                 else{$commandList[]='<a href="login.php?page='.htmlspecialchars($QW['page']).$QW['URLSuffix'].'">Admin login</a>';}
                 return $commandList;
                }
                
// Include the template
include( $QW_CONFIG['templateFilename'] );

// Output debugging, if requested
if( $QW_CONFIG['enableDebugging'] && $QW['requestDebug'] ){ echo QWFormatDebug( );}