<?php 
// _mailinglistLib.php
//
// Copyright 2004, David Barrett.  All Rights Reserved.
//   Email: dbarrett@quinthar.com
//     Web: http://www.quinthar.com
//
// See LICENSE for the complete licensing details.
require_once( "_global.php" );


// QWLoadMailingList
function QWLoadMailingList( $path )
{
	// Load the list
	if( is_file( $path ) )
	{
		// Load the list
		$fp = fopen( $path, 'r' );
		while( $line = fgetcsv( $fp, 1024 ) )
			if( $line[0] )
			{
				// Get the name and settings
				$email = stripslashes( $line[0] );
				$enableHTML = ( $line[1] == 'true' );
				
				// Add to the parsed internal list
				$mailingList[ $email ][0] = $enableHTML;
			}
		fclose( $fp );
		return $mailingList;
	}
}

// QWSaveMailingList
function QWSaveMailingList( $path, &$mailingList )
{
	// Output a list if it's there
	if( isset( $mailingList ) && count( $mailingList ) )
	{
		// Output the new list
		ksort( $mailingList );
		$fp = fopen( $path, 'w' );
		foreach( $mailingList as $email => $settings )
		{
			// Output in a CSV
			$outEmail = addslashes( $email );
			$outHTML = ( $settings[0] ? 'true' : 'false' );
			fputs( $fp, "\"$outEmail\",\"$outHTML\"\n" );		
		}
		fclose( $fp );
	}
	else
	{
		// No list, so delete the file if it's there
		if( is_file( $path ) ) unlink( $path );
	}
}

// QWMailMailingList
function QWMailMailingList( $path, $from, $subject, $textMessage, $htmlMessage )
{
	// Load the list
	$mailingList = QWLoadMailingList( $path );
	if( isset( $mailingList ) && count( $mailingList ) )
	{
		// Loop across and send
		foreach( $mailingList as $email => $settings )
		{
			// Replace the mass-mailing patterns
			$matchPatternArray = array(
				'/QW_MAILINGLISTEMAIL/'
			);
			$replacePatternArray = array(
				$email
			);	
			$customTextMessage = preg_replace( $matchPatternArray, $replacePatternArray, $textMessage );			
			
			// Mail depending on the settings
			if( $QW_CONFIG['emailEnableHTML'] && $settings[0] )
			{
				// Mail the HTML version
				$customHTMLMessage = preg_replace( $matchPatternArray, $replacePatternArray, $htmlMessage );						
				QWMailHTML( $from, $email, $subject, $customTextMessage, $customHTMLMessage );
			}
			else
			{
				// Mail the text version
				QWMail( $from, $email, $subject, $customTextMessage );
			}
		}
	}
}

// QWMailHTML
function QWMailHTML( $from, $to, $subject, $textMessage, $htmlMessage )
{
	// Mail the message but suppress any warnings
	$boundary = uniqid("QWIKIWIKI");
	$headers = "From: $from\r\n" .
		"MIME-Version: 1.0\r\n" .
		"Content-Type: multipart/alternative; boundary = $boundary\r\n\r\n" .
		"This is a MIME encoded message.\r\n\r\n" .
		"--$boundary\r\n" . 
		"Content-Type: text/plain; charset=ISO-8859-1\r\n" . 
		"Content-Transfer-Encoding: base64\r\n\r\n" .
		chunk_split( base64_encode( $textMessage) ) .
		"--$boundary\r\n" . 
		"Content-Type: text/html; charset=ISO-8859-1\r\n" . 
		"Content-Transfer-Encoding: base64\r\n\r\n" .
		chunk_split( base64_encode( $htmlMessage) ) .
		"--$boundary\r\n";
	return @mail( $to, $subject, "", $headers );
}

// QWMail
function QWMail( $from, $to, $subject, $textMessage )
{
	// Mail the message but suppress any warnings
	return @mail( $to, $subject, $textMessage, "From: $from\r\n" );
}

?>