<?php

// QWFatalError
function QWFatalError( $message )
{
	// Output the message and exit
	echo "<strong>Fatal QwikiWiki Error</strong>: ".$message."</body></html>";
	exit;
}

// QWLockExists
function QWLockExists( $lockPath )
{
	// See if it exists and hasn't expired
	global $QW_CONFIG;
	return file_exists( $lockPath ) && (time() - filemtime( $lockPath )) < $QW_CONFIG['editLockfileExpiration'];
}

// QWCreateLockfile
function QWCreateLockfile( $globalLockPath, $lockPath, $who )
{
	// First acquire a lock on the globalLockPath by opening and block-locking
	$lockFP = fopen( $globalLockPath, 'w+' ) or QWFatalError( "Cannot lock '".$globalLockPath."' because it does not exist!" );
	flock( $lockFP, LOCK_EX ) or QWFatalError( "Cannot lock '".$globalLockPath."' - do not know why!" );
	
	// Check to see if it exists
	global $QW_CONFIG;
	$alreadyExists = file_exists( $lockPath );
	$gotLock = false;
	if( !$alreadyExists || (time() - filemtime( $lockPath )) > $QW_CONFIG['editLockfileExpiration'] )
	{
		// Create the file
		$fp = fopen( $lockPath, 'w' );
		fwrite( $fp, $who );
		fclose( $fp );
		$gotLock = true;
	}
	
	// Release the global lock
	flock( $lockFP, LOCK_UN ) or QWFatalError( "Cannot unlock '".$globalLockPath."' - do not know why!" );
	fclose( $lockFP );
	
	// Return whether or not this successfully created a new file
	return $gotLock;
}

// QWHoldsLockfile
function QWHoldsLockfile( $globalLockPath, $lockPath, $who )
{
	// First acquire a lock on the globalLockPath by opening and block-locking
	$lockFP = fopen( $globalLockPath, 'w+' ) or QWFatalError( "Cannot lock '".$globalLockPath."' because it does not exist!" );
	flock( $lockFP, LOCK_EX ) or QWFatalError( "Cannot lock '".$globalLockPath."' - do not know why!" );
	
	// Check to see if it exists
	$holdsIt = false;
	if( file_exists( $lockPath ) )
	{
		// Read it and see who holds it
		$fileArray = FILE( $lockPath );
		$holdsIt = ($fileArray[0] == $who);
	}
	
	// Release the global lock
	flock( $lockFP, LOCK_UN ) or QWFatalError( "Cannot unlock '".$globalLockPath."' - do not know why!" );
	fclose( $lockFP );
	
	// Return whether or not this lock is held by the indicated owner
	return $holdsIt;
}

// QWSafeGet
// Access an array using an index that might not exist without producing an
// "undefined index" warning
function &QWSafeGet( &$varArray, $varIndex )
{
	// If it's set, return the value, else return zero
	if( isset( $varArray[$varIndex] ) ) return $varArray[$varIndex];
	else return false;
}

// QWStripArraySlashes
function QWStripArraySlashes( &$varArray )
{
	// Walk across and strip it recursively
	if( count( $varArray ) ) foreach( $varArray as $name => $value )
	{
		if( is_array( $value ) ) QWStripArraySlashes( $value );
		else $varArray[$name] = stripslashes( $value );
	}
}

// QWClearCookies
function QWClearCookies( &$array, $path )
{
	// Loop across the named cookie array
	if( is_array( $array ) ) foreach( $array as $name => $value )
	{
		if( is_array( $value ) )
		{
			// If it's the first level, don't surround in brackets
			if( $path ) QWClearCookies( $value, "{$path}[{$name}]" );
			else QWClearCookies( $value, "$name" );
		}
		else
		{
			// Erase this cookie
			if( $path ) setcookie( "{$path}[{$name}]", "", time()-3600 );
			else setcookie( $name, "", time()-3600 );
		}
	}
}

// QWRedirect
function QWRedirect( $relativeURL )
{
	// Send the redirection header
	global $QW;
	$url = $QW['homeLink'].'/'.$relativeURL;
	header("Location: ".$url);
	echo '<p>Please wait - redirecting to <a href="'.$url.'">here</a>.</p>';
}

// QWDisableCaching
function QWDisableCaching( )
{
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Pragma: no-cache");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Cache-control: private");
header('Content-Type: text/html; charset='.$QW_CONFIG['encoding']);
}

// QWVerifyDirectory
function QWVerifyDirectory( $directory )
{
	// If it doesn't exist, create it and inheret from this directory's permissions
	if( !is_dir( $directory ) )
	{
		// Make a new backup directory
		$stats = stat( "." );
		$mode = $stats[2];
		if( !mkdir( $directory, $mode ) ) return "Error! - cannot create '".$directory."'";
	}
}

// QWGetRecentlyChangedFileList
// Loop across the contents of a directory and create a list of files
// that match the pattern, sorted by modifed date
function QWGetRecentlyChangedFileList( $directory, $pattern )
{
	// Get the dir and loop across
	$dir = dir( $directory );	
	while( $filename = $dir->read( ) )
		if( preg_match( $pattern, $filename ) )
			// Put into buckets by timestamp (potentially many changes in one second)
			$changeList[ filemtime( "$directory/$filename" ) ][] = $filename;
	$dir->close( );
		
	// Sort the list
	krsort( $changeList );
	foreach( $changeList as $timestamp => $fileList )
		foreach( $fileList as $filename )
			$outList[] = $filename;
	
	// Done
	return $outList;
}

// QWTruncateArrayInPlace
function QWTruncateArrayInPlace( &$inout, $maxSize )
{
	// Trim off anything greater than $maxSize;
	if( isset( $inout ) && is_array( $inout ) && count( $inout ) > $maxSize )
		// Update the reference
		$inout = array_slice( $inout, 0, $maxSize );
}

// QWUnduplicateArray
function QWUnduplicateArray( &$in )
{
	// Loop across and remove consecutive duplicates
	// Loop across and create a new array containing non-unique values
	if( isset( $in ) && is_array( $in ) )
		foreach( $in as $element )
			if( !isset( $out ) || ($element != end($out)) )			
				$out[] = $element;
	// Done
	return $out;
}

// QWCollapseArray
function QWCollapseArray( &$in, $separator, $finisher )
{
	// Loop accrossa and create a string containing a commma-separated list of the array entries
	$out = "";
	if( isset( $in ) && is_array( $in ) && count( $in ) )
	{
		// Insert a comma after all but the last
		for( $c=0; $c<count($in)-1; ++$c ) $out .= $in[$c] . $separator;
		$out .= $finisher . $in[$c];
	}
	return $out;
}

// QWGetFileContents
function QWGetFileContents( $path )
{
	// Just read the file into a big string
	$fileArray = file( $path );
	$out = "";
	if( isset( $fileArray ) && is_array( $fileArray ) && count( $fileArray ) )
		foreach( $fileArray as $line )
			$out .= $line;
	return $out;
}

function QWValidPageName($page) {
    global $QW_CONFIG;
    $validPageName = preg_match($QW_CONFIG['pageNamePattern'], $page); 
	return $validPageName;
}

// QWGetFileList
// Loop across the contents of a directory and create a list of files
// that match the pattern, sorted by modifed date
function QWGetFileList( $directory, $pattern )
{
	// Get the dir and loop across
	$dir = dir( $directory );	
	while( $filename = $dir->read( ) )
		if( preg_match( $pattern, $filename ) )
			// Put into the list
			$outList[$filename] = $filename;
	$dir->close( );
	ksort( $outList );
	// Done
	return $outList;
}

?>