<?php 
require_once( "_global.php" );
QWDisableCaching();

////////////////////////////////////////////////////////////////////////////////
///////////////////////// Authenticate the User ////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// See if we're not already authenticated
if( !$QW['userIsAuthenticated'] )
{
	// Check the user-supplied password
	$encryptedPassword = md5( $QW['requestPassword'] );
	if( $encryptedPassword == $QW['encryptedPassword'] )
	{
		// Password matches, record it in the cookie, expire in 30 days
		$QW['userIsAuthenticated'] = true;		
		setcookie( "password", $QW['encryptedPassword'], time()+60*60*24*30 );
	}
}

////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// Test for Success //////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// Redirect if the authentication worked
if( $QW['userIsAuthenticated'] )
{			
	// Redirect to the reference page
	QWRedirect( "index.php?page=".$QW['page'].$QW['URLSuffix']);
	exit;
}

////////////////////////////////////////////////////////////////////////////////
//////////////////////////// Define Template Functions /////////////////////////
////////////////////////////////////////////////////////////////////////////////





// QWTLoginInjectBody
$QW_TEMPLATE['injectBody'] = "QWTLoginInjectBody";
function QWTLoginInjectBody( )
{
global $QW, $QW_CONFIG;
echo ('<div style="align: center; text-align: center; margin: auto;">');
	// See if the password was incorrect or never supplied
	if( $QW['requestAction'] == 'Login' )
	{
		// It didn't work, explain why
		if( $QW['requestPassword'] ){$message = "The password you supplied for <strong>".$QW_CONFIG[title]."</strong> was incorrect.  Please type the correct password below and click <em>Login</em>.";}
		else {$message = "Please type the password for <strong>".$QW_CONFIG[title]."</strong> below and click <em>Login</em>.";
		QWFormatMessage( $message );}
	}
		
	// Display the login screen
	?>
		<form class="QWForm" id="for_login" method="post" action="login.php">
		    <div>
			<input type="hidden" name="action" id="action" value="Login" />
			<input type="hidden" name="page" id="page" value="<?php echo $QW['page']; ?>" />
			<input type="hidden" name="debug" id="debug" value="<?php echo $QW['requestDebug']; ?>" />
			<input type="hidden" name="help" id="help" value="<?php echo $QW['requestHelp']; ?>" />
			<br />Password: <input type="password" name="password" id="password" />&nbsp;<input type="submit" name="action" id="search" value="Login" />
			</div>
		</form>
		
<?php 
	QWFormatHelp( "Every QwikiWiki has a password, known only to the administrators.  To login as an administrator, simply type the admin password into the <em>Password</em> field and click <em>Login</em>.",
		"login.php?page=".$QW['page'] );
echo ('</div>');
}

// QWLoginFormatCommandList
$QW_TEMPLATE['commandList'] = "QWLoginFormatCommandList";
function QWLoginFormatCommandList( )
{	
	// Just go back to the originating page
	global $QW;
	$commandList[] = '<a href="index.php?page='.$QW['page'].$QW['URLSuffix'].'">Back to '.QWCleanQwikiPageName($QW['page']).'</a>';
	return $commandList;
}

// QWTLoginFormatTitle
$QW_TEMPLATE['getTitle'] = "QWTLoginFormatTitle";
function QWTLoginFormatTitle( )
{
	// Output a title
	global $QW_CONFIG;
	return QWCleanQwikiPageName( "Login to $QW_CONFIG[title]" );
}
$QW['pagePath'] = "Logging in";

////////////////////////////////////////////////////////////////////////////////
////////////////////////////// Fill Template ///////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// Include the template
include_once( $QW_CONFIG['templateFilename'] );

// Output debugging, if requested
if( $QW_CONFIG['enableDebugging'] && $QW['requestDebug'] ){ echo QWFormatDebug( );}

?>