<?php 
// mailinglist.php
//
// Copyright 2004, David Barrett.  All Rights Reserved.
//   Email: dbarrett@quinthar.com
//     Web: http://www.quinthar.com
//
// See LICENSE for the complete licensing details.
require_once( "_global.php" );

////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// Disable Caching //////////////////////////////
////////////////////////////////////////////////////////////////////////////////
QWDisableCaching( );

////////////////////////////////////////////////////////////////////////////////
///////////////////////////// Read the List ////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Verify there's actually a page set
if( !$QW['requestPage'] )
{
	// Must first log onto this page -- QWRedirect to login
	QWRedirect( "index.php" );
	exit;
}

////////////////////////////////////////////////////////////////////////////////
///////////////////////////// Process Actions //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// Reduce the email address to lowercase and trim the ends
$email = trim( strtolower( $QW['requestEmail'] ) );
$mailingList = QWLoadMailingList( $QW['mailPath'] );

// Operate upon the addres
$changed = false;
if( strlen( $email ) )
{	
	// Mailing list patterns
	// **NOTE** If you add more match/replace patterns, be sure put longer matching patterns
	//          before shorter (such as QW_PAGELINK and QW_PAGE)
	$htmlEnabled = ( isset( $mailingList[ $email ] ) ? $mailingList[ $email ][0] : false );
	$matchPatternArray = array(
		'/QW_HOMELINK/',
		'/QW_PAGELINK/',
		'/QW_PAGE/',
		'/QW_UNSUBSCRIBELINK/',
		'/QW_RESUBSCRIBELINK/',
		'/QW_BODYTEXT/',
		'/QW_BODYHTML/',
		'/QW_CSS/',
		'/QW_ADMINSIG/',
		'/QW_TITLE/'
	);
	$replacePatternArray = array(
		$QW['homeLink'],
		"$QW[homeLink]/index.php?page=$QW[page]",
		$QW['page'],
		"$QW[homeLink]/mailinglist.php?page=$QW[page]&action=unsubscribe&email=$email",
		"$QW[homeLink]/mailinglist.php?page=$QW[page]&action=subscribe&email=$email&html=$htmlEnabled",
		strip_tags( QWGetFileContents( $QW['pagePath'] ) ),
		QWFormatQwikiFile( $QW['pagePath'] ),
		QWGetFileContents( $QW_CONFIG['stylesheetFilename'] ),
		$QW_CONFIG['adminSig'],
		$QW_CONFIG['title']
	);	

	// Sanity check the email address
	if( preg_match( '/^[\d\w]+[\d\w.-]*@[\d\w]+\.[\d\w]+/i', $email ) )
	{
		if( !$QW['requestAction'] || !strcasecmp( $QW['requestAction'], 'Subscribe' ) )
		{			
			// Mail out the subscription messages
			$subject = preg_replace( $matchPatternArray, $replacePatternArray, $QW_CONFIG['emailSubscribeSubject'] );
			$textMessage = preg_replace( $matchPatternArray, $replacePatternArray, QWGetFileContents( $QW_CONFIG['emailSubscribeBodyTextFilename'] ) );			
			$htmlMessage = preg_replace( $matchPatternArray, $replacePatternArray, QWGetFileContents( $QW_CONFIG['emailSubscribeBodyHTMLFilename'] ) );			
			if( ( $QW_CONFIG['emailEnableHTML'] && $QW['requestHTML'] ? 
			      QWMailHTML( $QW_CONFIG['emailFrom'], $email, $subject, $textMessage, $htmlMessage ) :
			      QWMail( $QW_CONFIG['emailFrom'], $email, $subject, $textMessage ) ) )
			{
				// Add an email address to the list and set its HTML enabled status
				// Note: This might overwrite something already on the list, and that is fine
				$mailingList[ $email ][0] = ( $QW['requestHTML'] == '1' );
				$changed = true;
				$message = "<B>$email</B> has been subscribed to the <B>$QW[page]</B> mailing list";			
			}
			else
			{
				// Can't send out subscription notice
				$message = "<B>Server Error:</B> Could not subscribe <B>$email</B> to <B>$QW[page]</B> mailing list";
			}
		}
		else if( !strcasecmp( $QW['requestAction'], 'Unsubscribe' ) )
		{
			// See if the email address is already in the list
			if( isset( $mailingList ) && array_key_exists( $email, $mailingList ) )
			{			
				// Mail out the subscription messages
				$subject = preg_replace( $matchPatternArray, $replacePatternArray, $QW_CONFIG['emailUnsubscribeSubject'] );
				$textMessage = preg_replace( $matchPatternArray, $replacePatternArray, QWGetFileContents( $QW_CONFIG['emailUnsubscribeBodyTextFilename'] ) );			
				$htmlMessage = preg_replace( $matchPatternArray, $replacePatternArray, QWGetFileContents( $QW_CONFIG['emailUnsubscribeBodyHTMLFilename'] ) );			
				if( ( $QW_CONFIG['emailEnableHTML'] && $mailingList[ $email ][0] ? 
				      QWMailHTML( $QW_CONFIG['emailFrom'], $email, $subject, $textMessage, $htmlMessage ) :
				      QWMail( $QW_CONFIG['emailFrom'], $email, $subject, $textMessage ) ) )
				{
					// Remove
					unset( $mailingList[ $email ] );
					$changed = true;
					$message = "<B>$email</B> has been unsubscribed from the <B>$QW[page]</B> mailing list";
				}
				else
				{
					// Can't mail out unsubscription notice
					$message = "<B>Server Error:</B> Could not unsubscribe <B>$email</B> to <B>$QW[page]</B> mailing list";
				}
			}
			else
			{
				// Error
				$message = "<B>$email</B> is not subscribed to the <B>$QW[page]</B> mailing list";
			}
		}
	}
	else
	{
		// Error
		$message = "<B>$email</B> is an invalid email address";
	}
}

// Update the list if it's been changed
if( $changed ) QWSaveMailingList( $QW['mailPath'], $mailingList );

////////////////////////////////////////////////////////////////////////////////
//////////////////////////// Define Template Functions /////////////////////////
////////////////////////////////////////////////////////////////////////////////

// QWTMLFormatTitle
$QW_TEMPLATE['getTitle'] = "QWTMLFormatTitle";
function QWTMLFormatTitle( )
{
	// Output a title
	global $QW;
	return QWCleanQwikiPageName( "Mailing List: $QW[page]" );
}

// QWTMLInjectBody
$QW_TEMPLATE['injectBody'] = "QWTMLInjectBody";
function QWTMLInjectBody( )
{
	// Perform the search
	global $QW, $QW_CONFIG, $message;
	
	// Output the mesage, if there is one
	QWFormatMessage( $message );
		
	// Output a search form
	?><FORM CLASS='QWForm' ENCTYPE="multipart/form-data" METHOD="get" ACTION="mailinglist.php">
		<INPUT TYPE="hidden" NAME="debug" VALUE="<?php echo $QW['requestDebug'] ?>"/>
		<INPUT TYPE="hidden" NAME="page" VALUE="<?php echo $QW['page'] ?>"/>
		<INPUT TYPE="hidden" NAME="help" VALUE="<?php echo $QW['requestHelp'] ?>"/>
		<DIV ALIGN='center'>
			<TABLE CLASS='QWInnerSection'>
				<TR CLASS='QWInnerSectionTitle'><TD>Please specify:</TD></TR>
				<TR><TD ALIGN='center'>Email: <INPUT TYPE='text' NAME='email'</TD></TR>
				<php if( $QW_CONFIG['emailEnableHTML'] ) { ?>
					<TR><TD ALIGN='center'><INPUT checked TYPE='checkbox' NAME='html' value='1'> Send rich HTML email</TD></TR>
				<php } ?>
				<TR><TD COLSPAN='2' ALIGN='center'><INPUT TYPE='submit' NAME='action' ACTION='mailinglist.php' VALUE='Subscribe'/><INPUT TYPE='submit' NAME='action' ACTION='mailinglist.php' VALUE='Unsubscribe'/></TD></TR>
			</TABLE>	
		</DIV>
	</FORM><?php 
	
	QWFormatHelp( "<P>By subscribing to the <B>$QW[page]</B> mailing list,
		you will be notified whenever the page named <B>$QW[page]</B> changes.</P>
		<UL><LI>To subscribe, simply type your email address into the <B>Email</B> field above 
		and click <B>Subscribe</B>. Be sure to check the checkbox to receive rich HTML copies 
		of the page along with the page-changed notification.  To change your rich HTML settings,
		just re-subscribe with the same address and the new setting.</LI></UL>
		<UL><LI>To unsubscribe, type your email address into the <B>Email</B> field above and click
		</B>Unsubscribe</B>.</LI></UL>
		Every page has its own mailing list.  Only changes to <B>$QW[page]</B> will mailed out on
		this mailing list.",
		"mailinglist.php?page=$QW[page]" );
}

// QWTMLFormatCommandList
$QW_TEMPLATE['commandList'] = "QWTMLFormatCommandList";
function QWTMLFormatCommandList( )
{	
	// Just go back to the originating page
	global $QW;
	$commandList[] = "<A HREF='index.php?page=$QW[page]$QW[URLSuffix]'>Back to $QW[page]</A>";
	return $commandList;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////// Fill Template ///////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// Include the template
include_once( $QW_CONFIG['templateFilename'] );

// Output debugging, if requested
if( $QW_CONFIG['enableDebugging'] && $QW['requestDebug'] ) echo QWFormatDebug( );

?>