<?php 

////////////////////////////////////////////////////////////////////////////////
//////////////////////// Verify Installation ///////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// If it's not already installed, QWRedirect to the installer
if( !is_file( "data/INSTALLCOMPLETE" ) )
{
	// Redirect to the installer
	$url = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/install.php";
	header("Location: $url" );
	?><p>Please wait, redirecting to <a href="<?php echo $url; ?>">here</a>.</p><?php
	exit;
}

////////////////////////////////////////////////////////////////////////////////
/////////////////////////// Include Libraries //////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
require_once( "_util.php" );
require_once( "_config.php" );
require_once( "_wikiLib.php" );
require_once( "_render.php" );
require_once( "_mailinglistLib.php" );
	
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////// Set Globals /////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Global variables
$QW['homeLink'] = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']);
$homeLinkLength = strlen( $QW['homeLink'] );
if( $QW['homeLink'][$homeLinkLength-1] == '/' ) {$QW['homeLink'] = substr( $QW['homeLink'], 0, $homeLinkLength-1 );}
$QW['globalLockPath'] = 'data/GLOBALLOCK';

// Detect the input
if ( count( $_GET ) ) {$QW_REQUEST = $_GET;}
else {$QW_REQUEST = $_POST;}
	
// Strip all the $QW_REQUEST_VAR slashes
if( count( $QW_REQUEST ) ) {foreach( $QW_REQUEST as $name => $value )
	{$QW_REQUEST[ $name ] = stripslashes( $value );}}

// Pick out the useful request vars
$QW['requestFrom']     = trim(QWSafeGet( $QW_REQUEST, 'from' ));
$QW['requestPage']     = trim(QWSafeGet( $QW_REQUEST, 'page' ));
$QW['requestAction']   = trim(QWSafeGet( $QW_REQUEST, 'action' ));
$QW['requestPassword'] = trim(QWSafeGet( $QW_REQUEST, 'password' ));
$QW['requestConfirm']  = trim(QWSafeGet( $QW_REQUEST, 'confirm' ));
$QW['requestWikiData'] = trim(QWSafeGet( $QW_REQUEST, 'wikidata' ));
$QW['requestFilename'] = trim(QWSafeGet( $QW_REQUEST, 'filename' ));
$QW['requestDebug']    = trim(QWSafeGet( $QW_REQUEST, 'debug' ));
$QW['requestQuery']    = trim(QWSafeGet( $QW_REQUEST, 'query' ));
$QW['requestEmail']    = trim(QWSafeGet( $QW_REQUEST, 'email' ));
$QW['requestHTML']     = trim(QWSafeGet( $QW_REQUEST, 'html' ));
$QW['requestNotify']   = trim(QWSafeGet( $QW_REQUEST, 'notify' ));
$QW['requestHelp']     = trim(QWSafeGet( $QW_REQUEST, 'help' ));
$QW['requestProtect']  = trim(QWSafeGet( $QW_REQUEST, 'protect' ));
$QW['requestUsername'] = trim(QWSafeGet( $QW_REQUEST, 'username' ));

// Determine which page we're using:
if( !$QW['requestPage'] || !QWValidPageName( $QW['requestPage'] )) {
	$QW['page'] = $QW_CONFIG['startPage'];
} else {
	$QW['page'] = $QW['requestPage'];
}

// Get the file associated with this page
$QW['pagePath']  = QWCreateDataPath( $QW['page'], '.qwiki' );
$QW['lockPath']  = QWCreateDataPath( $QW['page'], '.lock' );
$QW['passPath']  = QWCreateDataPath( $QW['page'], '.pass' );
$QW['mailPath']  = QWCreateDataPath( $QW['page'], '.mail' );
$QW['attachDir'] = QWCreateDataPath( $QW['page'], '_attach' );	
$QW['fromPagePath']  = ( $QW['requestFrom'] && $QW['requestFrom'] != $QW['page'] ) ? 
                   	 QWCreateDataPath( $QW['requestFrom'], '.qwiki' ) : 
                   	 "";
$QW['fromPassPath']  = ( $QW['requestFrom'] && $QW['requestFrom'] != $QW['page'] ) ? 
                   	 QWCreateDataPath( $QW['requestFrom'], '.pass' ) : 
                   	 "";
                   	
// Strip all the $_COOKIE slashes
QWStripArraySlashes( $_COOKIE );
	
// Pick out the useful cookie variables
$QW['cookiePassword']    = QWSafeGet( $_COOKIE, 'password' );
$QW['cookieRecentPages'] = QWSafeGet( $_COOKIE, 'recentpages' );
if( $QW['cookieRecentPages'] ) $QW['cookieRecentPageList'] = unserialize( $QW['cookieRecentPages'] );
else                           $QW['cookieRecentPageList'] = array( $QW_CONFIG['startPage'] );

// See if the user is authenticated, implicitly or otherwise
$QW['encryptedPassword'] = md5( $QW_CONFIG['adminPassword'] );
$QW['pageIsProtected'] = $QW_CONFIG['globalEditLock'] || ( $QW['fromPassPath'] ? is_file( $QW['fromPassPath'] ) : is_file( $QW['passPath'] ) );
$QW['userIsAuthenticated'] = ($QW['cookiePassword'] == $QW['encryptedPassword']);

// Prepare to append URLs
$QW['debugURLSuffix'] = ( $QW['requestDebug'] ? "&amp;debug=true" : "" );
$QW['helpURLSuffix'] = ( $QW['requestHelp'] ? "&amp;help=true" : "" );
$QW['URLSuffix'] = $QW['debugURLSuffix'] . $QW['helpURLSuffix'];
$QW['hrefTarget'] = "";

// NoOp template functions
function QWNoOp( ) { }
$QW_TEMPLATE['getTitle'] = "QWNoOp";
$QW_TEMPLATE['injectBody'] = "QWNoOp";
$QW_TEMPLATE['commandList'] = "QWNoOp";

?>