<?php 
require_once( "_global.php" );
QWDisableCaching( );

//checks
if(!$QW['requestPage'])
  {QWRedirect( "index.php" );exit;}
if(!$QW['userIsAuthenticated'])
  {QWRedirect( "login.php?$QW[page]$QW[URLSuffix]" );exit;}
if(!is_file($QW['pagePath']))
  {QWRedirect( "index.php" );exit;}

// Update the list of recently viewed pages
$recentlyViewedPages[] = $QW['page'];
if( isset( $QW['cookieRecentPageList'] ) ) 
{$QW['cookieRecentPageList'] = array_merge( array( $QW['page'] ), $QW['cookieRecentPageList'] );}
else                                      
{$QW['cookieRecentPageList'] = array( $QW['page'] );}
$QW['cookieRecentPageList'] = QWUnduplicateArray( $QW['cookieRecentPageList'] );
QWTruncateArrayInPlace( $QW['cookieRecentPageList'], 20 ); // only keep a history of 20 pages
setcookie( "recentpages", serialize( $QW['cookieRecentPageList'] ), time()+60*60*24*30 );

// QWTDeleteFormatTitle
$titlePrefix = "Deleting document | Document: ";
$QW_TEMPLATE['getTitle'] = "QWTDeleteFormatTitle";
function QWTDeleteFormatTitle( )
{global $titlePrefix, $QW;
return  $titlePrefix . QWCleanQwikiPageName( $QW['page'] );
}
//directory removal function
function remove_dir($dir)
{
$handle = opendir($dir);
while (false!==($item = readdir($handle)))
 {
 if($item != '.' && $item != '..')
   {if(is_dir($dir.'/'.$item)) 
     {remove_dir($dir.'/'.$item);}
    else
     {unlink($dir.'/'.$item);}
   }
 }
closedir($handle);
if(rmdir($dir))
 {$success = true;}
return $success;
}

// QWTDeleteFormatBody
$QW_TEMPLATE['injectBody'] = "QWTDeleteFormatBody";
function QWTDeleteFormatBody( )
{
global $QW;
$pagename =  $QW['page'];
if (!QWLockExists($QW['lockPath']))
 {
 $file2delete = 'data/' . $pagename .'.qwiki';
 if(file_exists($file2delete)){unlink($file2delete); echo('...deleted main .qwiki file.<br />');}
 $file2delete = 'data/' . $pagename .'.lock';
 if(file_exists($file2delete)){unlink($file2delete); echo('...deleted .lock file.<br />');}
 $file2delete = 'data/' . $pagename .'.pass';
 if(file_exists($file2delete)){unlink($file2delete); echo('...deleted .pass file.<br />');}
 $dir = 'data/' . $pagename . '_attach';
 if(file_exists($dir)){ remove_dir($dir); echo('...deleted attachments.<br />');}
 $dir = 'backups/' . $pagename;
 if(file_exists($dir)){ remove_dir($dir); echo('...deleted backups.<br />');}
 echo ('<br />This wiki document and associated files have been deleted. You may log out now.');
 }
else 
 {
 echo ('<p>This wiki document is being edited by someone. Deletion is not currently possible. Please try later.</p>');
 }
}

// QWTDeleteFormatCommandList
$QW_TEMPLATE['commandList'] = "QWTDeleteFormatCommandList";
function QWTDeleteFormatCommandList( )
{global $QW, $QW_CONFIG, $_SERVER;	
 if($QW['userIsAuthenticated']){$commandList[]='<a href="logout.php">Admin logout</a>';}
   else{$commandList[]='<a href="login.php">Admin login</a>';}
 if($QW['requestFrom']){$fromSuffix="&amp;from=$QW[requestFrom]";}
   else{$fromSuffix="";}
 return $commandList;
}

// Include the template
include_once( $QW_CONFIG['templateFilename'] );

// Output debugging, if requested
if( $QW_CONFIG['enableDebugging'] && $QW['requestDebug'] ) {echo QWFormatDebug( );}

// Report all PHP errors (bitwise 63 may be used in PHP 3)
error_reporting(E_ALL);
?>