/*!40101 SET NAMES utf8 */;
SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `cell-lines` (
  `id` int(11) NOT NULL auto_increment,
  `owner` varchar(64) NOT NULL default '',
  `name` varchar(64) NOT NULL default '',
  `nature` varchar(128) NOT NULL default '',
  `type` varchar(64) NOT NULL default '',
  `description` text NOT NULL,
  `generation` text NOT NULL,
  `source` text NOT NULL,
  `acquired_on` varchar(128) NOT NULL default '',
  `selection` varchar(128) NOT NULL default '',
  `cult_feat` text NOT NULL,
  `freez_thaw_feat` text NOT NULL,
  `sev_loc` text NOT NULL,
  `hun_loc` text NOT NULL,
  `nit_loc` text NOT NULL,
  `sev_box` text NOT NULL,
  `hun_box` text NOT NULL,
  `nit_box` text NOT NULL,
  `experiment` text NOT NULL,
  `comment` text NOT NULL,
  `added_by` varchar(128) NOT NULL default '',
  `added_on` date NOT NULL default '0000-00-00',
  `modified_by` varchar(128) NOT NULL default '',
  `modified_on` date NOT NULL default '0000-00-00',
  `ID_user` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE `chemicals` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(128) NOT NULL default '',
  `nature` varchar(64) NOT NULL default '',
  `source` varchar(64) NOT NULL default '',
  `lot_no` varchar(32) NOT NULL default '',
  `cat_no` varchar(32) NOT NULL default '',
  `acquired_on` varchar(32) NOT NULL default '',
  `expiry_date` varchar(32) NOT NULL default '',
  `use` text NOT NULL,
  `condition` varchar(128) NOT NULL default '',
  `amount` varchar(64) NOT NULL default '',
  `box` varchar(64) NOT NULL default '',
  `fridge` varchar(64) NOT NULL default '',
  `experiment` text NOT NULL,
  `comment` text NOT NULL,
  `added_on` date NOT NULL default '0000-00-00',
  `added_by` varchar(64) NOT NULL default '',
  `modified_on` date NOT NULL default '0000-00-00',
  `modified_by` varchar(64) NOT NULL default '',
  `ID_user` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `chemicals` values('1','Caspase-1 inhibitor','Chemical','Alexis','l04053/b','260-028-m001','2004-10-14','','','dry','1 mg','Common stock - protein and chemicals','Fridge 3 at -20','','A chloromethylketone','2005-04-28','Common Lab','2005-09-06','','0');

CREATE TABLE `dadabik_cell-lines` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL,
  `primary_key_table_field` varchar(255) NOT NULL,
  `primary_key_db_field` varchar(50) NOT NULL,
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL,
  `linked_fields_extra_mysql` varchar(255) NOT NULL,
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL,
  `height_field` varchar(5) NOT NULL,
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL,
  `order_form_field` smallint(6) NOT NULL,
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_cell-lines` values('id','Database ID','text','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('owner','Owner','select_single','alphanumeric','1','1','1','1','1','1','0','1','','name','users','','name','name','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','2','~'),
 ('name','Name and aliases','textarea','alphanumeric','1','1','1','1','1','1','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','','3','~'),
 ('nature','Nature','select_single','alphanumeric','1','1','1','1','1','1','0','1','~293T~3T3~CHO-B2~CHO-K1~CHO Lec mutant~CHO-W5~COS~HeLa~HL60L~MEF~Mouse ES cells~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','100','','4','~'),
 ('type','Type','select_single','alphanumeric','1','1','1','1','1','0','0','1','~cDNA lib. transfectant~gDNA lib. transfectant~Expression const. transfectant~RNAi transfectant~Untransfected~Vector-only transfectant~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','','','5','~'),
 ('description','Description','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','4','','optional','6','~'),
 ('generation','Generation','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','e.g., clone isolated after selection','7','~'),
 ('source','Source','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','2','','e.g., ATCC, Yinghui, etc.','8','~'),
 ('acquired_on','Acquisition date','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','100','when obtained','9','~'),
 ('selection','Selection req.','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','','e.g., 0.5 mg/ml G418','10','~'),
 ('cult_feat','Special culture conditions','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','2','','e.g., grow at RT','11','~'),
 ('freez_thaw_feat','Freeze/thaw conditions','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','2','100','only if special','12','~'),
 ('sev_loc','Stock at -70 or -80','select_single','alphanumeric','1','1','1','1','1','0','0','1','~4th floor Chanin~C524 Harris -70~Lab Revco -80~None~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','100','','13','~'),
 ('hun_loc','-135 stock','select_single','alphanumeric','1','1','1','1','1','0','0','1','~4th floor Chanin~None~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','100','','14','~'),
 ('nit_loc','Liq. N2 stocks','select_single','alphanumeric','1','1','1','1','1','0','0','1','~4th floor Chanin~None~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','100','','15','~'),
 ('sev_box','-70 stock details','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','4','','e.g., 2 vials in box D8<br>frozen at 1.6 on 4-12-04<br>in Lab -80','16','~'),
 ('hun_box','-135 stock details','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','4','','','17','~'),
 ('nit_box','N2 stock details','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','4','','','18','~'),
 ('experiment','experiment','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','4','','','19','~'),
 ('comment','Comment','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','','20','~'),
 ('added_by','Added by','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','21','~'),
 ('added_on','Add date','insert_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','22','~'),
 ('modified_by','Modified by','select_single','alphanumeric','1','1','1','1','1','0','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','23','~'),
 ('modified_on','Modified on','update_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','24','~'),
 ('ID_user','ID_user','ID_user','alphanumeric','0','0','0','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~');

CREATE TABLE `dadabik_chemicals` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL default '',
  `primary_key_table_field` varchar(255) NOT NULL default '',
  `primary_key_db_field` varchar(50) NOT NULL default '',
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL default '',
  `linked_fields_extra_mysql` varchar(255) NOT NULL default '',
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL default '',
  `height_field` varchar(5) NOT NULL default '',
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL default '',
  `order_form_field` smallint(6) NOT NULL default '0',
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_chemicals` values('id','Database ID','text','alphanumeric','0','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('name','Name or description','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','','','2','~'),
 ('nature','Nature','select_single','alphanumeric','1','1','1','1','1','1','0','1','~Activator~Chemical~DNA~Sugar~Inhibitor~Organic~Peptide~RNA~Salt~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','','3','~'),
 ('source','Source','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','','eg, Fisher, Scherer lab','4','~'),
 ('lot_no','Lot number','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','','5','~'),
 ('cat_no','Catalog number','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','','6','~'),
 ('acquired_on','Acquired on','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','','7','~'),
 ('expiry_date','Expiry date','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','eg, in 2 yrs, 10/2004','8','~'),
 ('use','Use for','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','100','eg, ER stress, apoptosis','9','~'),
 ('condition','Condition','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','','eg, in DMSO, lyophilized','10','~'),
 ('amount','Amount','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','','eg, 2 vials, 20 ug','11','~'),
 ('box','Box stored in','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','eg, B12, SP no. 4','12','~'),
 ('fridge','Location','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Fridge 1 at -20~Fridge 1 at 4 deg~Fridge 2 at -20~Fridge 2 at 4 deg~Fridge 3 at -20~Fridge 3 at 4 deg~Lab REVCO at -80~Middle cold room~End cold room~End cold room dessicator~Lab backbench~Lab dessicator~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','13','~'),
 ('experiment','Experiment info','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','','eg, use in Barry\'s BP134','14','~'),
 ('comment','Comment','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','','','15','~'),
 ('added_on','Added on','insert_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','16','~'),
 ('added_by','Added by','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','17','~'),
 ('modified_on','Modified on','update_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','18','~'),
 ('modified_by','Modified by','select_single','alphanumeric','1','1','1','1','1','0','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','19','~'),
 ('ID_user','ID_user','ID_user','alphanumeric','0','0','0','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~');

CREATE TABLE `dadabik_others` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL default '',
  `primary_key_table_field` varchar(255) NOT NULL default '',
  `primary_key_db_field` varchar(50) NOT NULL default '',
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL default '',
  `linked_fields_extra_mysql` varchar(255) NOT NULL default '',
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL default '',
  `height_field` varchar(5) NOT NULL default '',
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL default '',
  `order_form_field` smallint(6) NOT NULL default '0',
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_others` values('id','ID','text','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('name','Description or name','textarea','alphanumeric','1','1','1','1','1','1','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','2','~'),
 ('category','Category','select_single','alphanumeric','1','1','1','1','1','1','0','1','~Book~Computer hardware~Manual~Software~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','','100','','3','~'),
 ('usage','Usage','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','briefly','4','~'),
 ('quantity','Quantity','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','100','','5','~'),
 ('condition','Condition or status','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Lent~Lost~Misplaced~OK~Stolen~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','','100','','6','~'),
 ('location','Location','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','7','~'),
 ('requirement','Requirement','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','8','~'),
 ('comment','Comment','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','9','~'),
 ('added_by','Added by','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','21','~'),
 ('added_on','Added on','insert_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','11','~'),
 ('modified_by','Modified by','select_single','alphanumeric','1','1','1','1','1','0','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','23','~'),
 ('modified_on','Modified on','update_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','13','~'),
 ('ID_user','ID_user','ID_user','alphanumeric','0','0','0','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~');

CREATE TABLE `dadabik_parts` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL default '',
  `primary_key_table_field` varchar(255) NOT NULL default '',
  `primary_key_db_field` varchar(50) NOT NULL default '',
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL default '',
  `linked_fields_extra_mysql` varchar(255) NOT NULL default '',
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL default '',
  `height_field` varchar(5) NOT NULL default '',
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL default '',
  `order_form_field` smallint(6) NOT NULL default '0',
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_parts` values('id','ID','text','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('name','Description or name','textarea','alphanumeric','1','1','1','1','1','1','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','2','~'),
 ('category','Category','select_single','alphanumeric','1','1','1','1','1','1','0','1','~Dionex HPLC~Olympus upright~Voyager MALDI-TOF~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','','100','','3','~'),
 ('usage','Usage','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','briefly','4','~'),
 ('quantity','Quantity','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','100','','5','~'),
 ('condition','Condition','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Damaged but working~Damaged and not working~Not working~Out of service~Retired but works~Unused~Working~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','','100','','6','~'),
 ('location','Location','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','7','~'),
 ('requirement','Requirement','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','8','~'),
 ('comment','Comment','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','9','~'),
 ('added_by','Added by','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','21','~'),
 ('added_on','Added on','insert_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','11','~'),
 ('modified_by','Modified by','select_single','alphanumeric','1','1','1','1','1','0','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','23','~'),
 ('modified_on','Modified on','update_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','13','~'),
 ('ID_user','ID_user','ID_user','alphanumeric','0','0','0','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~');

CREATE TABLE `dadabik_plasmids` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL default '',
  `primary_key_table_field` varchar(255) NOT NULL default '',
  `primary_key_db_field` varchar(50) NOT NULL default '',
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL default '',
  `linked_fields_extra_mysql` varchar(255) NOT NULL default '',
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL default '',
  `height_field` varchar(5) NOT NULL default '',
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL default '',
  `order_form_field` smallint(6) NOT NULL default '0',
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_plasmids` values('id','Database ID','text','numeric','0','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('name','Name and aliases','textarea','alphanumeric','1','1','1','1','1','1','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','','2','~'),
 ('description','Description','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','e.g., mouse kidney full Fut10<br>ORF, TA cloned','3','~'),
 ('insert','Insert description','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','e.g., mFut10 full ORF 1429 bp<br>GenBank ID BA12653','4','~'),
 ('vector','Vector','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','','','e.g., pcDNA3.1/Myc-His/B+','5','~'),
 ('owner','Owner','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','28','~'),
 ('generation','Generation','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','5','','e.g., EcoRI-fragment from pCR2.1<br>clone blunt-cloned into BamHI-SpeI<br>vector fragment of pSecFc-mFut10<br>given by Santosh','6','~'),
 ('mam_prom','Mammalian promoter','select_single','alphanumeric','1','1','1','1','1','0','0','1','~CMV~EF1 alpha~H1~LTR~None~SV40~Tet~TK~U6~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','7','~'),
 ('other_prom','Other promoters','select_single','alphanumeric','1','1','1','1','1','0','0','1','~SP6~T3~T7~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','8','~'),
 ('feature','Special features','select_multiple','alphanumeric','1','1','1','1','1','0','0','1','~APRT~DHFR~Galactosidase~HGPRT~IRES~TK~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','9','~'),
 ('tag','Fusion tags','select_multiple','alphanumeric','1','1','1','1','1','0','0','1','~C-terminal alk. phos.~C-terminal FLAG~C-terminal GFP~C-terminal GST~C-terminal hIgG1 Fc~C-terminal HA~C-terminal His~C-terminal Myc~C-terminal V5~N-terminal alk. phos.~N-terminal FLAG~N-terminal GFP~N-terminal GST~N-terminal HA~N-terminal hIgG1 Fc~N-terminal His~N-terminal Myc~N-terminal V5~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','10','~'),
 ('bact_sel','Bacterial selection','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Actinomycin~Ampicillin~Carbenicillin~Cefotaxime~Chloramphenicol~Kanamycin~Streptomycin~Tetracycline~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','11','~'),
 ('other_sel','Other selection','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Blasticidin S~G418/genticin/neomycin~Hygromycin~Mycophenolic acid~None~Puromycin~Zeocin~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','12','~'),
 ('plasmid_box','Storage box','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','','','13','~'),
 ('plasmid_fridge','Storage box location','select_single','alphanumeric','1','1','1','1','1','0','0','1','~3rd floor min 20~Fridge 1 at min 20~Fridge 2 at min 20~Fridge 3 at min 20~Lab REVCO -80~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','14','~'),
 ('bact_box','Storage box for bacteria','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','','bacteria carrying the plasmid','15','~'),
 ('bact_fridge','Location of above box','select_single','alphanumeric','1','1','1','1','1','0','0','1','~4th floor -135~4th floor liquid N2~C524 Harris -80~Lab REVCO -80~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','16','~'),
 ('source','Source','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','2','','e.g., self, Shaolin, Stein lab','17','~'),
 ('acquired_on','Acquired on','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','1','','optional; e.g., June 2001','18','~'),
 ('experiment','Experiment info.','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','2','','e.g., made in SS41','19','~'),
 ('comment','Comment','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','','20','~'),
 ('map_file','Plasmid map','generic_file','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','Filename should have extension. Limit width to 700 px.','21','~'),
 ('insert_seq_file','Insert sequence','generic_file','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','Plain text (.txt) or Word (.doc) file will be best','22','~'),
 ('extra_file','Extra file','generic_file','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','e.g., entire vector sequence. Filename should have extension. Zip if more than one file','23','~'),
 ('added_by','Added by','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','24','~'),
 ('added_on','Added on','insert_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~'),
 ('modified_by','Modified by','select_single','alphanumeric','1','1','1','1','1','0','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','26','~'),
 ('modified_on','Modified on','update_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','27','~'),
 ('ID_user','ID_user','ID_user','alphanumeric','0','0','0','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~');

CREATE TABLE `dadabik_proteins` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL default '',
  `primary_key_table_field` varchar(255) NOT NULL default '',
  `primary_key_db_field` varchar(50) NOT NULL default '',
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL default '',
  `linked_fields_extra_mysql` varchar(255) NOT NULL default '',
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL default '',
  `height_field` varchar(5) NOT NULL default '',
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL default '',
  `order_form_field` smallint(6) NOT NULL default '0',
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_proteins` values('id','Database ID','text','alphanumeric','0','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('name','Name or description','textarea','alphanumeric','1','1','1','1','1','1','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','2','','eg, E-selectin, anti-CD24','2','~'),
 ('source','Source','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','2','','eg, Invitrogen, Scachter lab','4','~'),
 ('lot_no','Lot number','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','','10','~'),
 ('cat_no','Catalog number','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','','11','~'),
 ('expiry_date','Expiry date','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','','13','~'),
 ('fridge','Box location','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Fridge 1 at -20~Fridge 1 at 4 deg~Fridge 2 at -20~Fridge 2 at 4 deg~Fridge 3 at -20~Fridge 3 at 4 deg~Lab REVCO -80~......~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','20','1','','','16','~'),
 ('box','Box stored in','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','eg, B2, SW1','15','~'),
 ('amount','Amount available','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','eg, 3 vials, 20 ug','14','~'),
 ('experiment','Experiment info','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','eg, Santosh\'s X477','17','~'),
 ('nature','Nature','select_single','alphanumeric','1','1','1','1','1','1','0','1','~Enzyme~Extract~Lectin~Peptide~Primary antibody~Secondary antibody~Serum~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','15','1','','','3','~'),
 ('made_in','Made in','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Bacteria~Chicken~Donkey~Goat~Hamster~Human~In vitro~Mouse~Plant~Rabbit~Rat~Turkey~Yeast~......~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','20','1','','','5','~'),
 ('isotype','Isotype','select_single','alphanumeric','1','1','1','1','1','0','0','1','~IgA~IgD~IgE~IgG~IgG1~IgG2~IgG2a~IgG2b~IgG3~IgM~IgY~Irrelevant~Unknown~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','20','1','','','7','~'),
 ('clonality','Clonality','select_single','alphanumeric','1','1','1','1','1','0','0','0','~Monocolonal~Polyclonal~Irrelevant~Unknown~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','8','~'),
 ('conjugate','Conjugate','select_single','alphanumeric','1','1','1','1','1','0','0','1','~Alexa Fluor 350~Alexa Fluor 405~Alexa Fluor 430~Alexa Fluor 488~Alexa Fluor 500~Alexa Fluor 514~Alexa Fluor 532~Alexa Fluor 546~Alexa Fluor 555~Alexa Fluor 568~Alexa Fluor 594~Alexa Fluor 610~Alexa Fluor 633~Alexa Fluor 635~Alexa Fluor 647~Alexa Fluor 660~Alexa Fluor 680~Alexa Fluor 700~Alexa Fluor 750~Alk. phosphatase~APC~Avidin~Biotin~Cy3~Cy5~FITC~HRP~PE~Rhodamide~R-PE~Streptavidin~......~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','20','1','','eg, biotin, PE','9','~'),
 ('reactivity','Species, against','select_multiple','alphanumeric','1','1','1','1','1','0','0','1','~Bacteria~Chicken~Donkey~Goat~Hamster~Human~In vitro~Mouse~Plant~Rabbit~Rat~Turkey~Yeast~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','20','1','','','6','~'),
 ('comment','Comments','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','30','3','','','18','~'),
 ('acquired_on','Acquired on','text','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','1','100','eg, 3-11-04, last year','12','~'),
 ('added_by','Added by','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','19','~'),
 ('added_on','Added on','insert_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','20','~'),
 ('modified_by','Modified by','select_single','alphanumeric','1','1','1','1','1','0','0','0','','name','users','','name','name','','WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','21','~'),
 ('modified_on','Modified on','update_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','22','~'),
 ('ID_user','ID_user','ID_user','alphanumeric','0','0','0','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~');

CREATE TABLE `dadabik_records` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL default '',
  `primary_key_table_field` varchar(255) NOT NULL default '',
  `primary_key_db_field` varchar(50) NOT NULL default '',
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL default '',
  `linked_fields_extra_mysql` varchar(255) NOT NULL default '',
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL default '',
  `height_field` varchar(5) NOT NULL default '',
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL default '',
  `order_form_field` smallint(6) NOT NULL default '0',
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_records` values('id','Database ID','text','numeric','0','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('name','Description','textarea','alphanumeric','1','1','1','1','1','1','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','e.g., REVCO -80 box B11','2','~'),
 ('type','Type','select_single','alphanumeric','1','1','1','1','1','1','0','1','~Cell history~Correspondence~Data~Experiment~Freezer box record~Notice~Product insert~Product manual~Protocol~Stock sheet~Summary~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','','','3','~'),
 ('owner','Owner','select_single','alphanumeric','1','1','1','1','1','1','0','1','','name','users','','name','name','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','4','~'),
 ('experiment','Experiment info','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','','optional','5','~'),
 ('comment','Comment','textarea','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','25','3','100','','6','~'),
 ('added_by','Added by','select_single','alphanumeric','1','1','1','1','1','1','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','7','~'),
 ('added_on','Added on','insert_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','8','~'),
 ('modified_by','Modified by','select_single','alphanumeric','1','1','1','1','1','0','0','0','','name','users','','name','name','',' WHERE `status` = \'Current\'','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','9','~'),
 ('modified_on','Modified on','update_date','alphanumeric','1','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','10','~'),
 ('file','Uploaded file','generic_file','alphanumeric','1','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','Filename must have extension. Zip if many files','11','~'),
 ('ID_user','ID_user','ID_user','alphanumeric','0','0','0','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','25','~');

CREATE TABLE `dadabik_table_list` (
  `name_table` varchar(255) NOT NULL default '',
  `allowed_table` tinyint(4) NOT NULL default '0',
  `enable_insert_table` varchar(5) NOT NULL default '',
  `enable_edit_table` varchar(5) NOT NULL default '',
  `enable_delete_table` varchar(5) NOT NULL default '',
  `enable_details_table` varchar(5) NOT NULL default '',
  PRIMARY KEY  (`name_table`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_table_list` values('users','1','1','1','1','1'),
 ('proteins','1','1','1','1','1'),
 ('chemicals','1','1','1','1','1'),
 ('records','1','1','1','1','1'),
 ('plasmids','1','1','1','1','1'),
 ('cell-lines','1','1','1','1','1'),
 ('others','1','1','1','1','1'),
 ('parts','1','1','1','1','1');

CREATE TABLE `dadabik_users` (
  `name_field` varchar(50) NOT NULL default '',
  `label_field` varchar(255) NOT NULL default '',
  `type_field` enum('text','textarea','rich_editor','password','insert_date','update_date','date','select_single','select_multiple','select_multiple_checkbox','generic_file','image_file','ID_user','unique_ID') NOT NULL default 'text',
  `content_field` enum('alphabetic','alphanumeric','numeric','url','email','html','phone') NOT NULL default 'alphanumeric',
  `present_search_form_field` enum('0','1') NOT NULL default '1',
  `present_results_search_field` enum('0','1') NOT NULL default '1',
  `present_details_form_field` enum('0','1') NOT NULL default '1',
  `present_insert_form_field` enum('0','1') NOT NULL default '1',
  `present_ext_update_form_field` enum('0','1') NOT NULL default '1',
  `required_field` enum('0','1') NOT NULL default '0',
  `check_duplicated_insert_field` enum('0','1') NOT NULL default '0',
  `other_choices_field` enum('0','1') NOT NULL default '0',
  `select_options_field` text NOT NULL,
  `primary_key_field_field` varchar(255) NOT NULL,
  `primary_key_table_field` varchar(255) NOT NULL,
  `primary_key_db_field` varchar(50) NOT NULL,
  `linked_fields_field` text NOT NULL,
  `linked_fields_order_by_field` text NOT NULL,
  `linked_fields_order_type_field` varchar(255) NOT NULL,
  `linked_fields_extra_mysql` varchar(255) NOT NULL,
  `select_type_field` varchar(100) NOT NULL default 'is_equal/contains/starts_with/ends_with/greater_than/less_then',
  `prefix_field` text NOT NULL,
  `default_value_field` text NOT NULL,
  `width_field` varchar(5) NOT NULL,
  `height_field` varchar(5) NOT NULL,
  `maxlength_field` varchar(5) NOT NULL default '100',
  `hint_insert_field` varchar(255) NOT NULL,
  `order_form_field` smallint(6) NOT NULL,
  `separator_field` varchar(2) NOT NULL default '~',
  PRIMARY KEY  (`name_field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `dadabik_users` values('ID_user','Unique user ID','text','numeric','0','1','1','0','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','1','~'),
 ('name','Full name (first, last)','text','alphanumeric','1','1','1','1','1','1','1','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','','2','~'),
 ('md5_password','Password (MD5 encrypted)','text','alphanumeric','1','1','1','1','1','1','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','<a href=\"javascript:void(generic_js_popup(\'pwd.php\',\'\',400,300))\">create MD5-hashed password</a>','4','~'),
 ('status','Past or current','select_single','alphanumeric','1','1','1','1','1','1','0','0','~Current~Past~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','choose one','6','~'),
 ('group','User group','select_single','alphanumeric','0','1','1','1','1','1','0','0','~Normal~Administrator~','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','options here should match those in config.php','5','~'),
 ('comment','Comment','textarea','alphanumeric','0','1','1','1','1','0','0','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','20','3','100','','7','~'),
 ('username','Username for logging in','text','alphanumeric','1','1','1','1','1','1','1','0','','','','','','','','','is_equal/contains/starts_with/ends_with/greater_than/less_then','','','','','100','single word of 6-12 characters','3','~');

CREATE TABLE `others` (
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `category` varchar(128) NOT NULL default '',
  `usage` text NOT NULL,
  `quantity` text NOT NULL,
  `condition` text NOT NULL,
  `location` text NOT NULL,
  `requirement` text NOT NULL,
  `comment` text NOT NULL,
  `added_by` text NOT NULL,
  `added_on` date NOT NULL default '0000-00-00',
  `modified_by` text NOT NULL,
  `modified_on` date NOT NULL default '0000-00-00',
  `ID_user` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE `parts` (
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `category` varchar(128) NOT NULL default '',
  `usage` text NOT NULL,
  `quantity` text NOT NULL,
  `condition` text NOT NULL,
  `location` text NOT NULL,
  `requirement` text NOT NULL,
  `comment` text NOT NULL,
  `added_by` text NOT NULL,
  `added_on` date NOT NULL default '0000-00-00',
  `modified_by` text NOT NULL,
  `modified_on` date NOT NULL default '0000-00-00',
  `ID_user` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `parts` values('1','Wireless mouse for Wacom graphic tablet','Computer accessories','for Wacom graphic tablet','1','Working','Computer area drawer','','','Santosh Patnaik','2005-10-05','Avidin','2005-10-29','5');

CREATE TABLE `plasmids` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `insert` varchar(255) NOT NULL default '',
  `vector` varchar(255) NOT NULL default '',
  `owner` varchar(128) NOT NULL default '',
  `generation` text NOT NULL,
  `mam_prom` varchar(255) NOT NULL default '',
  `other_prom` varchar(255) NOT NULL default '',
  `feature` text NOT NULL,
  `tag` text NOT NULL,
  `bact_sel` varchar(255) NOT NULL default '',
  `other_sel` varchar(255) NOT NULL default '',
  `plasmid_box` varchar(255) NOT NULL default '',
  `plasmid_fridge` varchar(255) NOT NULL default '',
  `bact_box` varchar(255) NOT NULL default '',
  `bact_fridge` varchar(255) NOT NULL default '',
  `source` varchar(255) NOT NULL default '',
  `acquired_on` varchar(255) NOT NULL default '',
  `experiment` text NOT NULL,
  `comment` text NOT NULL,
  `map_file` text NOT NULL,
  `insert_seq_file` text NOT NULL,
  `extra_file` text NOT NULL,
  `added_by` varchar(64) NOT NULL default '',
  `added_on` date NOT NULL default '0000-00-00',
  `modified_by` varchar(64) NOT NULL default '',
  `modified_on` date NOT NULL default '0000-00-00',
  `ID_user` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `proteins` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `source` varchar(128) NOT NULL default '',
  `lot_no` varchar(32) NOT NULL default '',
  `cat_no` varchar(32) NOT NULL default '',
  `expiry_date` varchar(32) NOT NULL default '',
  `fridge` varchar(64) NOT NULL default '',
  `box` varchar(64) NOT NULL default '',
  `amount` varchar(64) NOT NULL default '',
  `experiment` text NOT NULL,
  `nature` varchar(64) NOT NULL default '',
  `made_in` varchar(128) NOT NULL default '',
  `isotype` varchar(32) NOT NULL default '',
  `clonality` varchar(64) NOT NULL default '',
  `conjugate` varchar(64) NOT NULL default '',
  `reactivity` varchar(255) NOT NULL default '',
  `comment` text NOT NULL,
  `acquired_on` varchar(32) NOT NULL default '',
  `added_by` varchar(64) NOT NULL default '',
  `added_on` date NOT NULL default '0000-00-00',
  `modified_by` varchar(64) NOT NULL default '',
  `modified_on` date NOT NULL default '0000-00-00',
  `ID_user` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `proteins` values('1','IgG2b','Southern Biotech','','','','2 at 4 deg','Secondary ab 1','1 vial','','Secondary ab','Goat','','','AP','mouse','','','','0000-00-00','','2005-04-10','0');

CREATE TABLE `records` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `type` varchar(64) NOT NULL default '',
  `owner` varchar(64) NOT NULL default '',
  `experiment` text NOT NULL,
  `comment` text NOT NULL,
  `added_by` varchar(64) NOT NULL default '',
  `added_on` date NOT NULL default '0000-00-00',
  `modified_by` varchar(64) NOT NULL default '',
  `modified_on` date NOT NULL default '0000-00-00',
  `file` text NOT NULL,
  `ID_user` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `records` values('1','D8 / Lab Revco -80','Freezer box record','Common Lab','','contains only mammalian cells; as of March 2005','Santosh Patnaik','2005-04-28','','2005-04-28','The filepath is - records/D8.jpg','0');

CREATE TABLE `users` (
  `ID_user` int(11) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `md5_password` varchar(32) NOT NULL,
  `status` varchar(32) NOT NULL default '',
  `group` varchar(64) NOT NULL default '',
  `comment` varchar(255) NOT NULL default '',
  `username` varchar(32) NOT NULL,
  PRIMARY KEY  (`ID_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

insert into `users` values('1','Common Lab','c833584a58d05124ca69af49805e6c20','Current','Administrator','','root');

SET FOREIGN_KEY_CHECKS = 1;