<?php

/*
LabStoRe
Version: 1.6.3
Date: 6 September 2014
Copyright: Santosh Patnaik, MD, PhD
License: GPL 3+
URL: www.bioinformatics.org/phplabware
*/

include(realpath(dirname(__FILE__) . '/start.php'));

header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Pragma: no-cache");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Cache-control: private");
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Language" content="en-us" />
<title><?php echo($mainsite_name . ' - ' . $parentsite_name);?></title>
<style type="text/css" media="all">
/*<![CDATA[*/
@import "<?php echo($parentsite_url);?>style.css";
/*]]>*/
</style>
<meta name="Description" content="<?php echo($meta_description);?>" />
<meta name="Keywords" content="<?php echo($meta_keywords);?>" />
<meta name="Generator" content="<?php echo($meta_generator);?>" />
<script type="text/javascript">
//<![CDATA[
<!--//
function popitup(url)
{
window.name='main';
newwindow=window.open(url,'poppedfirst','<?php echo $popup_parameters;?>');
if (window.focus) {newwindow.focus()}
return false;
}
function confipop(url)
{
var agree = confirm ("Are you sure?");
if (agree)
 {
newwindow=window.open(url,'poppedfirst','height=200,width=200,scrollbars=no,resizable=no');
 if (window.focus) {newwindow.focus()}
 }
return false;
}
// -->
//]]>
</script>
<?php

// Module-specific extra for head element - comes from module specific php file
echo $head_extra, '</head>
<body>
<div style="padding-left: 5px;">
<h1 class="onlyscreen">
<a href="', $mainsite_url, '">', $mainsite_name, '</a> - <a href="', $parentsite_url, '">', $parentsite_name, '</a></h1>';
$date = date("l, F j, Y");

// Get log_status - if authentication enabled, & show logout
$log_status = '';
if($enable_authentication === 1 or $enable_admin_authentication === 1) {
  if(isset($_SESSION['logged_user_infos_ar']['username_user'])) {
    $log_status = '<a href="' . $site_url . $dadabik_login_file . '?function=logout&amp;go_to=parent_front">Log out - ' . htmlspecialchars($_SESSION['logged_user_infos_ar']['username_user']) . '</a> || ';
  }
}

// Part for header on modules' pages, e.g., proteins.php; depending on activated modules (config.php)
$header_to_show = $log_status;
foreach($modules_array as $key=>$value) {
  $header_to_show .= '<a href="' . $parentsite_url . 'modules/' . htmlspecialchars($value[3]) . '" title="' . htmlspecialchars($value[2]) . '">';
  if($value[4] == $table) {
    $header_to_show .= '<b>' . htmlspecialchars($value[1]) . '</b>';
  }
  else {
    $header_to_show .= htmlspecialchars($value[1]);
  }
  $header_to_show .= '</a>/';
}
$header_to_show = substr($header_to_show, 0, - 1); // remove last /
