<?php

/*
Interface Creator
www.bioinformatics.org/phplabware
6 September 2014 release
By Santosh Patnaik, MD, PhD
GPL license
Based on DaDaBik version 3.2 by Eugenio Tacchini - http://www.dadabik.org
*/

include(realpath(dirname(__FILE__) . '/../config.php'));
include(realpath(dirname(__FILE__) . '/functions.php'));
include(realpath(dirname(__FILE__) . '/common_start.php'));
include(realpath(dirname(__FILE__) . '/check_installation.php'));
include(realpath(dirname(__FILE__) . '/check_login.php'));
include(realpath(dirname(__FILE__) . '/check_table.php'));
include(realpath(dirname(__FILE__) . '/header.php'));

if(isset($_GET["export_to_csv"])) {
  $export_to_csv = $_GET["export_to_csv"];
}
if(!empty($_GET["where_clause"])) {
  $where_clause = denc($_GET["where_clause"]);
}
if(isset($_GET["page"])) {
  $page = intval($_GET["page"]);
}
if(!empty($_GET["order"])) {
  $order = denc($_GET["order"]);
}
// the order type ('ASC'|'DESC')
if(isset($_GET["order_type"])) {
  $order_type = $_GET["order_type"] == 'ASC' ? 'ASC' : 'DESC';
}
// the function of this page I wanto to execute ('edit'|'delete'|'search'....)
if(isset($_GET["function"])) {
  $function = $_GET["function"];
}
else {
  $function = "search";
}
// the field used to identify a single record in edit, delete and detail functions
if(isset($_GET["where_field"])) {
  $where_field = $_GET["where_field"];
}
// the value (of where_field) used to identify a single record in edit, delete and detail functions
if(isset($_GET["where_value"])) {
  $where_value = $_GET["where_value"];
}
// set to 1 when a research has been just executed
if(isset($_GET["execute_search"])) {
  $execute_search = $_GET["execute_search"];
}
// set to 1 after an update
if(isset($_GET["just_updated"])) {
  $just_updated = $_GET["just_updated"];
}
// set to 1 after an update with no authorization
if(isset($_GET["just_updated_no_authorization"])) {
  $just_updated_no_authorization = $_GET["just_updated_no_authorization"];
}
// set to 1 after a delete with no authorization
if(isset($_GET["just_delete_no_authorization"])) {
  $just_delete_no_authorization = $_GET["just_delete_no_authorization"];
}
// set to 1 after an insert
if(isset($_GET["just_inserted"])) {
  $just_inserted = $_GET["just_inserted"];
}
// set to 1 after a delete multiple with authentication enabled
if(isset($_GET["just_delete_all_authorizated"])) {
  $just_delete_all_authorizated = $_GET["just_delete_all_authorizated"];
}
// insert_duplication_form, set to 1 if the user want to insert anyway
if(isset($_GET["insert_duplication"])) {
  $insert_duplication = $_GET["insert_duplication"];
}

$action = $dadabik_main_file;
$show_record_numbers_change_table = 1;
$fields_labels_ar = build_fields_labels_array($table_internal_name, "1");
switch($function) {
  case "insert":
  if($enable_insert == "1") {
    $check = 0;
    $check = check_required_fields($fields_labels_ar);
    if($check == 0) {
      txt_out($normal_messages_ar["required_fields_missed"], "error_messages_form");
      $go_back_button = "<br /><br />" . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_check_form"];
      txt_out($go_back_button, "error_messages_form");
    }
    else {
      $check = 0;
      $check = check_length_fields($fields_labels_ar);
      if($check == 0) {
        txt_out($normal_messages_ar["fields_max_length"], "error_messages_form");
        $go_back_button = "<br /><br />" . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_check_form"];
        txt_out($go_back_button, "error_messages_form");
      }
      else {
        $check = 0;
        $content_error_type = "";
        $check = check_fields_types($fields_labels_ar, $content_error_type);
        if($check == 0) {
          txt_out($normal_messages_ar["{$content_error_type}_not_valid"], "error_messages_form");
          $go_back_button = "<br /><br />" . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_check_form"];
          txt_out($go_back_button, "error_messages_form");
        }
        else {
          $check = 0;
          $check = write_temp_uploaded_files($fields_labels_ar);
          if($check == 0) {
            txt_out($error_messages_ar["upload_error"], "error_messages_form");
            $go_back_button = "<br /><br />" . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_check_form"];
            txt_out($go_back_button, "error_messages_form");
          }
          else {
            if(!isset($insert_duplication) || $insert_duplication != '1') {
              $sql = build_select_duplicated_query($table_name, $fields_labels_ar, $string1_similar_ar, $string2_similar_ar);
              if($sql != "") {
                $check = 0;
                txt_out($normal_messages_ar["duplication_possible"], "normal_messages_form");
                if($display_is_similar == 1) {
                  for($i = 0;$i < count($string1_similar_ar);$i++) {
                    txt_out("<br />");
                    txt_out($normal_messages_ar["i_think_that"]);
                    txt_out($string1_similar_ar[$i]);
                    txt_out($normal_messages_ar["is_similar_to"]);
                    txt_out($string2_similar_ar[$i]);
                  }
                }
                $res_records = execute_db($sql, $conn, 'index.php');
                $results_type = "possible_duplication";
                $where_clause = "";
                $results_table = build_results_table($fields_labels_ar, $table_name, $res_records, $results_type, "", "", $action, $where_clause, "", "", "");
                txt_out($normal_messages_ar["similar_records"], "normal_messages_form");
                $insert_duplication_form = build_insert_duplication_form($fields_labels_ar, $table_name, $table_internal_name);
                echo $insert_duplication_form;
                echo $results_table;
              }
            }
            if($check === 1) {
              insert_record($fields_labels_ar, $table_name, $table_internal_name);
              if($insert_again_after_insert == 1) {
                txt_out($normal_messages_ar["record_inserted"], "normal_messages_form");
                txt_out("<h3>" . strtoupper($table_name) . "<br />" . $normal_messages_ar["insert_record"] . "</h3>");
                $form_type = "insert";
                $res_details = "";
                $fields_labels_ar = build_fields_labels_array($table_internal_name, "1");
                $form = build_form($table_name, $action, $fields_labels_ar, $form_type, $res_details, "", "");
                echo $form;
              }
              else {
                $unique_field_name = get_unique_field($table_name);
                $location_url = $site_url . $dadabik_main_file . '?table_name=' . rawurlencode($table_name) . '&function=search&where_clause=&page=0&just_inserted=1';
                if($unique_field_name != '') {
                  $location_url .= '&order=' . $unique_field_name . '&order_type=desc';
                }
                header('Location: ' . $location_url);
              }
            }
          }
        }
      }
    }
  }
  break;
  case "search":
  if(!isset($page)) {
    $page = 0;
  }
  if(isset($execute_search) && $execute_search === '1') {
    $where_clause = build_where_clause($fields_labels_ar, $table_name);
  }
  elseif(!isset($where_clause)) {
    $where_clause = '';
  }
  $where_clause_to_pass = $where_clause;
  if($enable_authentication === 1 && $enable_browse_authorization === 1) {
    $ID_user_field_name = get_ID_user_field_name($fields_labels_ar);
    if($ID_user_field_name !== false) {
      if($where_clause === '') {
        $where_clause = '`' . add_slashes($table_name, 1) . '`.`' . add_slashes($ID_user_field_name, 1) . '`=' . add_slashes($current_user);
      }
      else {
        $where_clause .= " AND `" . add_slashes($table_name, 1) . '`.`' . add_slashes($ID_user_field_name, 1) . '`=' . add_slashes($current_user);
      }
    }
  }
  $sql = build_select_part($fields_labels_ar, $table_name);
  if($where_clause != "") {
    $sql .= " WHERE " . $where_clause;
  }
  $res_records_without_limit = execute_db($sql, $conn, 'index.php');
  $select_without_limit = $sql;
  $results_number = database_num_rows($res_records_without_limit);
  if($results_number > 0) {
    $pages_number = get_pages_number($results_number, $records_per_page);
    if(isset($export_to_csv) && $export_to_csv == 1 && $export_to_csv_feature == 1) {
      $csv = build_csv($res_records_without_limit, $fields_labels_ar);
      ob_end_clean();
      header("Content-Type: text/x-csv");
      header('Content-Disposition: attachment; filename="' . $table_name . '.csv"');
      echo $csv;
      exit;
    }
    if(!isset($order)) {
      $count_temp = 0;
      $fields_labels_ar_count = count($fields_labels_ar);
      while(!isset($order) && $count_temp < $fields_labels_ar_count) {
        if($fields_labels_ar[$count_temp]["present_results_search_field"] === '1') {
          $order = $fields_labels_ar[$count_temp]["name_field"];
        }
        $count_temp++;
      }
      if(!isset($order)) {
        $order = $fields_labels_ar[0]["name_field"];
      }
    }
    if(!isset($order_type)) {
      $order_type = "ASC";
    }
    if($page > ($pages_number - 1)) {
      $page = $pages_number - 1;
    }
    $sql .= " ORDER BY ";
    $count_temp = 0;
    foreach($fields_labels_ar as $field) {
      if($field['name_field'] === $order) {
        $field_index = $count_temp;
        break;
      }
      $count_temp++;
    }
    $sql .= '`' . add_slashes($table_name, 1) . '`.`' . add_slashes($fields_labels_ar[$field_index]["name_field"], 1) . '`';
    $sql .= ' ' . $order_type;
    $sql .= " LIMIT " . intval($page * $records_per_page) . " , " . $records_per_page;
    $res_records = execute_db($sql, $conn, 'index.php');
    if(isset($just_inserted) && $just_inserted == "1") {
      txt_out($normal_messages_ar["record_inserted"], "normal_messages_form");
    }
    if(isset($just_delete_all_authorizated) && $just_delete_all_authorizated == "1" && $enable_browse_authorization === 0) {
      txt_out($error_messages_ar["deleted_only_authorizated_records"], "error_messages_form");
    }
    if(isset($just_delete_no_authorization) && $just_delete_no_authorization == "1") {
      txt_out($error_messages_ar["no_authorization_update_delete"], "error_messages_form");
    }
    txt_out("<br />" . $results_number . " " . $normal_messages_ar["records_found"], "n_results_found");
    if($enable_delete == "1" && $enable_delete_all_feature === 1) {
      echo " <a class=\"onlyscreen\" onclick=\"if (!confirm('", $normal_messages_ar['confirm_delete?'], "')){ return false;}else if (!confirm('", $normal_messages_ar['really?'], "')){ return false;}\" href=\"", $action, "?table_name=", rawurlencode($table_name), "&amp;function=delete_all&amp;where_clause=", rawurlencode(enc($where_clause_to_pass)), "&amp;page=", $page, "&amp;order=", rawurlencode(enc($order)), "&amp;order_type=", $order_type, "\">", $normal_messages_ar['delete_all'], "</a>";
    }
    if($results_number > $records_per_page) {
      txt_out("<br /><span class=\"page_n_of_m\">" . $normal_messages_ar["page"] . ($page + 1) . $normal_messages_ar["of"] . $pages_number . "</span>");
      // build the navigation tool
      $navigation_tool = build_navigation_tool($where_clause_to_pass, $pages_number, $page, $action, "", $order, $order_type);
      echo "&nbsp;&nbsp;&nbsp;&nbsp;" . $navigation_tool . "<br /><br />";
    }
    $results_type = "search";
    $results_table = build_results_table($fields_labels_ar, $table_name, $res_records, $results_type, "", "", $action, $where_clause_to_pass, $page, $order, $order_type);
    echo $results_table;
    if($export_to_csv_feature == 1) {
      echo "<a href=\"" . $action . "?table_name=" . rawurlencode($table_name) . "&amp;function=" . $function . "&amp;where_clause=" . rawurlencode(enc($where_clause_to_pass)) . "&amp;page=" . $page . "&amp;order=" . rawurlencode(enc($order)) . "&amp;order_type=" . $order_type . "&amp;export_to_csv=1\">";
      txt_out($normal_messages_ar["export_to_csv"], "export_to_csv");
      echo "</a>";
    }
  }
  else {
    txt_out($normal_messages_ar["no_records_found"]);
  }
  break;
  case "details":
  if($enable_details == "1" && ($enable_authentication === 0 || $enable_browse_authorization === 0 || current_user_is_owner($where_field, $where_value, $table_name, $fields_labels_ar))) {
    $sql = build_select_part($fields_labels_ar, $table_name);
    $sql .= " where `" . add_slashes($table_name, 1) . '`.`' . add_slashes($where_field, 1) . "` = " . add_slashes($where_value) . " LIMIT 1";
    txt_out("<h3>" . strtoupper($table_name) . "<br />" . $normal_messages_ar["details_of_record"] . "</h3>");
    $res_details = execute_db($sql, $conn, 'index.php');
    $details_table = build_details_table($fields_labels_ar, $res_details);
    echo $details_table;
  }
  else {
    txt_out($error_messages_ar["no_authorization_view"], "error_messages_form");
  }
  break;
  case "edit":
  if($enable_edit == "1" && ($enable_authentication === 0 || $enable_browse_authorization === 0 || current_user_is_owner($where_field, $where_value, $table_name, $fields_labels_ar))) {
    if(isset($just_updated) && $just_updated == "1") {
      txt_out($normal_messages_ar["record_updated"], "normal_messages_form");
    }
    if(isset($just_updated_no_authorization) && $just_updated_no_authorization == "1") {
      txt_out($error_messages_ar["no_authorization_update_delete"], "error_messages_form");
    }
    $sql = "select * from `" . add_slashes($table_name, 1) . "` where `" . add_slashes($table_name, 1) . '`.`' . add_slashes($where_field, 1) . "` = " . add_slashes($where_value);
    txt_out("<h3>" . strtoupper($table_name) . "<br />" . $normal_messages_ar["edit_record"] . "</h3>");
    if(required_field_present($fields_labels_ar)) {
      txt_out($normal_messages_ar["required_fields_red"]);
    }
    $res_details = execute_db($sql, $conn, 'index.php');
    $form_type = "update";
    $form = build_form($table_name, $action, $fields_labels_ar, $form_type, $res_details, $where_field, $where_value);
    echo $form;
  }
  else {
    txt_out($error_messages_ar["no_authorization_view"]);
  }
  break;
  case "update":
  if($enable_edit == "1") {
    $check = 0;
    $check = check_required_fields($fields_labels_ar);
    if($check == 0) {
      txt_out($normal_messages_ar["required_fields_missed"], "error_messages_form");
      $go_back_button = "<br /><br />" . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_check_form"];
      txt_out($go_back_button, "error_messages_form");
    }
    else {
      $check = 0;
      $check = check_length_fields($fields_labels_ar);
      if($check == 0) {
        txt_out($normal_messages_ar["fields_max_length"], "error_messages_form");
        $go_back_button = "<br /><br />" . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_check_form"];
        txt_out($go_back_button, "error_messages_form");
      }
      else {
        $check = 0;
        $content_error_type = "";
        $check = check_fields_types($fields_labels_ar, $content_error_type);
        if($check == 0) {
          txt_out($normal_messages_ar["{$content_error_type}_not_valid"], "error_messages_form");
          $go_back_button = '<br />' . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_check_form"];
          txt_out($go_back_button, "error_messages_form");
        }
        else {
          $check = 0;
          $check = write_temp_uploaded_files($fields_labels_ar);
          if($check == 0) {
            txt_out($error_messages_ar["upload_error"], "error_messages_form");
            $go_back_button = "<br /><br />" . $normal_messages_ar["please"] . " <a href=\"javascript:history.back(-1)\">" . $submit_buttons_ar["go_back"] . "</a> " . $normal_messages_ar["and_try_again"];
            txt_out($go_back_button, "error_messages_form");
          }
          else {
            $update_type = "internal";
            if($enable_authentication === 0 || $enable_update_authorization === 0 || current_user_is_owner($where_field, $where_value, $table_name, $fields_labels_ar)) {
              update_record($fields_labels_ar, $table_name, $table_internal_name, $where_field, $where_value, $update_type);
              header('Location:' . $site_url . $dadabik_main_file . '?table_name=' . rawurlencode($table_name) . '&function=edit&where_field=' . rawurlencode($where_field) . "&where_value=" . rawurlencode($where_value) . '&just_updated=1');
            }
            else {
              header('Location:' . $site_url . $dadabik_main_file . '?table_name=' . rawurlencode($table_name) . '&function=edit&where_field=' . rawurlencode($where_field) . "&where_value=" . rawurlencode($where_value) . '&just_updated_no_authorization=1');
            }
          }
        }
      }
    }
  }
  break;
  case "delete":
  if($enable_delete == "1") {
    $location_url = $site_url . $dadabik_main_file . '?table_name=' . rawurlencode($table_name) . '&function=search&where_clause=' . rawurlencode(enc($where_clause));
    if(isset($page) && isset($order) && isset($order_type)) {
      $location_url .= '&page=' . $page . '&order=' . rawurlencode(enc($order)) . '&order_type=' . $order_type;
    }
    else {
      $location_url .= '&page=0';
    }
    if($enable_authentication === 0 || $enable_delete_authorization === 0 || current_user_is_owner($where_field, $where_value, $table_name, $fields_labels_ar)) {
      delete_files_with_record($table_name, $where_field, $where_value);
      delete_record($table_name, $where_field, $where_value);
    }
    else {
      $location_url .= '&just_delete_no_authorization=1';
    }
    header('Location: ' . $location_url);
  }
  break;
  case "delete_all":
  if($enable_delete == "1" && $enable_delete_all_feature === 1) {
    $ID_user_field_name = get_ID_user_field_name($fields_labels_ar);
    delete_multiple_records($table_name, $where_clause, $ID_user_field_name);
    $location_url = $site_url . $dadabik_main_file . '?table_name=' . rawurlencode($table_name) . "&function=search&where_clause=&page=0";
    if($enable_browse_authorization === 0 && $ID_user_field_name !== false) {
      $location_url .= '&just_delete_all_authorizated=1';
    }
    header('Location: ' . $location_url);
  }
  break;
  case "show_insert_form":
  if($enable_insert == "1") {
    txt_out("<h3>" . strtoupper($table_name) . "<br />" . $normal_messages_ar["insert_record"] . "</h3>");
    if(required_field_present($fields_labels_ar)) {
      txt_out($normal_messages_ar["required_fields_red"]);
    }
    $form_type = "insert";
    $res_details = "";
    $form = build_form($table_name, $action, $fields_labels_ar, $form_type, $res_details, "", "");
    echo $form;
  }
  break;
  case "show_search_form":
  txt_out($normal_messages_ar["search_records"]);
  $form_type = "search";
  $res_details = "";
  $form = build_form($table_name, $action, $fields_labels_ar, $form_type, $res_details, "", "");
  echo $form;
  break;
  case "copy":
  if($enable_insert == "1" && ($enable_authentication === 0 || $enable_browse_authorization === 0 || current_user_is_owner($where_field, $where_value, $table_name, $fields_labels_ar))) {
    $sql = "select * from `" . add_slashes($table_name, 1) . "` where `" . add_slashes($table_name, 1) . '`.`' . add_slashes($where_field, 1) . "` = " . add_slashes($where_value);
    txt_out("<h3>" . strtoupper($table_name) . "<br />" . $normal_messages_ar["insert_record_copy"] . "</h3>");
    if(required_field_present($fields_labels_ar)) {
      txt_out($normal_messages_ar["required_fields_red"]);
    }
    $res_details = execute_db($sql, $conn, 'index.php');
    $form_type = "copy";
    $form = build_form($table_name, $action, $fields_labels_ar, $form_type, $res_details, $where_field, $where_value);
    echo $form;
  }
  else {
    txt_out($error_messages_ar["no_authorization_copy"]);
  }
  break;
}

include(realpath(dirname(__FILE__) . '/footer.php'));
