<?php

/*
LabStoRe
Version: 1.6.3
Date: 6 September 2014
Copyright: Santosh Patnaik, MD, PhD
License: GPL 3+
URL: www.bioinformatics.org/phplabware
*/

// Module-specific
$table = 'cell-lines'; // Mysql table name
$head_extra = ''; // extra to include in HTML before </head>; style, javascript
$heading_color = '#82CAFA'; // table column heading and page number list row
$row_color_1 = '#bdedff'; // alternating row colors
$row_color_2 = '#ffffff'; // alternating row colors
$extra_bottom = ''; // extra, will appear at bottom; message
$column_nos = '6'; // number of columns - for colspan table rows (page number row, etc.)

include(realpath(dirname(__FILE__) . '/../header.php'));
echo '<p><span style="color:#dcdcdc;">', $header_to_show, ' || <a href="../help/help.htm" onclick="return popitup(\'../help/help.htm\')">Help</a> || <a>', $date, '</a></span></p></div><div style="padding-left: 5px;">';

// Array of options and values for use with search and sort forms below; format is 'MySQL table field name' => 'Text that appears on webpage'
$option_value = array('name'=>'Name', 'nature'=>'Nature', 'owner'=>'Owner', 'type'=>'Type', 'description'=>'Description', 'generation'=>'Generation', 'sev_loc'=>'-70 stock location', 'hun_loc'=>'-135 stock location', 'modified_on'=>'Update date', 'added_on'=>'Add date', 'modified_by'=>'Updater', 'added_by'=>'Adder');

// Build upper table
echo '<table width="750" summary="top" cellpadding="5" cellspacing="1" style="background-color:#dcdcdc; border:0;  background-image:url(\'../images/cell-lines_small.gif\');  background-position: top right;background-repeat: no-repeat;"><tr><td>';

include(realpath(dirname(__FILE__) . '/../top_part.php'));

if($num_sat !== 0) {
  // Column headings
  echo '<colgroup><col valign="top" align="left" /><col valign="top" align="left" /><col width="40" valign="top" align="left" /><col valign="top" align="left" /><col valign="top" align="left" /><col valign="top" align="left" /></colgroup><tr style="background-color:', $heading_color, ';" valign="top"><td></td><td>Name</td><td >Type</td><td>Owner</td><td>Stocks</td><td></td></tr>';

  for($i = 0; $i < $numofrows; $i++) {
    $row = database_fetch_array($result);
    if($i % 2) {
      echo "<tr style=\"background-color:", $row_color_1, ";\" valign=\"top\">";
    }
    else {
      echo "<tr style=\"background-color:", $row_color_2, ";\" valign=\"top\">";
    }
    
    // Serial number of item (not record ID)
    $sn = (($page - 1) * $max_results) + $i + 1;
    
    // Start - build table rows
    echo '<td>', $sn, '</td><td>', htmlspecialchars($row["name"]);
    if($row["source"] != '') {
      echo '<br />From - ', htmlspecialchars($row["source"]);
    }
    echo'</td><td>', htmlspecialchars($row["nature"]);
    if($row["type"] != '') 
      echo '<br />', htmlspecialchars($row["type"]);
    echo '</td><td>', htmlspecialchars($row["owner"]), '</td><td>';
    if($row["sev_loc"] != '') 
      echo '-70&deg; - ', htmlspecialchars($row["sev_loc"]);
    if($row["hun_loc"] != '') 
      echo '<br />-135&deg; - ', htmlspecialchars($row["hun_loc"]);
    if($row["nit_loc"] != '') 
      echo '<br />N<sub>2</sub> - ', htmlspecialchars($row["nit_loc"]);
    //---------------------------------------------------
    echo('</td><td><span style="color:#736F6E;">');
    if($row["added_on"] != '' and $row["added_on"] != '0000-00-00') {
      echo 'Added ', htmlspecialchars($row["added_on"]), '<br />';
    }
    if($row["modified_on"] != '' and $row["modified_on"] != '0000-00-00') {
      echo 'Updated ', htmlspecialchars($row["modified_on"]), '<br />';
    }

    // Detail link
    echo '<a href="../interface_creator/index_short.php?table_name=cell-lines&amp;function=details&amp;where_field=id&amp;where_value=', rawurlencode($row["id"]), '" onclick="return popitup(\'../interface_creator/index_short.php?table_name=cell-lines&amp;function=details&amp;where_field=id&amp;where_value=', rawurlencode($row["id"]), '\')">Details</a>';
    
    // Edit, copy and delete links
    if(!($all_affect_items == "no" and $client == "not_allowed")) {
      echo ' | <a href="../interface_creator/index_short.php?table_name=cell-lines&amp;function=edit&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '" onclick="return popitup(\'../interface_creator/index_short.php?table_name=cell-lines&amp;function=edit&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '\')"> Edit</a> | <a href="../interface_creator/index_short.php?table_name=cell-lines&amp;function=delete&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '" onclick="return confipop(\'../interface_creator/index_short.php?table_name=cell-lines&amp;function=delete&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '\')"> Delete</a> | <a href="../interface_creator/index_short.php?table_name=cell-lines&amp;function=copy&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '" onclick="return popitup(\'../interface_creator/index_short.php?table_name=cell-lines&amp;function=copy&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '\')"> Copy</a>';
    }

    echo('</span></td></tr>');
  }
  include(realpath(dirname(__FILE__) . '/../bottom_part.php'));
}

include(realpath(dirname(__FILE__) . '/../footer.php'));
