<?php

/*
LabStoRe
Version: 1.6.3
Date: 6 September 2014
Copyright: Santosh Patnaik, MD, PhD
License: GPL 3+
URL: www.bioinformatics.org/phplabware
*/

// Module-specific
$table = 'plasmids'; // Mysql table name
$head_extra = ''; // extra to include in HTML before </head>; style, javascript
$heading_color = '#82CAFA'; // table column heading and page number list row
$row_color_1 = '#bdedff'; // alternating row colors
$row_color_2 = '#ffffff'; // alternating row colors
$extra_bottom = ''; // extra, will appear at bottom; message
$column_nos = '6'; // number of columns - for colspan table rows (page number row, etc.)

include(realpath(dirname(__FILE__) . '/../header.php'));
echo '<p><span style="color:#dcdcdc;">', $header_to_show, ' || <a href="../help/help.htm" onclick="return popitup(\'../help/help.htm\')">Help</a> || <a>', $date, '</a></span></p></div><div style="padding-left: 5px;">';

// Array of options and values for use with search and sort forms below; format is 'MySQL table field name' => 'Text that appears on webpage'
$option_value = array('name'=>'Name', 'description'=>'Description', 'owner'=>'Owner/creator', 'source'=>'Source', 'generation'=>'Generation technique', 'tag'=>'Tag encoded', 'mam_prom'=>'Mammalian promoter', 'other_prom'=>'Other promoters', 'bact_sel'=>'Bac. selection marker', 'other_sel'=>'Other selection marker', 'feature'=>'Other features', 'experiment'=>'Experiment info.', 'comment'=>'Comments', 'modified_on'=>'Update date', 'added_on'=>'Add date', 'modified_by'=>'Updater', 'added_by'=>'Adder');

// Build upper table
echo '<table width="750" summary="top" cellpadding="5" cellspacing="1" style="background-color:#dcdcdc; border:0;  background-image:url(\'../images/plasmids_small.gif\'); background-position: top right;background-repeat: no-repeat;"><tr><td>';
include(realpath(dirname(__FILE__) . '/../top_part.php'));

if($num_sat !== 0) {
  // Column headings
  echo '<colgroup><col width="40" valign="top" align="left" /><col valign="top" align="left" /><col valign="top" align="left" /><col valign="top" align="left" /><col valign="top" align="left" /><col valign="top" width="170" align="left" /></colgroup><tr style="background-color:', $heading_color, ';" valign="top"><td></td><td >Name/description</td><td>Vector/insert</td><td >Owner/creator</td><td>Download</td><td></td></tr>';

  for($i = 0;$i < $numofrows;$i++) {
    $row = database_fetch_array($result);
    if($i % 2) {
      echo "<tr style=\"background-color:", $row_color_1, ";\" valign=\"top\">";
    }
    else {
      echo "<tr style=\"background-color:", $row_color_2, ";\" valign=\"top\">";
    }
    
    // Serial number of item (not record ID)
    $sn = (($page - 1) * $max_results) + $i + 1;
    
    echo '<td>', $sn, '</td><td>', htmlspecialchars($row["name"]);
    if($row["description"] != '') {
      echo '<br />', htmlspecialchars($row["description"]);
    }
    echo '</td><td>', htmlspecialchars($row["vector"]);
    if($row["insert"] != '') {
      echo '<br />', htmlspecialchars($row["insert"]);
    }
    echo '</td><td>', htmlspecialchars($row["owner"]);
    echo '</td><td>';
    
    // Provide links to download files
    if($row["map_file"] != '') {
      // Table data is of form - 'The filepath is - table-name/file-name' for plasmids, so, filename is table data minus first 27 characters 'The filepath is - '=[18]'plasmids'=[+8]'/'=[+1]
      $file = substr($row["map_file"], 27);
      if(file_exists('../interface_creator/uploads/plasmids/' . $file)) {
        echo 'Map file - <a href="../interface_creator/uploads/plasmids/', htmlspecialchars($file), '">', htmlspecialchars($file), '</a><br />';
      }
      else {
        echo htmlspecialchars($file), ' - this is the entry for the map file in the table, but the files does not exist!<br />';
      }
    }
    if($row["insert_seq_file"] != '') {
      $file2 = substr($row["insert_seq_file"], 27);
      if(file_exists('../interface_creator/uploads/plasmids/' . $file2)) {
        echo 'Insert seq. file - <a href="../interface_creator/uploads/plasmids/', htmlspecialchars($file2), '">', htmlspecialchars($file2), '</a><br />';
      }
      else {
        echo htmlspecialchars($file2), ' - this is the entry for the insert seq. file in the table, but the files does not exist!<br />';
      }
    }
    if($row["extra_file"] != '') {
      $file3 = substr($row["extra_file"], 27);
      if(file_exists('../interface_creator/uploads/plasmids/' . $file3)) {
        echo 'Extra file - <a href="../interface_creator/uploads/plasmids/', htmlspecialchars($file3), '">', htmlspecialchars($file3), '</a>';
      }
      else {
        echo htmlspecialchars($file3), ' - this is the entry for the extra file in the table, but the file does not exist!';
      }
    }
    else {
      echo 'No file provided';
    }

    echo '</td><td><span style="color:#736F6E;">';
    if($row["added_on"] != '' and $row["added_on"] != '0000-00-00') {
      echo 'Added ', htmlspecialchars($row["added_on"]), '<br />';
    }
    if($row["modified_on"] != '' and $row["modified_on"] != '0000-00-00') {
      echo 'Updated ', htmlspecialchars($row["modified_on"]), '<br />';
    }

    // Detail link
    echo '<a href="../interface_creator/index_short.php?table_name=plasmids&amp;function=details&amp;where_field=id&amp;where_value=', rawurlencode($row["id"]), '" onClick="return popitup(\'../interface_creator/index_short.php?table_name=plasmids&amp;function=details&amp;where_field=id&amp;where_value=', rawurlencode($row["id"]), '\')">Details</a>';
    
    // Edit, copy and delete links
    if(!($all_affect_items == "no" and $client == "not_allowed")) {
      echo ' | <a href="../interface_creator/index_short.php?table_name=plasmids&amp;function=edit&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '" onClick="return popitup(\'../interface_creator/index_short.php?table_name=plasmids&amp;function=edit&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '\')"> Edit</a> | <a href="../interface_creator/index_short.php?table_name=plasmids&amp;function=delete&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '" onClick="return confipop(\'../interface_creator/index_short.php?table_name=plasmids&amp;function=delete&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '\')"> Delete</a> | <a href="../interface_creator/index_short.php?table_name=plasmids&amp;function=copy&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '" onclick="return popitup(\'../interface_creator/index_short.php?table_name=plasmids&amp;function=copy&amp;where_field=id&amp;where_value=' . rawurlencode($row["id"]), '\')"> Copy</a>';
    }
    echo '</span></td></tr>';
  }
  include(realpath(dirname(__FILE__) . '/../bottom_part.php'));
}

include(realpath(dirname(__FILE__) . '/../footer.php'));
