<?php

/*
LabStoRe
Version: 1.6.3
Date: 6 September 2014
Copyright: Santosh Patnaik, MD, PhD
License: GPL 3+
URL: www.bioinformatics.org/phplabware
*/

// Leave if wrong IP
if($all_see_tables == "no" and $client == "not_allowed") {
  echo('<span style="color:red;">Sorry, this IP address is not allowed access to this page. You may want to see the <a href="../help/help.htm">help</a> section to know more about this website, to download the software, etc.</span></p></td></tr></table><div>');
  include(realpath(dirname(__FILE__) . '/footer.php'));
  exit();
}

// Start -------------- where conditions for mysql query; sterm is term, smenu is menu option, sbool is for and/or

foreach(array('sterm_1', 'sterm_2', 'sbool', 'smenu_1', 'smenu_2', 'sort_1', 'sort_2', 'order_1', 'order_2') as $x) {
  $y = '';
  if(isset($_GET[$x])) {
    $y = $_GET[$x];
  }
  if(isset($_POST[$x])) {
    $y = $_POST[$x];
  }
  $myget[$x] = $y;
  if(!isset($myget['sbool']) or strtolower($myget['sbool']) != 'and') {
    $sbool = "OR";
  }
  else {
    $sbool = 'AND';
  }
  if(!isset($myget['order_1']) or strtolower($myget['order_1']) != 'desc') {
    $myget['order_1'] = "ASC";
  }
  else {
    $myget['order_1'] = 'DESC';
  }
  if(!isset($myget['order_2']) or strtolower($myget['order_2']) != 'desc') {
    $myget['order_2'] = "ASC";
  }
  else {
    $myget['order_2'] = 'DESC';
  }
}
$where_condition = "";
if(isset($myget['sterm_1']) and $myget['sterm_1'] != '') {
  if(isset($myget['sterm_2']) and $myget['sterm_2'] != '') {
    $where_condition = " WHERE `" . add_slashes($myget['smenu_1'], 1) . "` LIKE '%" . add_slashes($myget['sterm_1'], 2) . "%' " . $sbool . " `" . add_slashes($myget['smenu_2'], 1) . "` LIKE '%" . add_slashes($myget['sterm_2'], 2) . "%'";
  }
  else {
    $where_condition = " WHERE `" . add_slashes($myget['smenu_1'], 1) . "` LIKE '%" . add_slashes($myget['sterm_1'], 2) . "%'";
  }
}
else {
  if(isset($myget['sterm_2']) and $myget['sterm_2'] != '') {
    $where_condition = " WHERE `" . add_slashes($myget['smenu_2'], 1) . "` LIKE '%" . add_slashes($myget['sterm_2'], 2) . "%'";
  }
}
// End ------------- get where conditions for query

// Start ----------- sort conditions for mysql query
$order_condition = "`name` ASC";
if($table == $users_table_name) {
  $order_condition = "`" . $users_table_username_field . "` ASC";
}
if($table == 'order') {
  $order_condition = "`ordered_date` DESC";
}
if(isset($myget['sort_1']) and $myget['sort_1'] != '') {
  if(isset($myget['order_1'])) {
    $order_condition = "`" . add_slashes($myget['sort_1'], 1) . "` " . $myget['order_1'];
  }
  else {
    $order_condition = "`" . add_slashes($myget['sort_1'], 1) . "` ASC";
  }
  // if the optional second sort option was chosen - conditional on 1st being chosen

  if(isset($myget['sort_2']) and $myget['sort_2'] != '' and $myget['sort_2'] !== $myget['sort_1']) {
    if(isset($myget['order_2'])) {
      $order_condition .= ", `" . add_slashes($myget['sort_2'], 1) . "` " . $myget['order_2'];
    }
    else {
      $order_condition .= ", `" . add_slashes($myget['sort_2'], 1) . "` ASC";
    }
  }
}
// End ------------- get sort conditions for query

// Page numbering setup
if(!isset($_GET['page'])) {
  $page = 1;
}
else {
  $page = intval($_GET['page']);
}
$from = (($page * $max_results) - $max_results);
// Get total entries
$num_tot = database_num_rows(execute_db("SELECT * FROM `" . add_slashes($table, 1) . "`", $conn, 'labstore/top_part.php'));
// Get number of entries satisfying WHERE conditions
$num_sat = database_num_rows(execute_db("SELECT * FROM `" . add_slashes($table, 1) . "`" . $where_condition, $conn, 'labstore/top_part.php'));
if($num_tot !== $num_sat) {
  $total_pages = ceil($num_sat / $max_results);
}
else {
  $total_pages = ceil($num_tot / $max_results);
}

// Build search form

// Get values to prefill
echo('<tr><td valign="top">');
if($num_tot > 0) {
  // Get the option - smenu - and term - sterm - from each sort
  $sterm_1 = isset($_GET['sterm_1']) ? $_GET['sterm_1'] : (isset($_POST['sterm_1']) ? $_POST['sterm_1'] : '');
  $sterm_2 = isset($_GET['sterm_2']) ? $_GET['sterm_2'] : (isset($_POST['sterm_2']) ? $_POST['sterm_2'] : '');
  $smenu_1 = isset($_GET['smenu_1']) ? $_GET['smenu_1'] : (isset($_POST['smenu_1']) ? $_POST['smenu_1'] : '');
  $smenu_2 = isset($_GET['smenu_2']) ? $_GET['smenu_2'] : (isset($_POST['smenu_2']) ? $_POST['smenu_2'] : '');
  $sbool = isset($_GET['sbool']) ? ($_GET['sbool'] == 'AND' ? 'AND' : 'OR') : (isset($_POST['sbool']) ? ($_POST['sbool'] == 'AND' ? 'AND' : 'OR') : 'AND');
  $order_1 = isset($_GET['order_1']) ? ($_GET['order_1'] == 'ASC' ? 'ASC' : 'DESC') : (isset($_POST['order_1']) ? ($_POST['order_1'] == 'ASC' ? 'ASC' : 'DESC') : 'ASC');
  $order_2 = isset($_GET['order_2']) ? ($_GET['order_2'] == 'ASC' ? 'ASC' : 'DESC') : (isset($_POST['order_2']) ? ($_POST['order_2'] == 'ASC' ? 'ASC' : 'DESC') : 'ASC');
  $sort_1 = isset($_GET['sort_1']) ? $_GET['sort_1'] : (isset($_POST['sort_1']) ? $_POST['sort_1'] : '');
  $sort_2 = isset($_GET['sort_2']) ? $_GET['sort_2'] : (isset($_POST['sort_2']) ? $_POST['sort_2'] : '');
  // End - get values to prefill

  // Add extra item to option-value array
  $option_value3 = $option_value;
  $option_value3['name'] = "Has in name or...";
  echo '<form action="', htmlspecialchars($_SERVER['PHP_SELF']), '" method="get"><p>';
  
  //--------------------------------------------------

  echo('<select single="single" id="smenu_1" name="smenu_1">');
  foreach($option_value3 as $value=>$option) {
    echo '<option value="', htmlspecialchars($value);
    if($value == $smenu_1) {
      echo('" selected="selected"');
    }
    else {
      echo('"');
    }
    echo '>', htmlspecialchars($option), '</option>';
  }
  echo('</select>');
  echo '<input name="sterm_1" id="sterm_1" type="text" size="15" maxlength="30" value="', htmlspecialchars($sterm_1), '" />';
  
  //--------------------------------------------------

  echo('<select single="single" name="sbool" id="sbool">');
  echo('<option value="AND"');
  if($sbool == "AND") {
    echo(' selected="selected"');
  }
  echo('>And</option>');
  echo('<option value="OR"');
  if($sbool == "OR") {
    echo(' selected="selected"');
  }
  echo('>Or</option>');
  echo('</select>');
  
  //--------------------------------------------------

  echo('<select single="single" name="smenu_2" id="smenu_2">');
  foreach($option_value3 as $value=>$option) {
    echo('<option value="' . htmlspecialchars($value));
    if($value == $smenu_2) {
      echo('" selected="selected"');
    }
    else {
      echo('"');
    }
    echo('>' . htmlspecialchars($option) . '</option>');
  }
  echo('</select>');
  
  //--------------------------------------------------

  echo '<input name="sterm_2" id="sterm_2" type="text" size="15" maxlength="30" value="', rawurlencode($sterm_2), '" />';
  echo '<input type="hidden" name="order_1" value="', htmlspecialchars($order_1), '" /><input type="hidden" name="order_2" value="', htmlspecialchars($order_2), '" /><input type="hidden" name="sort_1" value="', htmlspecialchars($sort_1), '" /><input type="hidden" name="sort_2" value="', htmlspecialchars($sort_2), '" /><input type="submit" value="Find" name="submit_find" id="submit_find" /><a href="../help/help.htm#search" onclick="return popitup(\'../help/help.htm#search\')">?</a></p></form>';
}
// End - build search form

// Build menu form for resorting; the option values are table column headings

// Only if more than one page of data
if($total_pages > 1) {
  // Add extra item to option-value array
  $option_value2 = $option_value;
  $option_value2[''] = "Sort by";
  // Form HTML code
  echo '<form action="', htmlspecialchars($_SERVER['PHP_SELF']), '" method="get"><p>';
 
  //--------------------------------------------------

  echo('<select single="single" name="sort_1" id="sort_1">');
  foreach($option_value2 as $value=>$option) {
    echo '<option value="', htmlspecialchars($value);
    if($value == $sort_1) {
      echo('" selected="selected"');
    }
    else {
      echo('"');
    }
    echo '>', htmlspecialchars($option), '</option>';
  }
  echo('</select>');
  
  //--------------------------------------------------

  echo('<select single="single" id="order_1" name="order_1">');
  echo('<option value="ASC"');
  if($order_1 == "ASC") {
    echo(' selected="selected"');
  }
  echo('>Ascending</option>');
  echo('<option value="DESC"');
  if($order_1 == "DESC") {
    echo(' selected="selected"');
  }
  echo('>Descending</option>');
  echo('</select> then (optional) ');
  
  //--------------------------------------------------

  echo('<select single="single" id="sort_2" name="sort_2">');
  foreach($option_value2 as $value=>$option) {
    echo '<option value="', htmlspecialchars($value);
    if($value == $sort_2) {
      echo('" selected="selected"');
    }
    else {
      echo('"');
    }
    echo '>', htmlspecialchars($option), '</option>' ;
  }
  echo('</select>');
  
  //--------------------------------------------------

  echo('<select single="single" id="order_2" name="order_2">');
  echo('<option value="ASC"');
  if($order_2 == "ASC") {
    echo(' selected="selected"');
  }
  echo('>Ascending</option>');
  echo('<option value="DESC"');
  if($order_2 == "DESC") {
    echo(' selected="selected"');
  }
  echo('>Descending</option>');
  echo('</select>');
  
  //--------------------------------------------------

  echo '<input type="hidden" name="sterm_1" value="', htmlspecialchars($sterm_1), '" /><input type="hidden" name="sterm_2" value="' . htmlspecialchars($sterm_2), '" /><input type="hidden" name="smenu_1" value="', htmlspecialchars($smenu_1), '" /><input type="hidden" name="smenu_2" value="', htmlspecialchars($smenu_2), '" /><input type="hidden" name="sbool" value="', htmlspecialchars($sbool), '" /><input type="submit" name="submit_sort" id="submit_sort" value="Sort" /><a href="../help/help.htm#sort" onclick="return popitup(\'../help/help.htm#sort\')">?</a></p></form>';
}
// End - build sort form

if($num_sat !== 0) {
  if($num_tot !== $num_sat) {
    echo '<p>Showing ', $num_sat, ' from a <a href="', htmlspecialchars($_SERVER['PHP_SELF']), '">total</a> of ', $num_tot, ' entries';
  }
  else {
    echo "<p>Showing all ", $num_sat, " of ", $num_tot, " entries";
  }
  
  // Depending on total number of pages
  if($total_pages > 1) {
    echo " on ", $total_pages, " pages, sorted as indicated</p>";
  }
  else {
    echo(" on one page </p>");
  }
}
else {
  if($num_tot !== 0) {
    echo '<p>None of the <a href="', htmlspecialchars($_SERVER['PHP_SELF']), '">total</a> ', $num_tot, ' entries match your search criteria. Note that the default search is against name/description and an entry will be returned only if your query is a part of its name/description (e.g., "zp" is a part of "ZP 1" but "ZP1" is not). Try changing the search phrase, e.g., "rabbits" to "rabbit" and "2 at 4 deg" to "2 at 4-deg." Searches are not case sensitive, but wild cards are not allowed.</p>';
  }
  else {
    echo('<p>The table is empty! <br /></p>');
  }
}
// End upper table
echo('</td></tr></table>');

// Generate the query for MySQL only if num_sat is more than zero
if($num_sat !== 0) {
  $query = "SELECT * FROM `" . add_slashes($table, 1) . "`";
  if($where_condition != '') {
    $query .= $where_condition;
  } 
  // Expand the query to include ORDER conditions
  $query .= " ORDER BY " . $order_condition;
  // Get page-number dictated entries satisfying WHERE and ORDER conditions
  $query .= " LIMIT " . intval($from) . ", " . intval($max_results);
  $result = execute_db($query, $conn, 'labstore/top_part.php');
  $numofrows = database_num_rows($result);
  // Table start
  echo('<table summary="list" width="750" style="background-color:#efefef; border:0;" cellpadding="5" cellspacing="1">');
}
