<?php

/*
Interface Creator
www.bioinformatics.org/phplabware
6 September 2014 release
By Santosh Patnaik, MD, PhD
GPL license
Based on DaDaBik version 3.2 by Eugenio Tacchini - http://www.dadabik.org
*/

ob_start();
session_start();

if(get_magic_quotes_gpc()) {
  // recursively apply stripslashes() to all data
  $_GET = strip_slashes($_GET);
  $_POST = strip_slashes($_POST);
  $_COOKIE = strip_slashes($_COOKIE);
  $_REQUEST = strip_slashes($_REQUEST);
  ini_set('magic_quotes_gpc', 0);
}
if(get_magic_quotes_runtime()) {
  set_magic_quotes_runtime(0);
}

if($host != "" && $user != "" && $db_name != "" && $site_url != "") {
  $conn = connect_db($host, $user, $pass);
  choose_db($db_name, $conn);
}
else {
  echo "<p><b>[01] Error:</b> either host, username or password settings for the MySQL database server connection, or the MySQL database name and site URL are not specified or incorrect. Please check parameters and ensure correct syntax in the config.php file. Also, check that MySQL server is functioning and that you can connect to it with the host, username or password settings. Ensure that the database you want to use exists on the MySQL server.</p>";
  exit;
}

// tables present in the databse
$table_names_ar = build_tables_names_array(0, 0);
if(count($table_names_ar) == 0) {
  // no table
  echo "<p><b>[02] Error:</b> your database - " . htmlspecialchars($db_name) . " - is empty. No tables were found. Please create some tables in the MySQL database before using this interface creator. They need not contain any data but the structure - how many columns (fields) and their types should be there. For help to create tables in MySQL, please check elsewhere. You may want to use the free phpmyadmin web application to do so - http://www.phpmyadmin.net.</p>";
  exit;
}

// these are set in check_login.php but that file is not always included, and this file may not be included by software using Interface Creator as backend
$current_user = 'anonymous';
$current_user_is_administrator = 0;
