<?php

/*
Interface Creator
www.bioinformatics.org/phplabware
6 September 2014 release
By Santosh Patnaik, MD, PhD
GPL license
Based on DaDaBik version 3.2 by Eugenio Tacchini - http://www.dadabik.org
*/

// include business logic, db_functions and general_functions

// magic quotes issues
function add_slashes($value, $param = 0) {
  if(is_array($value)) {
    foreach($value as $index=>$val) {
      $value[$index] = add_slashes($val);
    }
    return $value;
  }
  else {
    $value = str_replace(array("\\", "\0", "\n", "\r", "\x1a", "'", '"'), array("\\\\", "\\0", "\\n", "\\r", "\Z", "\'", '\"'), $value);
    if(empty($param)) {
      return "'" . $value . "'";
    }
    elseif($param == 2) {
      return $value;
    }
    else {
      return str_replace('`', '\`', $value);
    }
  }
}

function strip_slashes($value) {
  if(is_array($value)) {
    foreach($value as $index=>$val) {
      $value[$index] = strip_slashes($val);
    }
    return $value;
  }
  else {
    return stripslashes($value);
  }
}

// for function stripos - undefined in PHP versions before 5
if(!function_exists('stripos')) {
  function stripos($haystack, $needle, $offset = 0) {
    return(strpos(strtolower($haystack), strtolower($needle), $offset));
  }
}

// fix for lack of strripos function in PHP older than version 5
if(!function_exists('strripos')) {
  function strripos($haystack, $needle, $offset = null) {
    if(!is_scalar($haystack)) {
      user_error('strripos() expects parameter 1 to be scalar, ' . gettype($haystack) . ' given', E_USER_WARNING);
      return false;
    }
    if(!is_scalar($needle)) {
      user_error('strripos() expects parameter 2 to be scalar, ' . gettype($needle) . ' given', E_USER_WARNING);
      return false;
    }
    if(!is_int($offset) && !is_bool($offset) && !is_null($offset)) {
      user_error('strripos() expects parameter 3 to be long, ' . gettype($offset) . ' given', E_USER_WARNING);
      return false;
    }
    // manipulate the string if there is an offset
    $fix = 0;
    if(!is_null($offset)) {
      // If the offset is larger than the haystack, return
      if(abs($offset) >= strlen($haystack)) {
        return false;
      }
      // check whether offset is negative or positive
      if($offset > 0) {
        $haystack = substr($haystack, $offset, strlen($haystack) - $offset);
        // we need to add this to the position of the needle
        $fix = $offset;
      }
      else {
        $haystack = substr($haystack, 0, strlen($haystack) + $offset);
      }
    }
    $segments = explode(strtolower($needle), strtolower($haystack));
    $last_seg = count($segments) - 1;
    $position = strlen($haystack) + $fix - strlen($segments[$last_seg]) - strlen($needle);
    return $position;
  }
}

include_once(realpath(dirname(__FILE__) . '/business_logic.php'));

function format_date($date) {
  global $date_format, $date_separator;
  $temp_ar = explode("-", $date);
  $temp_ar[2] = substr($temp_ar[2], 0, 2);
  switch($date_format) {
    case "literal_english":
    $date = gmdate("j M Y", mktime(0, 0, 0, $temp_ar[1], $temp_ar[2], $temp_ar[0]));
    break;
    case "latin":
    $date = $temp_ar[2] . $date_separator . $temp_ar[1] . $date_separator . $temp_ar[0];
    break;
    case "numeric_english":
    $date = $temp_ar[1] . $date_separator . $temp_ar[2] . $date_separator . $temp_ar[0];
    break;
  }
  return $date;
}

// goal: split a mysql date returning $day, $mont, $year
// input: $date, a MySQL date, &$day, &$month, &$year
// output: &$day, &$month, &$year
function split_date($date, &$day, &$month, &$year) {
  $temp = explode("-", $date);
  $day = $temp[2];
  $month = $temp[1];
  $year = $temp[0];
}

// goal: build a select with operators: nothing = > <
// input: $field_name
// output: $operator_select
function build_date_select_type_select($field_name) {
  $operator_select = "";
  $operator_select .= "<select name=\"" . htmlspecialchars($field_name) . "\" id=\"" . htmlspecialchars($field_name) . "\">";
  $operator_select .= "<option value=\"\"></option>";
  $operator_select .= "<option value=\"=\">=</option>";
  $operator_select .= "<option value=\"&gt;\">&gt;</option>";
  $operator_select .= "<option value=\"&lt;\">&lt;</option>";
  $operator_select .= "</select>";
  return $operator_select;
}

function txt_out($message, $class = "") {
	$message = trim($message). ' ';
  if($class != "") {
    echo "<span class=\"", $class, "\">", $message, "</span>";
  }
  else {
    echo $message;
  }
}

// goal: calculate the total number of pages necessary to display results
function get_pages_number($results_number, $records_per_page) {
  $pages_number = $results_number / $records_per_page;
  $pages_number = (int)($pages_number);
  if(($results_number % $records_per_page) != 0) {
    $pages_number++;
  }
  return $pages_number;
}

// goal: build three select to select a data (day, mont, year), if are set $day, $month and $year select them
// input: $field_name, the name of the date field, $day, $month, $year (or "", "", "" if not set)
function build_date_select($field_name, $day, $month, $year) {
  global $start_year, $end_year;
  $date_select = "";
  $day_select = "";
  $month_select = "";
  $year_select = "";
  $day_select .= "<select name=\"" . htmlspecialchars($field_name) . "_day\" id=\"" . htmlspecialchars($field_name) . "_day\">";
  $month_select .= "<select name=\"" . htmlspecialchars($field_name) . "_month\" id=\"" . htmlspecialchars($field_name) . "_month\">";
  $year_select .= "<select name=\"" . htmlspecialchars($field_name) . "_year\" id=\"" . htmlspecialchars($field_name) . "_year\">";
  for($i = 1; $i <= 31; $i++) {
    $day_select .= "<option value=\"" . sprintf("%02d", $i) . "\"";
    if($day != "" and $day == $i) {
      $day_select .= " selected=\"selected\"";
    }
    $day_select .= ">" . sprintf("%02d", $i) . "</option>";
  }
  for($i = 1; $i <= 12; $i++) {
    $month_select .= "<option value=\"" . sprintf("%02d", $i) . "\"";
    if($month != "" and $month == $i) {
      $month_select .= " selected=\"selected\"";
    }
    $month_select .= ">" . sprintf("%02d", $i) . "</option>";
  }
  for($i = $start_year; $i <= $end_year; $i++) {
    $year_select .= "<option value=\"$i\"";
    if($year != "" and $year == $i) {
      $year_select .= " selected=\"selected\"";
    }
    $year_select .= ">" . $i . "</option>";
  }
  $day_select .= "</select>";
  $month_select .= "</select>";
  $year_select .= "</select>";
  $date_select = "<td valign=\"top\">" . $day_select . "</td><td valign=\"top\">" . $month_select . "</td><td valign=\"top\">" . $year_select . "</td>";
  return $date_select;
}

// goal: verify if a string contains numbers
function contains_numerics($string) {
  if(preg_match("`[0-9]+`", $string)) {
    return true;
  }
  return false;
}

// goal: check if an email address is valid, according to its syntax
function is_valid_email($email) {
  return(preg_match('/^[-!#$%&\'*+\\.\/0-9=?A-Z^_`{|}~]+' . // the user name
  '@' . // the ubiquitous at-sign
  '([-0-9A-Z]+\.)+' . // host, sub-, and domain names
  '([0-9A-Z]){2,4}$/i', // top-level domain (TLD)
  trim($email)));
}

// goal: check if an url address is valid, according to its syntax, supports 4 letters domaains (e.g. .info), http https ftp protcols and also port numbers
function is_valid_url($url) {
  return preg_match("`^((ht|f)tps*://)((([a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4}))|(([0-9]{1,3}\.){3}([0-9]{1,3})))(:[0-9]{1,4})*((/|\?)[a-z0-9~#%&'_\+=:\?\.-]*)*)$`i", $url);
}

// goal: check if a phone number is valid, according to its syntax (should be: "+390523599314")
function is_valid_phone($phone) {
  if($phone[0] != "+") {
    return false;
  }
  else {
    $phone = substr($phone, 1);
    // delete the "+"
    if(!is_numeric($phone)) {
      return false;
    }
  }
  return true;
}

// goal: get the name of the first unique field in a table
function get_unique_field($table_name) {
  global $conn, $db_name;
  $unique_field_name = "";
  $fields = database_list_fields($db_name, $table_name, $conn);
  $columns = count($fields);
  for($i = 0; $i < $columns; $i++) {
    if($fields[$i][3] == 'PRI') {
      $unique_field_name = $fields[$i][0];
      break;
    }
  }
  return $unique_field_name;
}

// db functions

function connect_db($server, $user, $password) {
  global $debug_mode;
  if($debug_mode == 1) {
    $conn = database_connect($server, $user, $password) or die('<p><b>[06] Error:</b> during MySQL database connection.<br />MySQL server said: ' . htmlspecialchars(database_error($conn)) . '</p>');
  }
  else {
    $conn = database_connect($server, $user, $password) or die('<p><b>[06] Error:</b> during MySQL database connection. Most likely the settings in config.php file are incorrect, or the MySQL server is down. For PHP/MySQL debugging, turn on the debug_mode option in the config.php file.</p>');
  }
  return $conn;
}

function choose_db($dbase, $conn) {
  global $debug_mode;
  if($debug_mode == 1) {
    database_select_db($dbase, $conn) or die('<p><b>[07] Error:</b> during MySQL database selection.<br />MySQL server said: ' . htmlspecialchars(database_error($conn)) . '</p>');
  }
  else {
    database_select_db($dbase, $conn) or die('<p><b>[07] Error:</b> during MySQL database selection. Most likely the database name set in config.php file is incorrect, or there is no such database is down. For PHP/MySQL debugging, turn on the debug_mode option in the config.php file.</p>');
  }
  database_query("SET NAMES 'utf8'", $conn);
}

function execute_db($sql, $conn, $file = 'unknown') {
  global $debug_mode;
  if($debug_mode == 1) {
    $results = database_query($sql, $conn) or die('<p><b>[08] Error:</b> during MySQL query execution (called from file <i>' . $file . '</i>). The query statement was:<br /><br />' . htmlspecialchars($sql) . '<br /><br />The MySQL server responded: ' . htmlspecialchars(database_error($conn)) . '</p>');
  }
  else {
    $results = database_query($sql, $conn) or die('<p><b>[08] Error:</b> during MySQL query execution. Perhaps there is something wrong with the PHP code. For PHP/MySQL debugging, turn on the debug_mode option in the config.php file.</p>');
  }
  return $results;
}

if(!function_exists('mysqli_connect')){
  function database_affected_rows($x){return mysql_affected_rows($x);}
  function database_connect($x, $y, $z){return mysql_connect($x, $y, $z);}
  function database_error($x){return mysql_error($x);}
  function database_fetch_array($x){return mysql_fetch_array($x);}
  function database_fetch_field($x){return mysql_fetch_field($x);}
  function database_fetch_row($x){return mysql_fetch_row($x);}
  function database_field_flags($x, $y){return mysql_field_flags($x, $y);}
  function database_field_name($x, $y){return mysql_field_name($x, $y);}
  function database_insert_id($x){return mysql_insert_id($x);}
  function database_list_fields($x, $y, $z){$r = array(); $b = mysql_query('SHOW COLUMNS FROM `'. $y. '`', $z); while($a = mysql_fetch_row($b)){$r[] = $a;}; return $r;}
  function database_list_tables($x, $y){$r = array(); $z = mysql_query('SHOW TABLES', $y); while($a = mysql_fetch_row($z)){$r[] = $a[0];}; return $r;}
  function database_num_fields($x){return mysql_num_fields($x);}
  function database_num_rows($x){return mysql_num_rows($x);}
  function database_query($x){return mysql_query($x);}
  function database_select_db($x, $y){return mysql_select_db($x, $y);}
}
else{
  function database_affected_rows($x){return mysqli_affected_rows($x);}
  function database_connect($x, $y, $z){return mysqli_connect($x, $y, $z);}
  function database_error($x){return mysqli_error($x);}
  function database_fetch_array($x){return mysqli_fetch_array($x);}
  function database_fetch_field($x){return mysqli_fetch_field($x);}
  function database_fetch_row($x){return mysqli_fetch_row($x);}
  function database_field_name($x, $y){return mysqli_fetch_field_direct($x, $y)->name;}
  function database_insert_id($x){return mysqli_insert_id($x);}
  function database_list_fields($x, $y, $z){$r = array(); $b = mysqli_query($z, 'SHOW COLUMNS FROM `'. $y. '`'); while($a = $b->fetch_row()){$r[] = $a;}; return $r;}
  function database_list_tables($x, $y){$r = array(); $z = mysqli_query($y, 'SHOW TABLES'); while($a = $z->fetch_row()){$r[] = $a[0];}; return $r;}
  function database_num_fields($x){return mysqli_num_fields($x);}
  function database_num_rows($x){return mysqli_num_rows($x);}
  function database_query($x, $y){return mysqli_query($y, $x);}
  function database_select_db($x, $y){return mysqli_select_db($y, $x);}
}

// encryption/decryption
// use mcrypt functions if available
// else Rafael Salvoni's 2008 code using RC4 -- http://www.php.net/manual/en/ref.mcrypt.php#87274
function enc($data) {
  global $pass;
  if(function_exists(mcrypt_encrypt)) {
    return mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $pass, $data, MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND));
  }
  $key = $pass;
  static $SC;
  $swap = create_function('&$v1, &$v2', '
        $v1 = $v1 ^ $v2;
        $v2 = $v1 ^ $v2;
        $v1 = $v1 ^ $v2;
    ');
  $ikey = crc32($key);
  if(!isset($SC[$ikey])) {
    $S = range(0, 255);
    $j = 0;
    $n = strlen($key);
    for($i = 0;$i < 255;$i++) {
      $char = ord($key {
        $i % $n
      });
      $j = ($j + $S[$i] + $char) % 256;
      $swap($S[$i], $S[$j]);
    }
    $SC[$ikey] = $S;
  }
  else {
    $S = $SC[$ikey];
  }
  $n = strlen($data);
  $data = str_split($data, 1);
  $i = $j = 0;
  for($m = 0;$m < $n;$m++) {
    $i = ($i + 1) % 256;
    $j = ($j + $S[$i]) % 256;
    $swap($S[$i], $S[$j]);
    $char = ord($data[$m]);
    $char = $S[($S[$i] + $S[$j]) % 256]^ $char;
    $data[$m] = chr($char);
  }
  return implode('', $data);
}

function denc($data) {
  global $pass;
  if(function_exists(mcrypt_decrypt)) {
    return mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $pass, $data, MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND));
  }
  $key = $pass;
  static $SC;
  $swap = create_function('&$v1, &$v2', '
        $v1 = $v1 ^ $v2;
        $v2 = $v1 ^ $v2;
        $v1 = $v1 ^ $v2;
    ');
  $ikey = crc32($key);
  if(!isset($SC[$ikey])) {
    $S = range(0, 255);
    $j = 0;
    $n = strlen($key);
    for($i = 0;$i < 255;$i++) {
      $char = ord($key {
        $i % $n
      });
      $j = ($j + $S[$i] + $char) % 256;
      $swap($S[$i], $S[$j]);
    }
    $SC[$ikey] = $S;
  }
  else {
    $S = $SC[$ikey];
  }
  $n = strlen($data);
  $data = str_split($data, 1);
  $i = $j = 0;
  for($m = 0;$m < $n;$m++) {
    $i = ($i + 1) % 256;
    $j = ($j + $S[$i]) % 256;
    $swap($S[$i], $S[$j]);
    $char = ord($data[$m]);
    $char = $S[($S[$i] + $S[$j]) % 256]^ $char;
    $data[$m] = chr($char);
  }
  return implode('', $data);
}
