<?php

/*
Interface Creator
www.bioinformatics.org/phplabware
6 September 2014 release
By Santosh Patnaik, MD, PhD
GPL license
Based on DaDaBik version 3.2 by Eugenio Tacchini - http://www.dadabik.org
*/

include(realpath(dirname(__FILE__) . '/../config.php'));
include(realpath(dirname(__FILE__) . '/functions.php'));
include(realpath(dirname(__FILE__) . '/common_start.php'));
include(realpath(dirname(__FILE__) . '/header_admin.php'));

if(isset($_GET["table_name"])) {
  $table_name = $_GET["table_name"];
}
else {
  $table_name = "";
}

if(isset($_POST["install"])) {
  $install = $_POST["install"];
}
else {
  $install = "";
}
if($install == "1") {
  if($table_name != "") {
    $tables_names_ar[0] = $table_name;
    if(!table_exists($table_list_name)) {
      create_table_list_table();
    }
  }
  else {
    create_users_table();
    $tables_names_ar = build_tables_names_array(0, 0, 1);
    create_table_list_table();
  }
  for($i = 0; $i < count($tables_names_ar); $i++) {
    $table_name_temp = $tables_names_ar[$i];
    $table_internal_name_temp = $prefix_internal_table . $table_name_temp;
    $unique_field_name = get_unique_field($table_name_temp);
    $fields_names_ar = build_fields_names_array($table_name_temp);
    create_internal_table($table_internal_name_temp);
    $sql = "delete from `" . add_slashes($table_list_name, 1) . "` where `name_table` = " . add_slashes($table_name_temp);
    $res_delete = execute_db($sql, $conn, 'install.php');
    $sql = "insert into `" . add_slashes($table_list_name, 1) . "` (`name_table`, `allowed_table`, `enable_insert_table`, `enable_edit_table`, `enable_delete_table`, `enable_details_table`) values (" . add_slashes($table_name_temp) . ", '1', '1', '1', '1', '1')";
    $res_insert = execute_db($sql, $conn, 'install.php');
    if($table_name_temp === $users_table_name) {
      $sql = "INSERT INTO `" . add_slashes($table_internal_name_temp, 1) . "` VALUES ('ID_user', 'ID_user', 'text', 'alphanumeric', '0', '0', '0', '0', '1', '0', '0', '0', '', '', '', '', '', '', '', '', 'is_equal/contains/starts_with/ends_with/greater_than/less_then', '', '', '', '', '100', '', 1, '~')";
      $res_insert = execute_db($sql, $conn, 'install.php');
      $sql = "INSERT INTO `" . add_slashes($table_internal_name_temp, 1) . "` VALUES ('user_type_user', 'User type', 'select_single', 'alphanumeric', '1', '1', '1', '1', '1', '1', '0', '0', '~admin~normal~', '', '', '', '', '', '',  '','is_equal/contains/starts_with/ends_with/greater_than/less_then', '', '', '', '', '100', '', 2, '~')";
      $res_insert = execute_db($sql, $conn, 'install.php');
      $sql = "INSERT INTO `" . add_slashes($table_internal_name_temp, 1) . "` VALUES ('username_user', 'Username', 'text', 'alphanumeric', '1', '1', '1', '1', '1', '1', '0', '0', '', '', '', '', '', '', '',  '','is_equal/contains/starts_with/ends_with/greater_than/less_then', '', '', '', '', '100', '', 3, '~')";
      $res_insert = execute_db($sql, $conn, 'install.php');
      $sql = "INSERT INTO `" . add_slashes($table_internal_name_temp, 1) . "` VALUES ('password_user', 'Password (md5 hash)', 'text', 'alphanumeric', '0', '0', '1', '1', '1', '1', '0', '0', '', '', '', '', '', '', '',  '','is_equal/contains/starts_with/ends_with/greater_than/less_then', '', '', '', '', '100', '', 4, '~')";
      $res_insert = execute_db($sql, $conn, 'install.php');
    }
    else {
      for($j = 0;$j < count($fields_names_ar);$j++) {
        $sql = "insert into `" . add_slashes($table_internal_name_temp, 1) . "` (`name_field`, `label_field`, `order_form_field`) values (" . add_slashes($fields_names_ar[$j]) . ", " . add_slashes($fields_names_ar[$j]) . ", '" . ($j + 1) . "')";
        $res_insert = execute_db($sql, $conn, 'install.php');
      }
    }
    if(table_exists($table_internal_name_temp)) {
      echo "<p>Internal table <b>" . htmlspecialchars($table_internal_name_temp) . "</b> correctly created...</p>";
    }
    else {
      echo "<p>An error occurred during installation!</p>";
      exit;
    }
    if($unique_field_name == "") {
      echo "<p><b>Warning:</b> the table <b>" . htmlspecialchars($table_name_temp) . "</b> does not have a primary key set. If you do not set a primary key, the interface creator won't show the edit/delete/details buttons.</p>";
    }
  }
  echo "<p>... the interface creator is properly installed.</p>";
  echo "<p>You can now manage information in the MySQL tables, starting from <a href=\"" . $dadabik_main_file . "\">the data browser front page</a></p>";
  echo "<p>In order to configure the appearance of records from this table and of the forms used to manipulate data in the table, go to the <a href=\"admin.php\">administration</a> area.</p>";
}
else {
  echo "<form name=\"install_form\" id=\"install_form\" action=\"install.php?table_name=" . rawurlencode($table_name) . "\" method=\"post\">";
  echo "<p><input type=\"hidden\" name=\"install\" id=\"install\" value=\"1\" />";
  if($table_name != "") {
    echo "<input type=\"submit\" value=\"Click this button to install " . htmlspecialchars($table_name) . " table\" />";
  }
  if($table_name == "") {
    echo "<input type=\"submit\" value=\"Click this button to install the interface creator\" />";
    echo "<br /><br />Please note that if the interface creator is already installed in the " . htmlspecialchars($db_name) . " database, the installation will overwrite the previous configuration. The installation will also overwrite the users table - " . htmlspecialchars($users_table_name) . ". If you want to keep the pre-existent one, just back it up  and import it after the installation (for how to backup and import MySQL tables, please check elsewhere; you may want to try the free web application phpmyadmin - www.phpmyadmin.net).</p>";
  }
  echo "</form>";
}

include(realpath(dirname(__FILE__) . '/footer_admin.php'));
