<?php

/*
Interface Creator
www.bioinformatics.org/phplabware
6 September 2014 release
By Santosh Patnaik, MD, PhD
GPL license
Based on DaDaBik version 3.2 by Eugenio Tacchini - http://www.dadabik.org
*/

include(realpath(dirname(__FILE__) . '/../config.php'));
include(realpath(dirname(__FILE__) . '/functions.php'));
include(realpath(dirname(__FILE__) . '/common_start.php'));
include(realpath(dirname(__FILE__) . '/check_installation.php'));
include(realpath(dirname(__FILE__) . '/header_admin.php'));

if(!isset($_GET["table_name"])) {
  exit;
}
else {
  $table_name = $_GET["table_name"];
}

$table_internal_name = $prefix_internal_table . $table_name;

if(!isset($_POST["show_all_fields"])) {
  $show_all_fields = "";
}
else {
  $show_all_fields = $_POST["show_all_fields"];
}

if(!isset($_POST["field_position"])) {
  $field_position = "";
}
else {
  $field_position = intval($_POST["field_position"]);
}

if(isset($_POST["save"])) {
  $save = $_POST["save"];
}
else {
  $save = "0";
}

include("internal_table.php");
$fields_labels_ar = build_fields_labels_array($table_internal_name, "1");
if($field_position == "" and $show_all_fields != "1") {
  $field_position = 0;
}
if($save == "1") {
  for($i = 0;$i < count($fields_labels_ar);$i++) {
    if(isset($_POST[$int_fields_ar[1][1] . "_" . $i])) {
      $sql = "";
      $sql .= "update `" . add_slashes($table_internal_name, 1) . "` set ";
      for($j = 1;$j < count($int_fields_ar);$j++) {
        $sql .= "`" . add_slashes($int_fields_ar[$j][1], 1) . "` = " . add_slashes($_POST[$int_fields_ar[$j][1] . "_" . $i]) . ", ";
      }
      $sql = substr($sql, 0, strlen($sql) - 2);
      $sql .= " where `name_field` = " . add_slashes($fields_labels_ar[$i]["name_field"]);
      $res_update = execute_db($sql, $conn, 'internal_table_manager.php');
    }
  }
  echo "<p>Configuration correctly saved.</p>";
}

$fields_labels_ar = build_fields_labels_array($table_internal_name, "1");
$change_field_select = build_change_field_select($fields_labels_ar, $field_position);
$int_table_form = "";
$int_table_form .= "<p>This form allows you to configure the way the fields for this table - <b>" . htmlspecialchars($table_name) . "</b> - appear on the web forms. To configure for fields of a different table, choose that table on the interface creator administration home page. (<a href=\"help.htm\" onclick=\"return popitup('help.htm')\">Help</a>)</p><form method=\"post\" action=\"internal_table_manager.php?table_name=" . rawurlencode($table_name) . "\">" . $change_field_select . "<p><input type=\"submit\" value=\"Select a field above and click to configure it\" /></p></form>

<form method=\"post\" action=\"internal_table_manager.php?table_name=" . rawurlencode($table_name) . "\"><p><input type=\"hidden\" name=\"show_all_fields\" id=\"show_all_fields\" value=\"1\" /><input type=\"submit\" value=\"Or click to configure all fields\" /></p></form>

<form method=\"post\" action=\"internal_table_manager.php?table_name=" . rawurlencode($table_name) . "\">";
if($show_all_fields == "1") {
  for($i = 0;$i < count($fields_labels_ar);$i++) {
    $int_table_form .= build_int_table_field_form($i, $int_fields_ar, $fields_labels_ar);
  }
}
else {
  $int_table_form .= build_int_table_field_form($field_position, $int_fields_ar, $fields_labels_ar);
}
$int_table_form .= "<p><input type=\"hidden\" name=\"field_position\" id=\"field_position\" value=\"" . $field_position . "\" />";
$int_table_form .= "<input type=\"hidden\" name=\"show_all_fields\" id=\"show_all_fields\" value=\"" . $show_all_fields . "\" />";
$int_table_form .= "<input type=\"submit\" value=\"Save configuration\" />";
$int_table_form .= "<input type=\"hidden\" name=\"save\" id=\"save\" value=\"1\" />";
$int_table_form .= "</p></form>";
echo $int_table_form;

include(realpath(dirname(__FILE__) . '/footer_admin.php'));
