<?php

/*
OrderSys
Version: 1.7.2
Date: 12 September 2014
Copyright: Santosh Patnaik, MD, PhD
License: GPL 3+
URL: www.bioinformatics.org/phplabware
*/

session_start();
ob_start();
include(realpath(dirname(__FILE__) . '/config.php'));

// Taking care of magic quotes gpc
if(get_magic_quotes_gpc()) {
  // Recursively apply stripslashes() to all data
  $_GET = strip_slashes($_GET);
  $_POST = strip_slashes($_POST);
  $_COOKIE = strip_slashes($_COOKIE);
  $_REQUEST = strip_slashes($_REQUEST);
  ini_set('magic_quotes_gpc', 0);
}
if(get_magic_quotes_runtime()) {
  set_magic_quotes_runtime(0);
}

// Magic quotes issues
function add_slashes($value, $param = '') {
  if(is_array($value)) {
    foreach($value as $index=>$val) {
      $value[$index] = add_slashes($val);
    }
    return $value;
  }
  else {
    $value = str_replace(array("\\", "\0", "\n", "\r", "\x1a", "'", '"'), array("\\\\", "\\0", "\\n", "\\r", "\Z", "\'", '\"'), $value);
    if(empty($param)) {
      return "'" . $value . "'";
    }
    elseif($param == 2) {
      return $value;
    }
    else {
      return str_replace('`', '\`', $value);
    }
  }
}
function strip_slashes($value) {
  if(is_array($value)) {
    foreach($value as $index=>$val) {
      $value[$index] = strip_slashes($val);
    }
    return $value;
  }
  else {
    return stripslashes($value);
  }
}

// Database functions
function connect_db($server, $user, $password) {
  global $debug_mode;
  if($debug_mode == 1) {
    $conn = database_connect($server, $user, $password) or die('<p><b>[06] Error:</b> during MySQL database connection.<br />MySQL server said: ' . htmlspecialchars(database_error($conn)) . '</p>');
  }
  else {
    $conn = database_connect($server, $user, $password) or die('<p><b>[06] Error:</b> during MySQL database connection. Most likely the settings in config.php file are incorrect, or the MySQL server is down. For PHP/MySQL debugging, turn on the debug_mode option in the config.php file.</p>');
  }
  return $conn;
}

function choose_db($dbase, $conn) {
  global $debug_mode;
  if($debug_mode == 1) {
    database_select_db($dbase, $conn) or die('<p><b>[07] Error:</b> during MySQL database selection.<br />MySQL server said: ' . htmlspecialchars(database_error($conn)) . '</p>');
  }
  else {
    database_select_db($dbase, $conn) or die('<p><b>[07] Error:</b> during MySQL database selection. Most likely the database name set in config.php file is incorrect, or there is no such database is down. For PHP/MySQL debugging, turn on the debug_mode option in the config.php file.</p>');
  }
  database_query("SET NAMES 'utf8'", $conn);
}

function execute_db($sql, $conn, $file = 'unknown') {
  global $debug_mode;
  if($debug_mode == 1) {
    $results = database_query($sql, $conn) or die('<p><b>[08] Error:</b> during MySQL query execution (called from file <i>' . $file . '</i>). The query statement was:<br /><br />' . htmlspecialchars($sql) . '<br /><br />The MySQL server responded: ' . htmlspecialchars(database_error($conn)) . '</p>');
  }
  else {
    $results = database_query($sql, $conn) or die('<p><b>[08] Error:</b> during MySQL query execution. Perhaps there is something wrong with the PHP code. For PHP/MySQL debugging, turn on the debug_mode option in the config.php file.</p>');
  }
  return $results;
}

// For mysql_ vs. mysqli_ use
if(!function_exists('mysqli_connect')){
  function database_affected_rows($x){return mysql_affected_rows($x);}
  function database_connect($x, $y, $z){return mysql_connect($x, $y, $z);}
  function database_error($x){return mysql_error($x);}
  function database_fetch_array($x){return mysql_fetch_array($x);}
  function database_fetch_field($x){return mysql_fetch_field($x);}
  function database_fetch_row($x){return mysql_fetch_row($x);}
  function database_field_flags($x, $y){return mysql_field_flags($x, $y);}
  function database_field_name($x, $y){return mysql_field_name($x, $y);}
  function database_insert_id($x){return mysql_insert_id($x);}
  function database_list_fields($x, $y, $z){$r = array(); $b = mysql_query('SHOW COLUMNS FROM `'. $y. '`', $z); while($a = mysql_fetch_row($b)){$r[] = $a;}; return $r;}
  function database_list_tables($x, $y){$r = array(); $z = mysql_query('SHOW TABLES', $y); while($a = mysql_fetch_row($z)){$r[] = $a[0];}; return $r;}
  function database_num_fields($x){return mysql_num_fields($x);}
  function database_num_rows($x){return mysql_num_rows($x);}
  function database_query($x){return mysql_query($x);}
  function database_select_db($x, $y){return mysql_select_db($x, $y);}
}
else{
  function database_affected_rows($x){return mysqli_affected_rows($x);}
  function database_connect($x, $y, $z){return mysqli_connect($x, $y, $z);}
  function database_error($x){return mysqli_error($x);}
  function database_fetch_array($x){return mysqli_fetch_array($x);}
  function database_fetch_field($x){return mysqli_fetch_field($x);}
  function database_fetch_row($x){return mysqli_fetch_row($x);}
  function database_field_name($x, $y){return mysqli_fetch_field_direct($x, $y)->name;}
  function database_insert_id($x){return mysqli_insert_id($x);}
  function database_list_fields($x, $y, $z){$r = array(); $b = mysqli_query($z, 'SHOW COLUMNS FROM `'. $y. '`'); while($a = $b->fetch_row()){$r[] = $a;}; return $r;}
  function database_list_tables($x, $y){$r = array(); $z = mysqli_query($y, 'SHOW TABLES'); while($a = $z->fetch_row()){$r[] = $a[0];}; return $r;}
  function database_num_fields($x){return mysqli_num_fields($x);}
  function database_num_rows($x){return mysqli_num_rows($x);}
  function database_query($x, $y){return mysqli_query($y, $x);}
  function database_select_db($x, $y){return mysqli_select_db($y, $x);}
}

$conn = connect_db($host, $user, $pass);
$selected = choose_db($db_name, $conn);

// Get client's IP address
if($all_see_tables == "no" or $all_affect_items == "no") {
  if(empty($_SERVER["HTTP_X_FORWARDED_FOR"])) {
    $IP = $_SERVER["REMOTE_ADDR"];
  }
  else {
    $IP = $_SERVER["HTTP_X_FORWARDED_FOR"];
  }
  $lh = gethostbyaddr($_SERVER['REMOTE_ADDR']);
  // Test that the address is allowed
  $test = $IP . "." . $lh;
  if(in_array($test, $allowed) || in_array($IP, $allowed)) {
    $client = "allowed";
  }
  else {
    $client = "not_allowed";
  }
}

// get log_status - if authentication enabled
// show logout
if($enable_authentication === 1 or $enable_admin_authentication === 1) {
  if(isset($_SESSION['logged_user_infos_ar']['username_user'])) {
    $log_status = '<a href="'. $site_url.$dadabik_login_file. '?function=logout&amp;go_to=parent_front">Log out - '. htmlspecialchars($_SESSION['logged_user_infos_ar']['username_user']). '</a> || ';
  }
  else {
    $log_status = '';
  }
}
else {
  $log_status = '';
} 

// Check_login; will go to login if authentication enabled in config.php
include(realpath(dirname(__FILE__) . '/interface_creator/check_login.php'));
