<?php

/*
OrderSys
Version: 1.7.2
Date: 12 September 2014
Copyright: Santosh Patnaik, MD, PhD
License: GPL 3+
URL: www.bioinformatics.org/phplabware
*/

// leave if wrong IP
if($all_see_tables == "no" and $client == "not_allowed") {
  echo('<tr><td><span style="color:red;">Sorry, this IP address is not allowed access to this page. You may want to see the <a href="help/help.htm">help</a> section to know more about this website, to download the software, etc.</span></p></td></tr></table><div>');
  include(realpath(dirname(__FILE__) . '/footer.php'));
  exit();
}
// start -------------- where conditions for mysql query; sterm is term, smenu is menu option, sbool is for and/or
foreach(array('sterm_1', 'sterm_2', 'sbool', 'smenu_1', 'smenu_2', 'sort_1', 'sort_2', 'order_1', 'order_2') as $x) {
  $y = '';
  if(isset($_GET[$x])) {
    $y = $_GET[$x];
  }
  if(isset($_POST[$x])) {
    $y = $_POST[$x];
  }
  $myget[$x] = $y;
  if(!isset($myget['sbool']) or strtolower($myget['sbool']) != 'and') {
    $sbool = "OR";
  }
  else {
    $sbool = 'AND';
  }
  if(!isset($myget['order_1']) or strtolower($myget['order_1']) != 'desc') {
    $myget['order_1'] = "ASC";
  }
  else {
    $myget['order_1'] = 'DESC';
  }
  if(!isset($myget['order_2']) or strtolower($myget['order_2']) != 'desc') {
    $myget['order_2'] = "ASC";
  }
  else {
    $myget['order_2'] = 'DESC';
  }
}
$where_condition = "";
if(isset($myget['sterm_1']) and $myget['sterm_1'] != '') {
  if(isset($myget['sterm_2']) and $myget['sterm_2'] != '') {
    $where_condition = " WHERE `" . add_slashes($myget['smenu_1'], 1) . "` LIKE '%" . add_slashes($myget['sterm_1'], 2) . "%' " . $sbool . " `" . add_slashes($myget['smenu_2'], 1) . "` LIKE '%" . add_slashes($myget['sterm_2'], 2) . "%'";
  }
  else {
    $where_condition = " WHERE `" . add_slashes($myget['smenu_1'], 1) . "` LIKE '%" . add_slashes($myget['sterm_1'], 2) . "%'";
  }
}
else {
  if(isset($myget['sterm_2']) and $myget['sterm_2'] != '') {
    $where_condition = " WHERE `" . add_slashes($myget['smenu_2'], 1) . "` LIKE '%" . add_slashes($myget['sterm_2'], 2) . "%'";
  }
}
// end ------------- get where conditions for query
// start ----------- sort conditions for mysql query
$order_condition = "`name` ASC";
if($table == $users_table_name) {
  $order_condition = "`" . $users_table_username_field . "` ASC";
}
if($table == 'order') {
  $order_condition = "`ordered_date` DESC";
}
if(isset($myget['sort_1']) and $myget['sort_1'] != '') {
  if(isset($myget['order_1'])) {
    $order_condition = "`" . add_slashes($myget['sort_1'], 1) . "` " . $myget['order_1'];
  }
  else {
    $order_condition = "`" . add_slashes($myget['sort_1'], 1) . "` ASC";
  }
  // if the optional second sort option was chosen - conditional on 1st being chosen
  if(isset($myget['sort_2']) and $myget['sort_2'] != '' and $myget['sort_2'] !== $myget['sort_1']) {
    if(isset($myget['order_2'])) {
      $order_condition .= ", `" . add_slashes($myget['sort_2'], 1) . "` " . $myget['order_2'];
    }
    else {
      $order_condition .= ", `" . add_slashes($myget['sort_2'], 1) . "` ASC";
    }
  }
}
// end ------------- get sort conditions for query
// page numbering setup
if(!isset($_GET['page'])) {
  $page = 1;
}
else {
  $page = intval($_GET['page']);
}
//get checked values
if(isset($_POST['checked'])) {
  foreach($_POST['checked'] as $key=>$value) {
    $POSTchecked[] = $key;
  }
}
//if no checked value, still set postchecked
else {
  $POSTchecked = array();
}
//set session checked if not set
if(!isset($_SESSION['checked'])) {
  $_SESSION['checked'] = array();
}
//add checked values to session checked
$_SESSION['checked'] = array_unique(array_merge($_SESSION['checked'], $POSTchecked));
//get unchecked values
if(isset($_POST['unchecked'])) {
  foreach($_POST['unchecked'] as $key=>$value) {
    $POSTunchecked[] = $key;
  }
}
//if no unchecked value, still set postunchecked
else {
  $POSTunchecked = array();
}
//set session unchecked if not set
if(!isset($_SESSION['unchecked'])) {
  $_SESSION['unchecked'] = array();
}
//subtract postunchecked from session checked
$_SESSION['checked'] = array_diff($_SESSION['checked'], $POSTunchecked);
// reset to 0 if 'empty cart'
if(isset($_POST['empty']) and $_POST['empty'] == 'Clear all') {
  $_SESSION['checked'] = array();
}
// items to show by page
$from = (($page * $max_results) - $max_results);
// get total entries
$num_tot = database_num_rows(execute_db("SELECT * FROM `" . add_slashes($table, 1) . "`", $conn, 'ordersys/top_part.php'));
// get number of entries satisfying WHERE conditions
$num_sat = database_num_rows(execute_db("SELECT * FROM `" . add_slashes($table, 1) . "`" . $where_condition, $conn, 'ordersys/top_part.php'));
if($num_tot !== $num_sat) {
  $total_pages = ceil($num_sat / $max_results);
}
else {
  $total_pages = ceil($num_tot / $max_results);
}
// build search form //////////////////////////////////////////////////////
/////////// get values to prefill
echo '<tr><td valign="top">';
if($num_tot > 0) {
  // get the option - smenu - and term - sterm - from each sort
  $sterm_1 = isset($_GET['sterm_1']) ? $_GET['sterm_1'] : (isset($_POST['sterm_1']) ? $_POST['sterm_1'] : '');
  $sterm_2 = isset($_GET['sterm_2']) ? $_GET['sterm_2'] : (isset($_POST['sterm_2']) ? $_POST['sterm_2'] : '');
  $smenu_1 = isset($_GET['smenu_1']) ? $_GET['smenu_1'] : (isset($_POST['smenu_1']) ? $_POST['smenu_1'] : '');
  $smenu_2 = isset($_GET['smenu_2']) ? $_GET['smenu_2'] : (isset($_POST['smenu_2']) ? $_POST['smenu_2'] : '');
  $sbool = isset($_GET['sbool']) ? ($_GET['sbool'] == 'AND' ? 'AND' : 'OR') : (isset($_POST['sbool']) ? ($_POST['sbool'] == 'AND' ? 'AND' : 'OR') : 'AND');
  $order_1 = isset($_GET['order_1']) ? ($_GET['order_1'] == 'ASC' ? 'ASC' : 'DESC') : (isset($_POST['order_1']) ? ($_POST['order_1'] == 'ASC' ? 'ASC' : 'DESC') : 'ASC');
  $order_2 = isset($_GET['order_2']) ? ($_GET['order_2'] == 'ASC' ? 'ASC' : 'DESC') : (isset($_POST['order_2']) ? ($_POST['order_2'] == 'ASC' ? 'ASC' : 'DESC') : 'ASC');
  $sort_1 = isset($_GET['sort_1']) ? $_GET['sort_1'] : (isset($_POST['sort_1']) ? $_POST['sort_1'] : '');
  $sort_2 = isset($_GET['sort_2']) ? $_GET['sort_2'] : (isset($_POST['sort_2']) ? $_POST['sort_2'] : '');
  /////////// end - get values to prefill
  // add extra item to option-value array
  $option_value3 = $option_value;
  $option_value3['name'] = "Has in name or...";
  echo '<form action="', htmlspecialchars($_SERVER['PHP_SELF']), '" method="get"><p>';
  //--------------------------------------------------
  echo '<select single="single" id="smenu_1" name="smenu_1">';
  foreach($option_value3 as $value=>$option) {
    echo '<option value="', htmlspecialchars($value);
    if($value == $smenu_1) {
      echo '" selected="selected"';
    }
    else {
      echo '"';
    }
    echo '>', htmlspecialchars($option), '</option>';
  }
  echo '</select>';
  echo '<input name="sterm_1" id="sterm_1" type="text" size="15" maxlength="30" value="', htmlspecialchars($sterm_1), '" />';
  //--------------------------------------------------
  echo '<select single="single" name="sbool" id="sbool">';
  echo '<option value="AND"';
  if($sbool == "AND") {
    echo ' selected="selected"';
  }
  echo '>And</option>';
  echo '<option value="OR"';
  if($sbool == "OR") {
    echo ' selected="selected"';
  }
  echo '>Or</option>';
  echo '</select>';
  //--------------------------------------------------
  echo '<select single="single" name="smenu_2" id="smenu_2">';
  foreach($option_value3 as $value=>$option) {
    echo '<option value="', htmlspecialchars($value);
    if($value == $smenu_2) {
      echo '" selected="selected"';
    }
    else {
      echo '"';
    }
    echo '>', htmlspecialchars($option), '</option>';
  }
  echo '</select>';
  //--------------------------------------------------
  echo '<input name="sterm_2" id="sterm_2" type="text" size="15" maxlength="30" value="', rawurlencode($sterm_2), '" />';
  echo '<input type="hidden" name="order_1" value="', htmlspecialchars($order_1), '" /><input type="hidden" name="order_2" value="', htmlspecialchars($order_2), '" /><input type="hidden" name="sort_1" value="', htmlspecialchars($sort_1), '" /><input type="hidden" name="sort_2" value="', htmlspecialchars($sort_2), '" /><input type="submit" value="Find" name="submit_find" id="submit_find" /><a href="../help/help.htm#search" onclick="return popitup(\'../help/help.htm#search\')">?</a></p></form>';
}
// end - build search form
///////////////////////////////////////////////////////////////////////////
// build menu form for resorting; the option values are table column headings
// only if more than one page of data
if($total_pages > 1) {
  // add extra item to option-value array
  $option_value2 = $option_value;
  $option_value2[''] = "Sort by";
  // form html code
  echo '
 <form action="', htmlspecialchars($_SERVER['PHP_SELF']), '" method="get"><p>';
  //--------------------------------------------------
  echo '<select single="single" name="sort_1" id="sort_1">';
  foreach($option_value2 as $value=>$option) {
    echo '<option value="', htmlspecialchars($value);
    if($value == $sort_1) {
      echo '" selected="selected"';
    }
    else {
      echo '"';
    }
    echo '>', htmlspecialchars($option), '</option>';
  }
  echo '</select>';
  //--------------------------------------------------
  echo '<select single="single" id="order_1" name="order_1">';
  echo '<option value="ASC"';
  if($order_1 == "ASC") {
    echo ' selected="selected"';
  }
  echo '>Ascending</option>';
  echo '<option value="DESC"';
  if($order_1 == "DESC") {
    echo ' selected="selected"';
  }
  echo '>Descending</option>';
  echo '</select> then (optional) ';
  //--------------------------------------------------
  echo '<select single="single" id="sort_2" name="sort_2">';
  foreach($option_value2 as $value=>$option) {
    echo '<option value="', htmlspecialchars($value);
    if($value == $sort_2) {
      echo '" selected="selected"';
    }
    else {
      echo '"';
    }
    echo '>', htmlspecialchars($option), '</option>';
  }
  echo '</select>';
  //--------------------------------------------------
  echo '<select single="single" id="order_2" name="order_2">';
  echo '<option value="ASC"';
  if($order_2 == "ASC") {
    echo ' selected="selected"';
  }
  echo '>Ascending</option>';
  echo '<option value="DESC"';
  if($order_2 == "DESC") {
    echo ' selected="selected"';
  }
  echo '>Descending</option>';
  echo '</select>';
  //--------------------------------------------------
  echo '<input type="hidden" name="sterm_1" value="', htmlspecialchars($sterm_1), '" /><input type="hidden" name="sterm_2" value="', htmlspecialchars($sterm_2), '" /><input type="hidden" name="smenu_1" value="', htmlspecialchars($smenu_1), '" /><input type="hidden" name="smenu_2" value="', htmlspecialchars($smenu_2), '" /><input type="hidden" name="sbool" value="', htmlspecialchars($sbool), '" /><input type="submit" name="submit_sort" id="submit_sort" value="Sort" /><a href="../help/help.htm#sort" onclick="return popitup(\'../help/help.htm#sort\')">?</a></p></form>';
}
// end - build sort form
///////////////////////////////////////////////////////////////////////////
if($num_sat !== 0) {
  if($num_tot !== $num_sat) {
    echo '<p>Showing ', $num_sat, ' from a <a href="', htmlspecialchars($_SERVER['PHP_SELF']), '">total</a> of ', $num_tot, ' entries';
  }
  else {
    echo "<p>Showing all ", $num_sat, " of ", $num_tot, " entries";
  }
  // depending on total number of pages
  if($total_pages > 1) {
    echo " on ", $total_pages, " pages, sorted as indicated</p>";
  }
  else {
    echo " on one page </p>";
  }
}
else {
  if($num_tot !== 0) {
    echo '<p>None of the <a href="', htmlspecialchars($_SERVER['PHP_SELF']), '">total</a> ', $num_tot, ' entries match your search criteria. Note that the default search is against name/description and an entry will be returned only if your query is a part of its name/description (e.g., "zp" is a part of "ZP 1" but "ZP1" is not). Try changing the search phrase, e.g., "rabbits" to "rabbit" and "2 at 4 deg" to "2 at 4-deg." Searches are not case sensitive, but wild cards are not allowed.</p>';
  }
  else {
    echo '<p>The table is empty! <br /></p>';
  }
}
// end upper table
echo '</td></tr></table>';
// generate the query for mysql only if num_sat is more than zero
if($num_sat !== 0) {
  $query = "SELECT * FROM `" . add_slashes($table, 1) . "`";
  if($where_condition != '') {
    $query .= $where_condition;
  }
  // expand the query to include ORDER conditions
  $query .= " ORDER BY " . $order_condition;
  // get page-number dictated entries satisfying WHERE and ORDER conditions
  $query .= " LIMIT " . intval($from) . ", " . intval($max_results);
  $result = execute_db($query, $conn, 'ordersys/top_part.php');
  $numofrows = database_num_rows($result);
  // table start
  echo('<table summary="list" width="750" style="background-color:#efefef; border:0;" cellpadding="5" cellspacing="1">');
}
