<?php

/*
OrderSys
Version: 1.7.2
Date: 12 September 2014
Copyright: Santosh Patnaik, MD, PhD
License: GPL 3+
URL: www.bioinformatics.org/phplabware
*/

include(realpath(dirname(__FILE__) . '/start.php'));

header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Pragma: no-cache");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Cache-control: private");
header('Content-Type: text/html; charset=utf-8');

$queryvendor = "SELECT `Name`,`website` FROM `vendor` ORDER BY `Name`";
$resultvendor = execute_db($queryvendor, $conn, 'ordersys/vendorsites_left.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<?php
echo '<title>', $mainsite_name, ' - ', $parentsite_name, '</title><link rel="stylesheet" href="style.css" type="text/css" />
</head>
<body>
<p>
<span style="font-size:10px;"><a href="', $parentsite_url, 'index.php" onclick="javascript:top.location.href = \'', $parentsite_url, '\';return true;">', $parentsite_name, '</a> | 
<a href="', $mainsite_url, '" onclick="javascript:top.location.href = \'', $mainsite_url, '\';return true;">', $mainsite_name, '</a><br /><br />';
while($row = database_fetch_array($resultvendor)) {
  $name = $row["Name"];
  $site = $row["website"];
  echo '
* <a href="', htmlspecialchars($site), '" target="right">', htmlspecialchars($name), '</a><br />';
}
echo '<br />
<a href="', $parentsite_url, 'index.php" onclick="javascript:top.location.href = \'', $parentsite_url, '\';return true;">', $parentsite_name, '</a> | 
<a href="', $mainsite_url, '" onclick="javascript:top.location.href = \'', $mainsite_url, '\';return true;">', $mainsite_name, '</a>';
?>
</span>
</p>
</body>
</html>