VERSION 5.00
Begin VB.Form ErrorMessage 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Error Message"
   ClientHeight    =   1665
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   6030
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1665
   ScaleWidth      =   6030
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton btnStopProgram 
      Caption         =   "Stop Program"
      Height          =   375
      Left            =   4680
      TabIndex        =   4
      Top             =   600
      Width           =   1215
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   120
      Top             =   1320
   End
   Begin VB.CommandButton ExitButton 
      Caption         =   "Exit/Shutdown"
      Height          =   375
      Left            =   4680
      TabIndex        =   1
      Top             =   1080
      Width           =   1215
   End
   Begin VB.CommandButton ContinueButton 
      Caption         =   "Continue"
      Default         =   -1  'True
      Height          =   375
      Left            =   4680
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label TimeoutLabel 
      Caption         =   "Press a button to continue or exit."
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   1080
      Width           =   4335
   End
   Begin VB.Label ErrorMessageLabel 
      Caption         =   "An error was encountered with the Inkjet Arrayer program."
      Height          =   735
      Left            =   240
      TabIndex        =   2
      Top             =   240
      Width           =   4095
   End
End
Attribute VB_Name = "ErrorMessage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'ErrorMessage form.
'------------------
'   Copyright (C) 2004  The Institute for Systems Biology
'   For license information, read Copying.txt
'
'This object allows Arrayer to display and log errors.
'It includes a Timeout feature that allows inkjet synthesis to
'continue if the error is not critical.  A Timeout of zero
'seconds means infinity, or no timeout.  This form must be used
'with MainFrm, which has a checkbox that can turn on/off the
'inert gas flow.  When an error is displayed with no timeout,
'the inert gas flow is stopped.
'Modified by Chris Lausted (09/15/2003) for v0.8.0

Option Base 1

Private sglDuration As Single
Private sglStart As Single
Private iChkDryerValue As Integer
Private bNoTimeOut As Boolean



Public Sub Display(strMessage As String, sglTimeout As Single)
    'Use this sub like MsgBox, but with a timeout feature.
    'Show dialog box and prepare a timer.
    'Timer1 object is used to update status of my timer variables and display.
    Dim txt As String
    Dim fnum As Integer
    
    'Show error message on a modal dialog box.
    ErrorMessage.ErrorMessageLabel.Caption = strMessage
    
    'Enable Stop Program button if a script is being run.
    btnStopProgram.Visible = Not (MainFrm.progDone)
    
    'Setup timeout, if desired.
    'For no timeout, use zero value.
    If (sglTimeout <= 0) Then sglTimeout = 0
    If (sglTimeout > 600) Then sglTimeout = 600
    If sglTimeout > 0 Then
        ErrorMessage.Timer1.Enabled = True
        sglStart = Timer
        sglDuration = sglTimeout
        txt = "This dialog box will timeout in " & Format(sglDuration, "0") & " seconds."
        ErrorMessage.TimeoutLabel.Caption = txt
    End If
    
    'Shut off inert gas?
    If (sglTimeout = 0) Then
        bNoTimeOut = True
        iChkDryerValue = MainFrm.chkDryerOn.value
        MainFrm.chkDryerOn.value = vbUnchecked
        MainFrm.chkDryerOn_Click
        MainFrm.chkDryerOn.Refresh
    Else
        bNoTimeOut = False
    End If
    
    'Error log.
    ErrorMessage.Log (strMessage)
    
    'Show error message dialog box.
    ErrorMessage.Show vbModal
End Sub


Public Sub Log(strMessage As String)
    Dim fnum As Integer
    fnum = FreeFile
    Open "InkjetErrorLog.txt" For Append As #fnum
    Write #fnum, strMessage & " at " & Format(Now, "d-mmm h:mm:ss")
    Close #fnum
End Sub



Private Sub Timer1_Timer()
    Dim remain As Single
    Dim txt As String
    remain = sglStart + sglDuration - Timer
    txt = "This dialogbox will timeout in " & Format(remain, "0") & " seconds."
    TimeoutLabel.Caption = txt
    ErrorMessage.Refresh
    If remain < 0 Then ContinueButton_Click
End Sub


Private Sub ContinueButton_Click()
    'Restore the default messages on this dialog box.  Unimportant.
    ErrorMessageLabel.Caption = "An error was encountered with the Inkjet Arrayer program."
    TimeoutLabel.Caption = "Press a button to continue or exit."
    'Shut the timer off.
    Timer1.Enabled = False
    'Restore state of inert gas valve.
    If (bNoTimeOut) Then
        MainFrm.chkDryerOn.value = iChkDryerValue
        MainFrm.chkDryerOn_Click
        MainFrm.chkDryerOn.Refresh
    End If
    'Dismiss this box.
    ErrorMessage.Hide
End Sub


Private Sub btnStopProgram_Click()
    'Stop execution of script but keep ArrayerX running.
    MainFrm.progDone = True
    ErrorMessageLabel.Caption = "An error was encountered with the Inkjet Arrayer program."
    TimeoutLabel.Caption = "Press a button to continue or exit."
    Timer1.Enabled = False
    ErrorMessage.Hide
End Sub


Private Sub ExitButton_Click()
    'Stop everything and quit ArrayerX.
    ErrorMessageLabel.Caption = "An error was encountered with the Inkjet Arrayer program."
    TimeoutLabel.Caption = "Press a button to continue or exit."
    Timer1.Enabled = False
    If (MsgBox("Are you sure you want to quit?", vbYesNo) = vbYes) Then End
End Sub

