VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Inkjet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'The Inkjet class.
'This class requires use of the ErrorMessage class.

'   Copyright (C) 2004  The Institute for Systems Biology
'   For license information, read Copying.txt
'

Option Base 1

'DECLARATIONS FOR THE INKJET CLASS.
'Declare static port output functions.
Private Declare Function DIG_Prt_Config Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal PORT As Integer, ByVal mode As Integer, _
    ByVal dir As Integer) As Integer
Private Declare Function DIG_Out_Line Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal PORT As Integer, ByVal line As Integer, _
    ByVal state As Integer) As Integer
Private Declare Function DIG_Out_Prt Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal PORT As Integer, ByVal TPATTERN As Long) _
    As Integer
'Declare port group and pattern generation output functions.
Private Declare Function DIG_Block_Clear Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer) As Integer
Private Declare Function DIG_Grp_Config Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer, ByVal GROUPSIZE As Integer, _
    ByVal PORT As Integer, ByVal dir As Integer) As Integer
Private Declare Function DIG_Out_Grp Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer, ByVal groupPattern _
    As Integer) As Integer
Private Declare Function DIG_Block_PG_Config Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer, ByVal config As Integer, _
    ByVal reqSource As Integer, ByVal TIMEBASE As Integer, ByVal _
    reqInterval As Integer, ByVal EXTERNALGATE As Integer) As Integer
Private Declare Function DIG_Block_Out Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer, ByRef buffer As Integer, ByVal _
    count As Long) As Integer
Private Declare Function DIG_Block_Check Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer, ByRef remaining As Long) As Integer
'Declare trigger functions now necessary for Fire on the Fly.
Private Declare Function DIG_Trigger_Config Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer, ByVal STARTTRIG As Integer, _
    ByVal STARTPOL As Integer, ByVal STOPTRIG As Integer, ByVal STOPPOL As Integer, _
    ByVal PTSAFTERSTOP As Long, ByVal TPATTERN As Long, ByVal PATTERNMASK As Long) As Integer
Private Declare Function Align_DMA_Buffer Lib "nidaq32.dll" _
    (ByVal DEV As Integer, ByVal GROUP As Integer, ByRef buffer As Integer, ByVal _
    count As Long, ByVal buffersize As Long, ByRef alignIndex As Integer) As Integer


'Test mode (only used by developers) normally false.
Private Const TESTMODE As Boolean = True
'Static port output constants.
Private Const DEV As Integer = 1 'DIO-32HS.
Private Const PORT As Integer = 2 'Port C.
Private Const OUTPUTPRT As Integer = 1
Private Const NOHSHAKE As Integer = 0
Private Const LO As Integer = 0
Private Const HI As Integer = 1
'Port group and patterned output constants
Private Const GROUP As Integer = 1 'There can be two groups of IO ports.
Private Const GROUPSIZE As Integer = 2 'Two ports or 16 bits.
Private Const GROUPPORTS As Integer = 2 'Ports C and D are in group 1.
Private Const ENABLEPG As Integer = 1 'Enable pattern generation using request-edge latching.
Private Const DISABLEPG As Integer = 0
Private Const REQSOURCEINTCLK As Integer = 0 'Internal clock.
Private Const REQSOURCEAUTO As Integer = 2 'Internal clock.
Private Const TIMEBASE As Integer = -3 '50ns clock.
Private Const REQINTERVALFAST As Integer = 20 'Make interval 1 microseconds or 1MHz.
Private Const REQINTERVALSLOW As Integer = 2000 'Make interval 100 microseconds or 10kHz.
Private Const EXTERNALGATE As Integer = 0 'Never used.
'Trigger constants.
Private Const STARTTRIG As Integer = 1
Private Const NOSTARTTRIG As Integer = 0
Private Const STOPTRIG As Integer = 0
Private Const STARTPOL As Integer = 0
Private Const STOPPOL As Integer = 1
Private Const PTSAFTERSTOP As Long = 0
Private Const TPATTERN As Long = 0
Private Const PATTERNMASK As Long = 0
Private Const TRIGGERGRP As Integer = 2
'Epson interface constants.
Private Const LAT As Integer = 256
Private Const CLK As Integer = 512
Private Const SG1 As Integer = 1024
Private Const SG2 As Integer = 2048
Private Const SG3 As Integer = 4096
Private Const NCHG As Integer = 8192
Private Const WBIGSIZE As Long = 1510002
Private Const WBUFFERTEMPSIZE As Long = 415

'Globals.
Private stat As Integer
Private mboolNozzle(192) As Boolean     'Which nozzles are on.
Private wBuffer(50000) As Integer       'Buffer full of trapezoidal waveforms.
Private wBufferBig(WBIGSIZE) As Integer  'Big buffer to print whole slide off one trigger.
Private wBufferTemp(WBUFFERTEMPSIZE) As Integer
Private sw As Stopwatch

'Object constructor.
Private Sub Class_Initialize()
    Dim i As Long, j As Long
    Dim trpz As Variant 'Modified trapezoidal waveform.
    Set sw = New Stopwatch
    
    'Assign group, ports C&D.
    ReassignGroup
    stat = DIG_Out_Grp(DEV, GROUP, 0)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Out_Grp error:" & stat), 15
    
    'Turn all nozzles off.
    For i = 1 To 192: mboolNozzle(i) = False: Next i
    
    'Load buffer with pzt waveform.  This is used for startnstop printing.
    trpz = Array(0, 5, 10, 15, 20, 23, 24, 25, 25, 25, 25, 27, 27, 27, 27, 27, _
        26, 25, 24, 22, 20, 18, 16, 14, 12, 10, 8, 6, 4, 2, 1, 0.5, 0, 0, 0, 0, _
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
    For j = 1 To 50000 Step 100
        For i = 1 To 49
            wBuffer(j + i) = Int(trpz(i) * 255 / 30) '8 bits, 30 volts fs.
        Next i
    Next j
    
    'Load big buffer with pzt waveform.  This is used for fireonfly printing.
    'Put waveform at 256-305, 10256-10305, etc.
    For j = 1000 To 1500000 Step 10000
        For i = 1 To 49
            wBufferBig(j + i) = Int(trpz(i) * 255 / 30) '8 bits, 30 volts fs.
            'Next line is experimental: Double pulse!
            wBufferBig(j + i + 70) = Int(trpz(i) * 255 / 30) '8 bits, 30 volts fs.
        Next i
    Next j
    
    'Load a new (CGL 030918) temporary buffer with two pzt waveforms.
    For i = 1 To 44
        wBufferTemp(i + 255) = Int(trpz(i) * 255 / 30) '8 bits, 30 volts fs.
        wBufferTemp(i + 370) = Int(trpz(i) * 255 / 30) '8 bits, 30 volts fs.
    Next i
End Sub


'Object destructor.
Private Sub Class_Terminate()
    'Disable pattern generation.
    stat = DIG_Block_Clear(DEV, GROUP)
    stat = DIG_Block_PG_Config(DEV, GROUP, DISABLEPG, REQSOURCEAUTO, TIMEBASE, _
        REQINTERVALFAST, EXTERNALGATE)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_PG_Config error:" & stat), 15
    stat = DIG_Out_Grp(DEV, GROUP, 0)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Out_Grp error:" & stat), 15
    'Unassign group.
    stat = DIG_Grp_Config(DEV, GROUP, 0, GROUPPORTS, OUTPUTPRT)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Grp_Config error:" & stat), 15
End Sub


'Reassign group, ports C&D.
Private Sub ReassignGroup()
    stat = DIG_Block_Clear(DEV, GROUP)
    'Unassign group.
    stat = DIG_Grp_Config(DEV, GROUP, 0, GROUPPORTS, OUTPUTPRT)
    If (stat <> 0 And stat <> -10412) Then ErrorMessage.Display ("DIG_Grp_Config error:" & stat), 15
    'Assign group, ports C&D.
    stat = DIG_Grp_Config(DEV, GROUP, GROUPSIZE, GROUPPORTS, OUTPUTPRT)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Grp_Config error:" & stat), 15
End Sub


'---------------------------------------------
'Subroutines used for Start and Stop Printing.
'---------------------------------------------

Private Sub SelectPztJets()
    'This sub called at beginning of Spew sub.
    'Jets 1-32: Black;  33-64: Dark Cyan.
    'Jets 65-96: Light Cyan;  97-128: Dark Magenta.
    'Jets 129-160: Light Magenta;  161-192: Yellow.
    Dim i As Integer, j As Integer, pulse As Integer
    Dim cnt As Long, remaining As Long
    Dim buffer(500) As Integer
    
    'Load a buffer with the digital output that selects nozzles.
    cnt = 1
    buffer(cnt) = NCHG: cnt = cnt + 1
    stat = DIG_Out_Grp(DEV, GROUP, 0)
    For i = 1 To 64
            pulse = (mboolNozzle(i) * SG1 * -1) + _
                (mboolNozzle(i + 64) * SG2 * -1) + (mboolNozzle(i + 128) * SG3 * -1)
            buffer(cnt) = pulse: cnt = cnt + 1
            buffer(cnt) = pulse + CLK: cnt = cnt + 1
            buffer(cnt) = 0: cnt = cnt + 1
    Next i
    buffer(cnt) = LAT: cnt = cnt + 1
    buffer(cnt) = 0
    
    'Send digital output.
    
    'Enable pattern generation.
    stat = DIG_Block_PG_Config(DEV, GROUP, ENABLEPG, REQSOURCEINTCLK, TIMEBASE, _
        REQINTERVALSLOW, EXTERNALGATE)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_PG_Config error:" & stat), 15
        
    stat = DIG_Block_Out(DEV, GROUP, buffer(1), cnt)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_Out error:" & stat), 2
    sw.Reset
    Do
        stat = DIG_Block_Check(DEV, GROUP, remaining)
        If (stat <> 0) Then
            ErrorMessage.Display ("DIG_Block_Check error:" & stat), 2
            Exit Do
        End If
        If sw.Elapsed(1) Then
            ErrorMessage.Display ("Timeout waiting for digital output."), 2
            Exit Do
        End If
    Loop Until (remaining = 0)
End Sub


Public Sub Spew(ByVal drops As Integer)
    'Use globals wBuffer, mboolNozzle.
    Dim count As Long, remaining As Long
    Dim i As Long, j As Long
    
    SelectPztJets
    If drops < 1 Then Exit Sub
    If drops > 500 Then drops = 500
    count = 100 * drops
    
    'Output piezo drive waveform.
    
    'Enable pattern generation.
    stat = DIG_Block_PG_Config(DEV, GROUP, ENABLEPG, REQSOURCEINTCLK, TIMEBASE, _
        REQINTERVALFAST, EXTERNALGATE)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_PG_Config error:" & stat), 15
    
    stat = DIG_Block_Out(DEV, GROUP, wBuffer(1), count)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_Out error:" & stat), 2
    sw.Reset
    Do
        stat = DIG_Block_Check(DEV, GROUP, remaining)
        If (stat <> 0) Then
            ErrorMessage.Display ("DIG_Block_Check error:" & stat), 2
            Exit Do
        End If
        If sw.Elapsed(1) Then
            ErrorMessage.Display ("Timeout waiting for digital output."), 2
            Exit Do
        End If
    Loop Until (remaining = 0)
End Sub


Public Sub NozzlesAllOff()
    Dim i As Integer
    For i = 1 To 192: mboolNozzle(i) = False: Next i
End Sub


Property Get Nozzle(ByVal i As Integer) As Boolean
    If (i >= 0 And i <= 192) Then Nozzle = mboolNozzle(i)
End Property


Property Let Nozzle(ByVal i As Integer, ByVal value As Boolean)
    If (i >= 0 And i <= 192) Then mboolNozzle(i) = value
End Property




'-------------------------------------
'Subroutines used for Fire on the Fly.
'-------------------------------------

Public Sub InitFireOnFlyBuffer()
    Dim i As Long, j As Long
    For i = 0 To 1490000 Step 10000
        For j = 0 To 252 Step 4
            'wBufferBig(i + j + 1) = 0
            wBufferBig(i + j + 2) = 0
            wBufferBig(i + j + 3) = CLK
            'wBufferBig(i + j + 4) = 0
        Next j
        wBufferBig(i + 258) = LAT
    Next i
End Sub


Public Sub CfgFireOnFly(ByVal noz As Integer, ByVal state As Integer, ByVal targ As Long)
    'Configure nozzles and timing for fire on the fly.
    'Configuration means loading the global wBufferBig.
    ''noz is nozzle number 1..192, where 1..32 are in Bank 1, 160..192 are in Bank 6.
    ''targ is target x-position number from 1..150, where 81..150 are array columns 1..70 for Bank 6.
    ''state is 1 on or 0 off.
    'Bank6 over top column1 of microarray is targ 1.
    'Bank1 over top column70 of microarray is targ 150.
    'Assume a 32x70 microarray.  TODO: make this flexible.
    
    'Error checking
    If (noz < 0) Or (noz > 192) Then MsgBox "Error in CfgFireOnFly: noz out of range.": Exit Sub
    If (state < 0) Or (state > 1) Then MsgBox "Error in CfgFireOnFly: state invalid.": Exit Sub
    If (targ < 1) Or (targ > 150) Then MsgBox "Error in CfgFireOnFly: targ out of range.": Exit Sub
    'Load a buffer with the digital output that selects nozzles.
    targ = (targ - 1) * 10000
    If (noz >= 1) And (noz <= 64) Then
        noz = (noz - 1) * 4
        state = state * SG1
        'wBufferBig(targ + noz + 1) = 0
        wBufferBig(targ + noz + 2) = (state Or wBufferBig(targ + noz + 2))
        wBufferBig(targ + noz + 3) = (state Or wBufferBig(targ + noz + 3))
        'wBufferBig(targ + noz + 4) = 0
    ElseIf (noz >= 65) And (noz <= 128) Then
        noz = (noz - 65) * 4
        state = state * SG2
        'wBufferBig(targ + noz + 1) = 0
        wBufferBig(targ + noz + 2) = (state Or wBufferBig(targ + noz + 2))
        wBufferBig(targ + noz + 3) = (state Or wBufferBig(targ + noz + 3))
        'wBufferBig(targ + noz + 4) = 0
    ElseIf (noz >= 129) And (noz <= 192) Then
        noz = (noz - 129) * 4
        state = state * SG3
        'wBufferBig(targ + noz + 1) = 0
        wBufferBig(targ + noz + 2) = (state Or wBufferBig(targ + noz + 2))
        wBufferBig(targ + noz + 3) = (state Or wBufferBig(targ + noz + 3))
        'wBufferBig(targ + noz + 4) = 0
    End If
End Sub


Public Sub StartTriggeredDigitalOutput()
    'Deprecated CGL 030918.
    'Use this after using CfgFireOnFly.
    Dim remaining As Long, cnts As Long
    Dim alignIdx As Integer
    'Begin the real subroutine.
    cnts = WBIGSIZE
    'Enable pattern generation.
    stat = DIG_Block_Clear(DEV, GROUP)
    stat = DIG_Block_PG_Config(DEV, GROUP, ENABLEPG, REQSOURCEINTCLK, TIMEBASE, _
        REQINTERVALFAST, EXTERNALGATE)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_PG_Config error:" & stat), 2
    'Set trigger.
    stat = DIG_Trigger_Config(DEV, GROUP, STARTTRIG, STARTPOL, STOPTRIG, _
        STOPPOL, PTSAFTERSTOP, TPATTERN, PATTERNMASK)
    If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Trigger_Config error:" & stat), 0
    'Output waveform
    stat = DIG_Block_Out(DEV, GROUP, wBufferBig(1), cnts) 'cnts->1510000
    If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Block_Out error:" & stat), 0
End Sub

Public Sub CfgTriggeredOutput()
    'Use this after using CfgFireOnFly.
    'Set the trigger, but don't specify where the spew data is.
    'Added CGL 030918.
    'Enable pattern generation.
    stat = DIG_Block_Clear(DEV, GROUP)
    stat = DIG_Block_PG_Config(DEV, GROUP, ENABLEPG, REQSOURCEINTCLK, TIMEBASE, _
        REQINTERVALFAST, EXTERNALGATE)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_PG_Config error:" & stat), 2
End Sub

Public Sub SetTriggered(i As Long)
    'Specify waveform corresponding to ith column to spew (0-149).
    Dim j As Long
    'Error checking.
    If (i < 0 Or i > 149) Then
        ErrorMessage.Display "Error in Inkjet:SetTriggered.", 0
        Exit Sub
    End If
    'This DIG_Block_Clear should be redundant.
    Rem stat = DIG_Block_Clear(DEV, GROUP)
    'Set the triggering mechanism.  Can it go in CfgTriggeredOutput?
    stat = DIG_Trigger_Config(DEV, GROUP, STARTTRIG, STARTPOL, STOPTRIG, _
        STOPPOL, PTSAFTERSTOP, TPATTERN, PATTERNMASK)
    If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Trigger_Config error:" & stat), 0
    'Copy a spew event from wBufferBig to wBufferTemp based on index.
    Rem For j = 1 To 256: wBufferTemp(j) = wBufferBig(i * 10000 + j): Next j
    Rem stat = DIG_Block_Out(DEV, GROUP, wBufferTemp(1), 300) 'cnts=300-415.
    stat = DIG_Block_Out(DEV, GROUP, wBufferBig(i * 10000 + 1), 1119) 'cnts=1049.
    If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Block_Out error:" & stat), 0
End Sub

Public Function HasBeenTriggered() As Boolean
    Dim remaining As Long
    stat = DIG_Block_Check(DEV, GROUP, remaining)
    If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Block_Check error:" & stat), 0
    If (remaining > 0) Then
        HasBeenTriggered = False
    Else
        HasBeenTriggered = True
    End If
    Rem MainFrm.lblStatus.Caption = remaining
    Rem MainFrm.lblStatus.Refresh
End Function

Public Sub EndTriggeredOutput()
    'This DIG_Block_Clear should be redundant.
    stat = DIG_Block_Clear(DEV, GROUP)
    'Disable trigger.
    stat = DIG_Trigger_Config(DEV, GROUP, NOSTARTTRIG, STARTPOL, STOPTRIG, _
        STOPPOL, PTSAFTERSTOP, TPATTERN, PATTERNMASK)
    If (stat <> 0) Then ErrorMessage.Display ("Triggered DIG_Trigger_Config error:" & stat), 0
    'Disable pattern generation.
    stat = DIG_Block_PG_Config(DEV, GROUP, DISABLEPG, REQSOURCEAUTO, TIMEBASE, _
        REQINTERVALFAST, EXTERNALGATE)
    If (stat <> 0) Then ErrorMessage.Display ("DIG_Block_PG_Config error:" & stat), 2
    'Reassign group.
    ReassignGroup
End Sub
