VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MIO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'The MIO class.
'This class requires use of the ErrorMessage.

'   Copyright (C) 2004  The Institute for Systems Biology
'   For license information, read Copying.txt
'

Option Base 1

'DECLARATIONS FOR THE MIO (Multifunction Input/Output board) CLASS.
Private Declare Function DIG_Prt_Config Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal mode As Integer, _
    ByVal dir As Integer) As Integer
Private Declare Function DIG_Line_Config Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal line As Integer, _
    ByVal dir As Integer) As Integer
Private Declare Function DIG_Out_Line Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal line As Integer, _
    ByVal state As Integer) As Integer
Private Declare Function DIG_In_Line Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal line As Integer, _
    ByRef state As Integer) As Integer
Private Declare Function DIG_In_Prt Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByRef pattern As Long) _
    As Integer
Private Declare Function DIG_Out_Prt Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal pattern As Long) _
    As Integer
Private Declare Function WFM_Op Lib "nidaq32.dll" (ByVal DEV As Integer, _
    ByVal numChans As Integer, ByRef chanVect As Integer, _
    ByRef buffer As Integer, ByVal count As Long, _
    ByVal iterations As Long, ByVal rate As Double) As Integer
Private Declare Function AO_Write Lib "nidaq32.dll" (ByVal DEV As Integer, _
    ByVal chan As Integer, ByVal value As Integer) As Integer
Private Declare Function AI_Read Lib "nidaq32.dll" (ByVal DEV As Integer, _
    ByVal chan As Integer, ByVal gain As Integer, ByRef reading As Integer) _
    As Integer

Private Const DEV As Integer = 2        'National Instruments MIO-16E.
Private Const PORT As Integer = 0       'Only one DIO port on this board.
Private Const INPUTPRT As Integer = 0
Private Const OUTPUTPRT As Integer = 1
Private Const BIDIRECTIONALPRT As Integer = 2
Private Const NOHSHAKE As Integer = 0
Private Const AOCHAN As Integer = 0     'Only one analog output port.
Private Const INTN2JET As Integer = 0   'N2 jet is on line zero of output port.
Private Const RELAY4 As Integer = 4     'This is a 120VAC solid state relay.
Private Const RELAY5 As Integer = 5     'This is a 120VAC solid state relay.
Private Const PRESSURIZER As Integer = 1   'Phosphoramidite pressure is line one.
Private Const RESETDD As Integer = 6
Private Const READDD As Integer = 7

Private stat As Integer
Private sw As Stopwatch
Private dblHygM As Double  'Humidity meter slope.
Private dblHygB As Double  'Humidity meter offset.


'Object constructor.
Private Sub Class_Initialize()
    Dim pattern As Long
    Dim i As Integer
        
    'Check if SCB-68 with relays is connected.
    stat = DIG_Prt_Config(DEV, PORT, NOHSHAKE, INPUTPRT) 'Can still set lines individually.
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Prt_Config error " & stat), 15
    stat = DIG_In_Prt(DEV, PORT, pattern)
    If ((pattern And 3) <> 0) Then MsgBox ("SCB-68 for Multifunction board might not be attached.")
    
    'Setup DIO port for bidirectional.  Set up each line.
    For i = 0 To 7
        stat = DIG_Line_Config(DEV, PORT, i, INPUTPRT)
        If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Prt error " & stat), 15
    Next i
    stat = DIG_Line_Config(DEV, PORT, INTN2JET, OUTPUTPRT)
    stat = DIG_Line_Config(DEV, PORT, PRESSURIZER, OUTPUTPRT)
    stat = DIG_Line_Config(DEV, PORT, RELAY4, OUTPUTPRT)
    stat = DIG_Line_Config(DEV, PORT, RELAY5, OUTPUTPRT)
    stat = DIG_Line_Config(DEV, PORT, RESETDD, OUTPUTPRT)
    stat = DIG_Line_Config(DEV, PORT, READDD, INPUTPRT)
    stat = ResetDropletDetector()
    
    'Test analog ouput port (unused).
    stat = AO_Write(DEV, AOCHAN, 0)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board AO_Write error " & stat), 15

    'Set default hygrometer calibration.
    dblHygM = 1
    dblHygB = 0
End Sub


'Object destructor.
Private Sub Class_Terminate()
    'Set digital lines all back to input.
    stat = DIG_Prt_Config(DEV, PORT, NOHSHAKE, INPUTPRT)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Prt_Config error " & stat), 15
End Sub



Public Sub N2JetOn()
    stat = DIG_Out_Line(DEV, PORT, INTN2JET, 1)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub

Public Sub N2JetOff()
    stat = DIG_Out_Line(DEV, PORT, INTN2JET, 0)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub


Public Sub PressureOn()
    stat = DIG_Out_Line(DEV, PORT, PRESSURIZER, 1)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub

Public Sub PressureOff()
    stat = DIG_Out_Line(DEV, PORT, PRESSURIZER, 0)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub


Public Function ResetDropletDetector() As Integer
    'Make 10 attempts to reset.
    'Return 0 if successful.
    Dim i As Integer
    ResetDropletDetector = 0
    
    For i = 1 To 10
        'Toggle low-high.
        stat = DIG_Out_Line(DEV, PORT, RESETDD, 0)
        Pause (0.001)
        stat = DIG_Out_Line(DEV, PORT, RESETDD, 1)
        If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
        Pause (0.001)
        'Check if it worked.
        If (ReadDropletDetector = False) Then Exit Function
    Next i
    'Return error code and message.
    ErrorMessage.Display ("Unable to reset droplet detector"), 15
    ResetDropletDetector = 1
End Function

Public Function ReadDropletDetector() As Boolean
    'Return boolean state of droplet detection.  True = yes.
    Dim state As Integer
    Pause (0.001)
    stat = DIG_In_Line(DEV, PORT, READDD, state)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_In_Line error " & stat), 15
    If state = 1 Then ReadDropletDetector = True Else ReadDropletDetector = False
End Function


Private Sub Pause(dblDuration As Double)
    'Wait dblDuration seconds, doing nothing.
    Dim startTime As Double
    startTime = Timer
    While (Abs(startTime - Timer) < dblDuration): Wend
End Sub


' Humidity meter functions.
' -------------------------

Property Get hygSlope() As Double
    ' Calibration slope property.
    hygSlope = dblHygM
End Property

Property Let hygSlope(ByVal m As Double)
    dblHygM = m
End Property

Property Get hygOffset() As Double
    ' Calibration offset (y-intercept) property.
    hygOffset = dblHygB
End Property

Property Let hygOffset(ByVal b As Double)
    dblHygB = b
End Property

Public Function ReadHumidity() As Double
    'Return boolean state of droplet detection.  True = yes.
    Dim volts As Double
    Dim reading As Integer
    Dim gain As Integer
    Dim channel As Integer
    reading = 0
    gain = 1
    channel = 6
    stat = AI_Read(DEV, channel, gain, reading)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board AI_Read error " & stat), 15
    volts = reading * 10 / 4096
    ReadHumidity = volts * dblHygM + dblHygB
End Function



Public Sub Relay4On()
    stat = DIG_Out_Line(DEV, PORT, RELAY4, 1)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub

Public Sub Relay4Off()
    stat = DIG_Out_Line(DEV, PORT, RELAY4, 0)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub

Public Sub Relay5On()
    stat = DIG_Out_Line(DEV, PORT, RELAY5, 1)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub

Public Sub Relay5Off()
    stat = DIG_Out_Line(DEV, PORT, RELAY5, 0)
    If (stat <> 0) Then ErrorMessage.Display ("MIO board DIG_Out_Line error " & stat), 15
End Sub


