VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form MainFrm 
   BackColor       =   &H00C0C0C0&
   Caption         =   "ISB Inkjet Arrayer"
   ClientHeight    =   9555
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   12105
   ForeColor       =   &H00000000&
   LinkTopic       =   "Form1"
   ScaleHeight     =   47.027
   ScaleMode       =   0  'User
   ScaleWidth      =   64.018
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox chkDryerOn 
      Caption         =   "Dryer On"
      Height          =   255
      Left            =   10560
      TabIndex        =   70
      Top             =   4320
      Width           =   1335
   End
   Begin VB.Timer timerHyg 
      Interval        =   10000
      Left            =   11520
      Top             =   360
   End
   Begin VB.CommandButton btnCleanHead 
      Caption         =   "Clean Head"
      Height          =   375
      Left            =   10320
      TabIndex        =   56
      Top             =   6600
      Width           =   1575
   End
   Begin VB.CommandButton btnFirstDown 
      Caption         =   "<<"
      Height          =   255
      Left            =   10440
      TabIndex        =   68
      Top             =   960
      Width           =   615
   End
   Begin VB.CommandButton btnIncrementDown 
      Caption         =   ">"
      Height          =   255
      Left            =   11160
      TabIndex        =   67
      Top             =   960
      Width           =   735
   End
   Begin VB.TextBox tbBase 
      Height          =   285
      Index           =   6
      Left            =   3480
      TabIndex        =   65
      Text            =   "N"
      Top             =   7200
      Width           =   375
   End
   Begin VB.TextBox tbBase 
      Height          =   285
      Index           =   5
      Left            =   3000
      TabIndex        =   64
      Text            =   "T"
      Top             =   7200
      Width           =   375
   End
   Begin VB.TextBox tbBase 
      Height          =   285
      Index           =   4
      Left            =   2520
      TabIndex        =   63
      Text            =   "G"
      Top             =   7200
      Width           =   375
   End
   Begin VB.TextBox tbBase 
      Height          =   285
      Index           =   3
      Left            =   2040
      TabIndex        =   62
      Text            =   "C"
      Top             =   7200
      Width           =   375
   End
   Begin VB.TextBox tbBase 
      Height          =   285
      Index           =   2
      Left            =   1560
      TabIndex        =   61
      Text            =   "A"
      Top             =   7200
      Width           =   375
   End
   Begin VB.TextBox tbBase 
      Height          =   285
      Index           =   1
      Left            =   1080
      TabIndex        =   60
      Text            =   "M"
      Top             =   7200
      Width           =   375
   End
   Begin VB.CommandButton btnMovePosition 
      Caption         =   "Move Pos..."
      Height          =   615
      Left            =   3000
      TabIndex        =   22
      Top             =   8760
      Width           =   855
   End
   Begin VB.TextBox tbDown 
      Height          =   285
      Left            =   9600
      TabIndex        =   59
      Text            =   "1"
      Top             =   960
      Width           =   735
   End
   Begin VB.CommandButton btnCenterDetector 
      Caption         =   "Center"
      Height          =   375
      Left            =   10320
      Style           =   1  'Graphical
      TabIndex        =   57
      Top             =   7560
      Width           =   1575
   End
   Begin MSComDlg.CommonDialog CommonDialog2 
      Left            =   10920
      Top             =   360
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      FilterIndex     =   1
   End
   Begin VB.CommandButton btnResetNozzles 
      Caption         =   "Reset"
      Height          =   375
      Left            =   10320
      TabIndex        =   55
      Top             =   7080
      Width           =   1575
   End
   Begin VB.CommandButton btnGetPosition 
      Caption         =   "Get Pos"
      Height          =   615
      Left            =   3000
      TabIndex        =   21
      Top             =   8040
      Width           =   855
   End
   Begin VB.CommandButton btnMoveZpFine 
      Caption         =   ">"
      Height          =   375
      Left            =   1920
      TabIndex        =   19
      Top             =   9000
      Width           =   375
   End
   Begin VB.CommandButton btnMoveYpFine 
      Caption         =   ">"
      Height          =   375
      Left            =   1920
      TabIndex        =   14
      Top             =   8520
      Width           =   375
   End
   Begin VB.CommandButton btnMoveXpFine 
      Caption         =   ">"
      Height          =   375
      Left            =   1920
      TabIndex        =   9
      Top             =   8040
      Width           =   375
   End
   Begin VB.CommandButton BtnMoveZnFine 
      Caption         =   "<"
      Height          =   375
      Left            =   720
      TabIndex        =   17
      Top             =   9000
      Width           =   375
   End
   Begin VB.CommandButton btnMoveYnFine 
      Caption         =   "<"
      Height          =   375
      Left            =   720
      TabIndex        =   12
      Top             =   8520
      Width           =   375
   End
   Begin VB.CommandButton btnMoveXnFine 
      Caption         =   "<"
      Height          =   375
      Left            =   720
      TabIndex        =   7
      Top             =   8040
      Width           =   375
   End
   Begin VB.CommandButton btnTestNozzles 
      Caption         =   "Test Nozzles"
      Height          =   375
      Left            =   10320
      TabIndex        =   54
      Top             =   6120
      Width           =   1575
   End
   Begin VB.CommandButton btnExit 
      Caption         =   "E&xit"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   11040
      TabIndex        =   53
      Top             =   5520
      Width           =   855
   End
   Begin VB.PictureBox Picture2 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      DrawWidth       =   4
      Height          =   3255
      Left            =   5880
      ScaleHeight     =   47.174
      ScaleMode       =   0  'User
      ScaleWidth      =   15.512
      TabIndex        =   52
      Top             =   6120
      Width           =   4215
   End
   Begin VB.CommandButton btnResetDD 
      Caption         =   "_"
      Height          =   203
      Left            =   10200
      Style           =   1  'Graphical
      TabIndex        =   50
      Top             =   8400
      Width           =   189
   End
   Begin VB.CommandButton btnPressure 
      BackColor       =   &H00FFFFFF&
      Caption         =   "_"
      Height          =   203
      Left            =   10200
      MaskColor       =   &H000000FF&
      TabIndex        =   35
      Top             =   8880
      UseMaskColor    =   -1  'True
      Width           =   189
   End
   Begin VB.TextBox tbSlideCount 
      Height          =   285
      Left            =   11400
      TabIndex        =   5
      Text            =   "1"
      Top             =   3000
      Width           =   495
   End
   Begin VB.CommandButton btnFireBank 
      Caption         =   "6"
      Height          =   375
      Index           =   6
      Left            =   3480
      TabIndex        =   33
      Top             =   7560
      Width           =   375
   End
   Begin VB.CommandButton btnFireBank 
      Caption         =   "5"
      Height          =   375
      Index           =   5
      Left            =   3000
      TabIndex        =   32
      Top             =   7560
      Width           =   375
   End
   Begin VB.CommandButton btnFireBank 
      Caption         =   "4"
      Height          =   375
      Index           =   4
      Left            =   2520
      TabIndex        =   31
      Top             =   7560
      Width           =   375
   End
   Begin VB.CommandButton btnFireBank 
      Caption         =   "3"
      Height          =   375
      Index           =   3
      Left            =   2040
      TabIndex        =   30
      Top             =   7560
      Width           =   375
   End
   Begin VB.CommandButton btnFireBank 
      Caption         =   "2"
      Height          =   375
      Index           =   2
      Left            =   1560
      TabIndex        =   29
      Top             =   7560
      Width           =   375
   End
   Begin VB.CommandButton btnFireBank 
      Caption         =   "1"
      Height          =   375
      Index           =   1
      Left            =   1080
      TabIndex        =   28
      Top             =   7560
      Width           =   375
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   10320
      Top             =   360
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      FilterIndex     =   1
   End
   Begin VB.CommandButton btnStopProg 
      Caption         =   "Stop Program"
      Height          =   375
      Left            =   9000
      TabIndex        =   4
      Top             =   3000
      Width           =   1335
   End
   Begin VB.CommandButton btnShowHelp 
      Caption         =   "Script Help"
      Height          =   375
      Left            =   9000
      TabIndex        =   3
      Top             =   2520
      Width           =   1335
   End
   Begin VB.CheckBox cbN2Jet 
      Caption         =   "Slide Jet On"
      Height          =   255
      Left            =   9000
      TabIndex        =   34
      Top             =   4320
      Width           =   1335
   End
   Begin VB.CommandButton BtnRunProgram 
      Caption         =   "Run Program"
      Height          =   495
      Left            =   9000
      TabIndex        =   2
      Top             =   1920
      Width           =   1335
   End
   Begin VB.CommandButton BtnOpenProgram 
      Caption         =   "Open Program"
      Height          =   495
      Left            =   9000
      TabIndex        =   1
      Top             =   1320
      Width           =   1335
   End
   Begin VB.TextBox tbProgram 
      BackColor       =   &H00FFFFC0&
      Height          =   4935
      Left            =   5880
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   44
      Top             =   960
      Width           =   2895
   End
   Begin VB.TextBox tbPump 
      Height          =   285
      Left            =   10560
      TabIndex        =   37
      Text            =   "1"
      Top             =   5160
      Width           =   1335
   End
   Begin VB.CommandButton BtnRunSolenoids 
      Caption         =   "Run Solenoid"
      Height          =   375
      Left            =   9000
      TabIndex        =   38
      Top             =   5520
      Width           =   1935
   End
   Begin VB.TextBox tbPumpDur 
      Height          =   285
      Left            =   10560
      TabIndex        =   36
      Text            =   "1.01"
      Top             =   4800
      Width           =   1335
   End
   Begin VB.CommandButton BtnMoveZn 
      Caption         =   "<<"
      Height          =   375
      Left            =   240
      TabIndex        =   16
      Top             =   9000
      Width           =   495
   End
   Begin VB.CommandButton BtnMoveZh 
      Caption         =   "Home Z"
      Height          =   375
      Left            =   1080
      TabIndex        =   18
      Top             =   9000
      Width           =   855
   End
   Begin VB.CommandButton BtnMoveZp 
      Caption         =   ">>"
      Height          =   375
      Left            =   2280
      TabIndex        =   20
      Top             =   9000
      Width           =   495
   End
   Begin VB.CommandButton BtnMoveYn 
      Caption         =   "<<"
      Height          =   375
      Left            =   240
      TabIndex        =   11
      Top             =   8520
      Width           =   495
   End
   Begin VB.CommandButton BtnMoveYh 
      Caption         =   "Home Y"
      Height          =   375
      Left            =   1080
      TabIndex        =   13
      Top             =   8520
      Width           =   855
   End
   Begin VB.CommandButton BtnMoveYp 
      Caption         =   ">>"
      Height          =   375
      Left            =   2280
      TabIndex        =   15
      Top             =   8520
      Width           =   495
   End
   Begin VB.CommandButton BtnMoveXp 
      Caption         =   ">>"
      Height          =   375
      Left            =   2280
      TabIndex        =   10
      Top             =   8040
      Width           =   495
   End
   Begin VB.CommandButton BtnMoveXh 
      Caption         =   "Home X"
      Height          =   375
      Left            =   1080
      TabIndex        =   8
      Top             =   8040
      Width           =   855
   End
   Begin VB.CommandButton BtnMoveXn 
      Caption         =   "<<"
      Height          =   375
      Left            =   240
      TabIndex        =   6
      Top             =   8040
      Width           =   495
   End
   Begin VB.CommandButton BtnSaveImage 
      Caption         =   "Save Image"
      Height          =   375
      Left            =   4080
      TabIndex        =   26
      Top             =   8520
      Width           =   1575
   End
   Begin VB.CommandButton BtnClear 
      Caption         =   "Clear"
      Height          =   375
      Left            =   4080
      TabIndex        =   25
      Top             =   8040
      Width           =   1575
   End
   Begin VB.CommandButton BtnPrint 
      Caption         =   "Print"
      Height          =   375
      Left            =   4080
      TabIndex        =   27
      Top             =   9000
      Width           =   1575
   End
   Begin VB.TextBox tbDrops 
      Height          =   285
      Left            =   5160
      TabIndex        =   23
      Text            =   "1"
      Top             =   7200
      Width           =   495
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      DrawWidth       =   3
      ForeColor       =   &H00000000&
      Height          =   6975
      Left            =   240
      MousePointer    =   2  'Cross
      ScaleHeight     =   142
      ScaleMode       =   0  'User
      ScaleWidth      =   72
      TabIndex        =   40
      Top             =   120
      Width           =   5415
   End
   Begin VB.CommandButton BtnLoadImage 
      Caption         =   "Load Image"
      Height          =   375
      Left            =   4080
      TabIndex        =   24
      Top             =   7560
      Width           =   1575
   End
   Begin VB.Label lblHyg 
      Alignment       =   1  'Right Justify
      Caption         =   "0% RH"
      ForeColor       =   &H00FFFF80&
      Height          =   255
      Left            =   10320
      TabIndex        =   69
      Top             =   120
      Width           =   1575
   End
   Begin VB.Label Label11 
      Caption         =   "Base:"
      Height          =   375
      Left            =   240
      TabIndex        =   66
      Top             =   7200
      Width           =   615
   End
   Begin VB.Label Label10 
      Caption         =   "Down:"
      Height          =   255
      Left            =   9000
      TabIndex        =   58
      Top             =   960
      Width           =   615
   End
   Begin VB.Label Label9 
      Caption         =   "Reset Droplet Detector"
      Height          =   495
      Left            =   10440
      TabIndex        =   51
      Top             =   8400
      Width           =   1455
   End
   Begin VB.Label Label8 
      Caption         =   "Phosphoramidite Pressure"
      Height          =   495
      Left            =   10440
      TabIndex        =   49
      Top             =   8880
      Width           =   1455
   End
   Begin VB.Label Label6 
      Caption         =   "Slide  count:"
      Height          =   255
      Left            =   10440
      TabIndex        =   48
      Top             =   3000
      Width           =   1095
   End
   Begin VB.Label Label7 
      Caption         =   "Fire bank:"
      Height          =   255
      Left            =   240
      TabIndex        =   47
      Top             =   7560
      Width           =   855
   End
   Begin VB.Label lblProgramCounter 
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Line: 0"
      Height          =   375
      Left            =   10440
      TabIndex        =   46
      Top             =   2520
      Width           =   1455
   End
   Begin VB.Label lblStatus 
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Status: Idle"
      Height          =   1095
      Left            =   10440
      TabIndex        =   45
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label Label5 
      Caption         =   "Solenoid Pump #:"
      Height          =   255
      Left            =   9000
      TabIndex        =   43
      Top             =   5160
      Width           =   2175
   End
   Begin VB.Label Label4 
      Caption         =   "Pump Duration (s):"
      Height          =   255
      Left            =   9000
      TabIndex        =   42
      Top             =   4800
      Width           =   2175
   End
   Begin VB.Label Label3 
      Caption         =   "Drops (1-600):"
      Height          =   255
      Left            =   4080
      TabIndex        =   41
      Top             =   7200
      Width           =   1095
   End
   Begin VB.Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "Institute for Systems Biology"
      BeginProperty Font 
         Name            =   "Times New Roman"
         Size            =   15.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800080&
      Height          =   375
      Left            =   5880
      TabIndex        =   39
      Top             =   120
      Width           =   4575
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Beta Group Inkjet Microarray Machine"
      BeginProperty Font 
         Name            =   "Times New Roman"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   5880
      TabIndex        =   0
      Top             =   480
      Width           =   5055
   End
End
Attribute VB_Name = "MainFrm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'MAINFRM: Main form for Arrayer 9.
'This form requires use of the classes:
'  ErrorMessage, HelpFrm, ImpCoor as well as
'  Inkjet, MIO, Solenoids, and Servo6k
'
'   Copyright (C) 2004  The Institute for Systems Biology
'   For license information, read Copying.txt
'
'Updated 1/27/2004
'  Some small parameter tweaks.
'  Prompt user to load config file.  Since switch to Win2K, there have been a few cases of new instances
'  of VB starting or Form_Load calls.  This may lead to old config files being accidentally loaded.
'Updated 9/15/2003 C Lausted.
'  Use new ErrorMessage timeout and inert gas shutoff.
'  New constants for maximum number of printhead passes.
'  Increase array size from 32x50 to 70x140.
'  Fix image flipping by using y2=ROWZ+1-y when viewing intArray.
'****************************************************************

Const TESTMODE As Boolean = False    'For developers use only.  Normally False.
Const SLIDEPITCH As Long = 25000    'Distance from slide to slide in the same row.
Const ROWZ As Integer = 140          'Height of microarray.  Our printhead has 32 nozzles/color.  Originally 32, now 140.
Const COLZ As Integer = 70          'This can be adjusted.  Originally 32.  Now 70.
Const DOWNZ As Integer = 100        'Max number of bases in an oligo sequence record.
Const SETTINGSFILE As String = "C:\Arrayer9.pref"
Const DEFAULTHYGSLOPE As Double = 15
Const DEFAULTHYGOFFSET As Double = -18
Const CMAXPRINTHEADPASSES As Integer = 20 'Because 140/32 = 5.
Const CACETONITRILE As Integer = 1 'Use this channel to wash after failed printing (unused).

Public servo As Servo6K     'Public because ImpCoor needs to use it.
Private ink As Inkjet
Private solenoid As Solenoids
Private multio As MIO
Private sw As Stopwatch
Private intArray(1 To COLZ, 1 To ROWZ, 1 To DOWNZ) As Integer 'Pattern to put down.
Private intPrinthead(1 To 6, 1 To ROWZ) As Integer 'Working nozzles = 1.
Private lessNozzles As Integer  'Nozzles lost before last test.
Private moreNozzles As Integer  'Nozzles back online.
Public progDone As Boolean  'So I can cancel program. Public so ErrorMessage can alter it.
Private printDone As Boolean  'So I can cancel printing.





Private Sub Form_Load()
    'Application startup.
    'Initialize global variables.
    progDone = True
    'Construct IO objects.
    Set multio = New MIO
    Set servo = New Servo6K
    Set ink = New Inkjet
    Set solenoid = New Solenoids
    Set sw = New Stopwatch
    'Setup main form GUI objects.
    Picture1.DrawWidth = 4 'Picture1 displays print pattern down.
    Picture1.ScaleHeight = ROWZ + 2
    Picture1.ScaleWidth = COLZ + 1
    Picture2.DrawWidth = 4 'Picture2 displays working nozzles.
    Picture2.ScaleHeight = 32 + 1
    Picture2.ScaleWidth = 6 + 1
    'Turn on humidity meter.
    timerHyg.Interval = 10000 '10s = 10,000ms
    timerHyg.Enabled = True
    multio.hygSlope = DEFAULTHYGSLOPE
    multio.hygOffset = DEFAULTHYGOFFSET
    'More setup.
    btnResetNozzles_Click
    Load ImpCoor
    LoadSettings
    'Be sure that the correct form is visible.
    MainFrm.Show
End Sub


Private Sub Form_Unload(Cancel As Integer)
    'Shutdown application.
    SaveSettings
    Set servo = Nothing
    Set ink = Nothing
    Set solenoid = Nothing
    Set multio = Nothing
    Set sw = Nothing
    Unload HelpFrm
    End
End Sub




'***** Script interpretation and execution *****

Private Sub BtnOpenProgram_Click()
    Dim txt As String
    Dim i As Integer
    Dim fileNumber
    i = 0
    On Error GoTo ErrHandler
    CommonDialog2.Filter = "Text scripts (*.txt)|*.txt"
    CommonDialog2.ShowOpen
    fileNumber = FreeFile
    Open CommonDialog2.FileName For Input As #fileNumber
    tbProgram.Text = ""
    Do While Not EOF(1)
        Line Input #fileNumber, txt: i = i + 1
        tbProgram.Text = tbProgram.Text & i & " " & txt & Chr(13) & Chr(10)
        txt = Parse(txt, 1)
        If Not (txt = "WASH" Or txt = "DRY" Or txt = "PRINT" Or txt = "WAIT" _
            Or txt = "SETDROPS" Or txt = "SETSOL" Or txt = "SETSLIDECOUNT" _
            Or txt = "MESSAGE" Or txt = "MOVEX" Or txt = "MOVEY" _
            Or txt = "MOVEZ" Or txt = "PUMP" Or txt = "PURGE" _
            Or txt = "CLEAN" Or txt = "SPEED" Or txt = "BLOW" _
            Or txt = "MOVEABSX" Or txt = "MOVEABSY" Or txt = "MOVEABSZ" _
            Or txt = "HOME " Or txt = "TESTNOZZLES" Or txt = "IFFSKIP" _
            Or txt = "MOVETO" Or txt = "LOOP" Or txt = "SHELL" _
            Or txt = "CHECKHEAD" Or txt = "BOXDRYER" Or txt = "REM") Then
            MsgBox "Invalid instruction in line :" & i
            Exit Do
        End If
    Loop
ErrHandler:
    'Probably the user pressed cancel
    Close #fileNumber
End Sub


Private Sub BtnRunProgram_Click()
    Dim txt1 As String, txt2 As String
    Dim spac As Integer, stat As Integer
    Dim i As Integer, n As Integer
    Dim pcnt As Integer, iDown As Integer
    Dim txtRH As String
    Dim fileNumber
    
    pcnt = 0
    iDown = CurrentDown()
    progDone = False
    timerHyg.Enabled = False
    fileNumber = FreeFile
    On Error GoTo ErrHandler
    'Get name of script to execute and open it.
    CommonDialog2.Filter = "Text scripts (*.txt)|*.txt"
    CommonDialog2.ShowOpen
    Open CommonDialog2.FileName For Input As #fileNumber
    Screen.MousePointer = vbHourglass
    'Get point at which to begin.
    pcnt = Val(InputBox("Start execution at which line?", , "1"))
    If (pcnt < 1) Then MsgBox "Program cancelled.": GoTo ErrHandler
    For i = 2 To pcnt
        Line Input #fileNumber, txt1
        If EOF(fileNumber) Then Exit For
    Next i
    
    Do While Not EOF(fileNumber) And Not progDone
        'Get command, txt1, and parameter, txt2.
        Line Input #fileNumber, txt1
        txt2 = Parse(txt1, 2)
        txt1 = Parse(txt1, 1)
        'Display a program counter.
        lblProgramCounter.Caption = "Line: " & Str(pcnt)
        MainFrm.Refresh
        pcnt = pcnt + 1
        'Execute the command
        If (txt1 = "WASH") Then
            ProgWash (txt2)
        ElseIf (txt1 = "DRY") Then
            ProgDry (txt2)
        ElseIf (txt1 = "PRINT") Then
            ProgPrint (txt2)
        ElseIf (txt1 = "WAIT") Then
            ProgWait (txt2)
        ElseIf (txt1 = "SETDROPS") Then
            tbDrops.Text = Str(Val(txt2)): MainFrm.Refresh
        ElseIf (txt1 = "SETSOL") Then
            tbPumpDur.Text = Str(Val(txt2)): MainFrm.Refresh
        ElseIf (txt1 = "SETSLIDECOUNT") Then
            tbSlideCount.Text = Str(Val(txt2)): MainFrm.Refresh
        ElseIf (txt1 = "MESSAGE") Then
            MsgBox txt2: MainFrm.Refresh
        ElseIf (txt1 = "MOVEX") Then
            servo.MoveX (Val(txt2))
        ElseIf (txt1 = "MOVEY") Then
            servo.MoveY (Val(txt2))
        ElseIf (txt1 = "MOVEZ") Then
            servo.MoveZ (Val(txt2))
        ElseIf (txt1 = "PUMP") Then
            stat = solenoid.Pump(Val(txt2), Val(tbPumpDur.Text))
        ElseIf (txt1 = "PURGE") Then
            ProgPurge (txt2)
        ElseIf (txt1 = "CLEAN") Then
            ProgClean (txt2)
        ElseIf (txt1 = "SPEED") Then
            servo.SetVelocity (txt2)
        ElseIf (txt1 = "BLOW") Then
            ProgBlow (txt2)
        ElseIf (txt1 = "MOVEABSX") Then
            servo.MoveAbsX (Val(txt2))
        ElseIf (txt1 = "MOVEABSY") Then
            servo.MoveAbsY (Val(txt2))
        ElseIf (txt1 = "MOVEABSZ") Then
            servo.MoveAbsZ (Val(txt2))
        ElseIf (txt1 = "HOME") Then
            If (txt2 = "X") Then servo.HomeX
            If (txt2 = "Y") Then servo.HomeY
            If (txt2 = "Z") Then servo.HomeZ
        ElseIf (txt1 = "MOVETO") Then
            ImpCoor.GoToPosition (Val(txt2))
        ElseIf (txt1 = "TESTNOZZLES") Then
            TestNozzles (Int(Val(txt2)))
        ElseIf (txt1 = "IFFSKIP") Then
            'If no new nozzle failures skip lines.
            If (lessNozzles > 0) Then txt2 = "0"
            For i = 1 To Int(Val(txt2))
                Line Input #fileNumber, txt1
                pcnt = pcnt + 1
                If EOF(fileNumber) Then Exit For
            Next i
        ElseIf (txt1 = "SHELL") Then
            ProgShell (txt2)
        ElseIf (txt1 = "CHECKHEAD") Then
            ProgCheckHead (txt2)
        ElseIf (txt1 = "BOXDRYER") Then
            ProgBoxDryer (txt2)
        ElseIf (txt1 = "LOOP") Then
            'Repeat until down > txt2.
            'Increment down global variable and picture box.
            iDown = iDown + 1
            btnIncrementDown_Click
            ErrorMessage.Log "Incrementing to down " & iDown
            txtRH = Format(multio.ReadHumidity, "0.0") & "%"
            ErrorMessage.Log "Humidity " & txtRH
            lblHyg.Caption = txtRH
            'Reset file pointer in script file by reopening.
            If (iDown <= Val(txt2)) Then
                'Reset file line number and program counter.
                Close #fileNumber
                Open CommonDialog2.FileName For Input As #fileNumber
                pcnt = 1
            End If
        ElseIf (txt1 = "REM") Then
            Rem Remark.  Do nothing.
        Else
            MsgBox "Invalid instruction: " & txt1
        End If
    Loop
ErrHandler:
    'Probably the user pressed cancel
    Close #fileNumber
    timerHyg.Enabled = True
    Screen.MousePointer = vbDefault
End Sub


Private Function Parse(ByVal strString As String, ByVal iWord As Integer) As String
    'Get command, 1st word, or parameter, second word.
    Dim iSpace As Integer, iLength As Integer
    
    iSpace = InStr(strString, " ")
    iLength = Len(strString)
    If (iWord = 2) Then
        Parse = Trim(Right(strString, (iLength - iSpace)))
    Else
        If (iSpace = 0) Then iSpace = iLength
        Parse = Trim(Left(strString, iSpace))
    End If
End Function


Private Sub ProgPrint(ByVal sFileName As String)
    'Print the designated file onto slide or slides.
    'If sFileName is "Default" then use the pattern already loaded.
    'If sFileName is "Bank1" thru "Bank6" then print only from that bank.
    Dim sc As Integer, i As Integer, iPattern As Integer
    
    sc = Int(Val(tbSlideCount.Text))
    If (sc < 1 Or sc > 9) Then sc = 1
    lblStatus.Caption = "Inkjet Printing": lblStatus.Refresh
    If (sFileName = "DEFAULT" Or sFileName = "Default" Or sFileName = "default") Then
        iPattern = 0
    ElseIf (sFileName = "Bank1" Or sFileName = "bank1") Then
        iPattern = 1
    ElseIf (sFileName = "Bank2" Or sFileName = "bank2") Then
        iPattern = 2
    ElseIf (sFileName = "Bank3" Or sFileName = "bank3") Then
        iPattern = 3
    ElseIf (sFileName = "Bank4" Or sFileName = "bank4") Then
        iPattern = 4
    ElseIf (sFileName = "Bank5" Or sFileName = "bank5") Then
        iPattern = 5
    ElseIf (sFileName = "Bank6" Or sFileName = "bank6") Then
        iPattern = 6
    ElseIf (sFileName = "Bank12" Or sFileName = "bank12") Then
        iPattern = 12
    ElseIf (sFileName = "Default-1" Or sFileName = "default-1") Then
        iPattern = 20 'TODO: make this more consistent.
    ElseIf (sFileName = "Default-2" Or sFileName = "default-2") Then
        iPattern = 21 'TODO: make this more consistent.
    ElseIf (sFileName = "Default-12" Or sFileName = "default-12") Then
        iPattern = 22 'TODO: make this more consistent.
    Else
        LoadImage (sFileName)
        iPattern = 0
    End If
    
    For i = 1 To sc
        If iPattern = 20 Then
            PrintPatternOrCatalyst 0
            If Not progDone Then PrintPatternOrCatalyst 1
        ElseIf iPattern = 21 Then
            PrintPatternOrCatalyst 0
            If Not progDone Then PrintPatternOrCatalyst 2
        ElseIf iPattern = 22 Then
            PrintPatternOrCatalyst 0
            If Not progDone Then PrintPatternOrCatalyst 12
        Else
            PrintPatternOrCatalyst iPattern
        End If
        
        If i < sc Then servo.MoveX (-SLIDEPITCH)
        If progDone Then Exit For
    Next i
    servo.MoveX (SLIDEPITCH * (sc - 1))
    lblStatus.Caption = "Status: Idle": MainFrm.Refresh
End Sub


Private Sub ProgWash(ByVal sPump As String)
    'Use pump (1..6) to wash slide or slides.
    Dim stat As Integer, iPump As Integer
    Dim sc As Integer, i As Integer
    Dim xOffset, yOffset, xPumpPitch
    xOffset = 116315 + 2000 'Distance from printhead to teflon nozzle.
    yOffset = 28885
    xPumpPitch = 7517 'Distance between teflon nozzles.
    'Check parameters.
    sc = Int(Val(tbSlideCount.Text))
    If (sc < 1 Or sc > 9) Then sc = 1
    iPump = Val(sPump)
    If (iPump < 1 Or iPump > 6) Then Exit Sub
    'Move wash head into position.
    tbPump.Text = sPump: tbPump.Refresh
    lblStatus.Caption = "Washing...": lblStatus.Refresh
    servo.MoveX (xOffset - xPumpPitch * (iPump - 1))
    servo.MoveY (-yOffset)
    'Pump liquid through wash nozzle onto each slide.
    For i = 1 To sc
        stat = solenoid.Pump(iPump, Val(tbPumpDur.Text)) 'Run Solenoids pump.
        If i < sc Then servo.MoveX (-SLIDEPITCH)
    Next i
    servo.MoveX (SLIDEPITCH * (sc - 1))
    'Move back to starting position.
    servo.MoveY (yOffset)
    servo.MoveX (-(xOffset - xPumpPitch * (iPump - 1)))
    lblStatus.Caption = "Status: Idle": MainFrm.Refresh
End Sub


Private Sub ProgDry(ByVal sMode As String)
    'Dry slides from right to left.
    If (Val(sMode) = 1) Then
        ProgDryPoint
    Else
        ProgDryManifold
    End If
End Sub
Private Sub ProgDryPoint()
    Dim sc As Long
    Dim i As Integer, j As Integer
    'Check parameters.
    sc = Int(Val(tbSlideCount.Text))
    If (sc < 1 Or sc > 9) Then sc = 1
    'Move dryer nozzle into position.
    lblStatus.Caption = "Drying...": lblStatus.Refresh
    servo.MoveX (22000)
    multio.N2JetOn
    'Drying motion.
    For i = 1 To sc
        For j = 1 To 5
            servo.MoveY (-48000)
            servo.MoveY (48000)
            servo.MoveX (-Int(SLIDEPITCH * 0.2)) '25000/5=5000.
        Next j
    Next i
    'Move back to starting position.
    multio.N2JetOff
    servo.MoveX ((SLIDEPITCH * sc) - (22000))
    lblStatus.Caption = "Status: Idle": MainFrm.Refresh
End Sub
Private Sub ProgDryManifold()
    'Use a manifold for drying.
    Dim sc As Long
    Dim i As Integer, j As Integer
    
    'Check parameters.
    sc = Int(Val(tbSlideCount.Text))
    If (sc < 1 Or sc > 9) Then sc = 1
    
    lblStatus.Caption = "Drying...": lblStatus.Refresh
    Rem servo.MoveY (2000)
    servo.MoveX (5.7 * 20000)
    multio.N2JetOn
    servo.SetVelocity (20)
    
    For i = 1 To sc
        For j = 1 To 1
            servo.MoveY (32000): servo.MoveX (-5000)
            servo.MoveY (-32000)
            servo.MoveY (32000): servo.MoveX (-5000)
            servo.MoveY (-32000): servo.MoveX (-5000)
            servo.MoveY (32000): servo.MoveX (-5000)
            servo.MoveY (-32000): servo.MoveX (-5000)
        Next j
    Next i
    
    multio.N2JetOff
    servo.SetVelocity (0)
    servo.MoveX ((sc * 4 * 6250) - (5.7 * 20000))
    Rem servo.MoveY (-2000)
    lblStatus.Caption = "Status: Idle": MainFrm.Refresh
End Sub


Private Sub ProgWait(ByVal sTime As String)
    'Wait sTime seconds, doing nothing.
    'Setting progDone true breaks out of this loop.
    sw.Reset
    lblStatus.Caption = "Waiting...": lblStatus.Refresh
    While (sw.Elapsed(Val(sTime)) = False And progDone = False)
        DoEvents
    Wend
    lblStatus.Caption = "Status: Idle": MainFrm.Refresh
End Sub


Private Sub ProgPurge(ByVal sBanks As String)
    Dim iBanks As Integer, i As Integer
    iBanks = Int(Val(sBanks))
    If (iBanks < 1 Or iBanks > 6) Then iBanks = 6
    lblStatus.Caption = "Purging " & iBanks & " banks."
    lblStatus.Refresh
    ink.NozzlesAllOff
    For i = 1 To (iBanks * 32): ink.Nozzle(i) = True: Next i
    For i = 1 To 1: ink.Spew (100): Next i
    Beep
    lblStatus.Caption = "Status: Idle": MainFrm.Refresh
End Sub


Private Sub ProgClean(ByVal sTime As String)
    'This subroutine has been deprecated!  See ProgCheckHead.
    'Turn a solenoid on for sTime.
    Dim dDuration As Double
    dDuration = Val(sTime)
    If (dDuration <= 0 Or dDuration > 10) Then Exit Sub
    multio.PressureOn
    sw.Reset
    While (sw.Elapsed(dDuration) = False): Wend
    multio.PressureOff
    Beep
End Sub


Private Sub ProgCheckHead(ByVal sBanks As String)
    'Test and fix nozzles.  After 5 attempts, fail.
    'If any bank has 8 failures, or total 16 failures, clean.
    Dim i As Integer, x As Integer, y As Integer
    Dim bankFail As Integer, totalFail As Integer
    Dim headOK As Boolean
    For i = 1 To 5
        'Test nozzles.
        ImpCoor.GoToPosition (1)
        TestNozzles (sBanks)
        'Count failures.
        headOK = True
        totalFail = 0
        For x = 1 To 6
            bankFail = 0
            For y = 1 To ROWZ
                If (intPrinthead(x, y) <> 1) Then bankFail = bankFail + 1: totalFail = totalFail + 1
            Next y
            If (bankFail > 7) Then headOK = False
        Next x
        If (totalFail > 15) Then headOK = False
        'If headOK Then Exit Sub
        ErrorMessage.Display "Cleaning of the printhead is necessary.", 2
        If i = 3 Then Exit For
        'Clean.
        multio.PressureOn
        sw.Reset
        While (sw.Elapsed(0.03) = False): Wend
        multio.PressureOff
        btnCleanHead_Click
    Next i
    ErrorMessage.Display "Unable to clean the printhead", 0
End Sub


Private Sub ProgShell(ByVal sCommand As String)
    'Send a command to the shell.
    'For example, send >FTP -S:C:\MyFtpScript.txt
    'Where MyFtpScript.txt is
    '  open mangrove.umd.edu
    '  lausted
    '  password
    '  cd public_html
    '  put c:\ErrorLog.txt
    '  bye
    Dim stat
    stat = Shell(sCommand, vbMinimizedNoFocus)
End Sub


Private Sub ProgBlow(ByVal sState As String)
    Select Case sState
    Case "ON", "On", "on"
        multio.N2JetOn
        cbN2Jet.value = 1
    Case "OFF", "Off", "off"
        multio.N2JetOff
        cbN2Jet.value = 0
    End Select
    cbN2Jet.Refresh
End Sub


Private Sub ProgBoxDryer(ByVal sState As String)
    Select Case sState
    Case "ON", "On", "on"
        multio.Relay5On
        chkDryerOn.value = 1
    Case "OFF", "Off", "off"
        multio.Relay5Off
        chkDryerOn.value = 0
    End Select
    chkDryerOn.Refresh
End Sub


Private Sub btnStopProg_Click()
    progDone = True
    printDone = True
End Sub


'***** Manual motion ******

Private Sub BtnMoveXh_Click()
    Screen.MousePointer = vbHourglass
    servo.HomeX
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveXn_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveX (-4000)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveXnFine_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveX (-500)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveXp_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveX (4000)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveXpFine_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveX (500)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveYh_Click()
    Screen.MousePointer = vbHourglass
    servo.HomeY
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveYn_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveY (-4000)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveYnFine_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveY (-500)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveYp_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveY (4000)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveYpFine_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveY (500)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveZh_Click()
    Screen.MousePointer = vbHourglass
    servo.HomeZ
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveZn_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveZ (-1000)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveZnFine_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveZ (-125)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveZp_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveZ (4000)
    Screen.MousePointer = vbDefault
End Sub
Private Sub BtnMoveZpFine_Click()
    Screen.MousePointer = vbHourglass
    servo.MoveZ (125)
    Screen.MousePointer = vbDefault
End Sub



'***** Print down image loading and displaying *****

Private Sub BtnClear_Click()
    Dim x As Integer, y As Integer, z As Integer
    For x = 1 To COLZ
        For y = 1 To ROWZ
            For z = 1 To DOWNZ
                intArray(x, y, z) = 0
            Next z
            Picture1.PSet (x, y), 0
        Next y
    Next x
End Sub


Private Sub Picture1_MouseDown(btn As Integer, shft As Integer, x As Single, y As Single)
    'This sub allows editing of the picture box.
    'Additionally, intArray is kept sync'd with the picture box.
    Dim z As Integer, y2 As Integer
    z = CurrentDown()
    x = Int(x + 0.5): y = Int(y + 0.5)
    If (x < 1) Then x = 1 Else If (x > COLZ) Then x = COLZ
    If (y < 1) Then y = 1 Else If (y > ROWZ) Then y = ROWZ
    y2 = ROWZ + 1 - y 'New! Flip the displayed image 9/15/2003.
    intArray(x, y2, z) = intArray(x, y2, z) + 1
    If (intArray(x, y2, z) > 6) Then intArray(x, y2, z) = 0
    If (btn = 2) Then intArray(x, y2, z) = 0
    Picture1.PSet (x, y), QBColor(intArray(x, y2, z))
End Sub


Private Sub BtnLoadImage_Click()
    CommonDialog1.DefaultExt = ".csv"
    CommonDialog1.Filter = "Comma separated values (*.csv)|*.csv"
    CommonDialog1.ShowOpen
    LoadImage (CommonDialog1.FileName)
End Sub

Private Sub LoadImage(fName As String)
    'TODO: This needs to save multidown images.
    Dim x As Integer, y As Integer
    Dim p As Variant, fileNumber As Variant
    Dim oligo As Variant, bnk As Integer
    Dim temp1 As String, temp2 As String
    Dim iDown As Integer, i As Integer
    
    'iDown = CurrentDown()
    fileNumber = FreeFile
    x = 1: y = ROWZ  'New! Flip the displayed image 9/15/2003.
    On Error GoTo ErrHandler    'CancelError is True.
    
    Screen.MousePointer = vbHourglass
    Open fName For Input As #fileNumber
    Do While (y > 0)
        'Read in one comma separated variable.
        Do
            If EOF(fileNumber) Then
                oligo = "_"
            Else
                Input #fileNumber, oligo
            End If
        Loop Until (Len(oligo) >= 1)
        'Put bank number corresponding to each character into intArray.
        For i = 1 To 100
            If (i <= Len(oligo)) Then
                intArray(x, y, i) = Sym2Bank(Mid(oligo, i, 1))
            Else
                intArray(x, y, i) = 0
            End If
        Next i
        'Increment column and, if necessary, row.
        x = x + 1
        If (x > COLZ) Then x = 1: y = y - 1  'New! Flip the displayed image 9/15/2003.
        Rem If EOF(fileNumber) Then Exit Do
    Loop
    Close #fileNumber   ' Close file.
    PaintPattern
    MainFrm.Refresh
    Screen.MousePointer = vbDefault
    Exit Sub
ErrHandler:
    'User pressed Cancel button or file not found.
    ErrorMessage.Display "Load Image subroutine cancelled.", 0
    Screen.MousePointer = vbDefault
    Exit Sub
End Sub


Private Sub BtnSaveImage_Click()
    CommonDialog1.DefaultExt = ".csv"
    CommonDialog1.Filter = "Comma separated values (*.csv)|*.csv"
    CommonDialog1.ShowSave
    SaveImage (CommonDialog1.FileName)
End Sub

Sub SaveImage(fName As String)
    'TODO:  This needs to save multidown images, rowz & colz <> 32.
    'Save the contents of intArray not Picture1 picturebox.
    Dim x As Integer, y As Integer, z As Integer
    Dim fileNumber
    Dim txt As String
    
    Screen.MousePointer = vbHourglass
    fileNumber = FreeFile
    ' CancelError is True.
    'On Error GoTo ErrHandler
    Open fName For Output As #fileNumber
    For y = 1 To ROWZ
        'Create a line of text to print to file.
        txt = ""
        For x = 1 To COLZ
            For z = 1 To DOWNZ
                txt = txt & Bank2Sym(intArray(x, (ROWZ + 1 - y), z)) 'New! Flip the displayed image 9/15/2003.
            Next z
            txt = RTrim(txt) 'Remove trailing spaces.
            txt = Replace(txt, " ", "-") 'Replace spaces with "-".
            If (x < COLZ) Then txt = txt & ","
        Next x
        'Print that line of text to file.
        Print #fileNumber, txt
    Next y
    Close #fileNumber   ' Close file.
    Screen.MousePointer = vbDefault
    Exit Sub
ErrHandler:
    'User pressed Cancel button.
    MsgBox "Save Image subroutine cancelled."
    Screen.MousePointer = vbDefault
    Exit Sub
End Sub


Private Function Sym2Bank(ByVal sSym As String) As Integer
    'Given a symbol (A, C, G, T, etc) return a bank number (1..6).
    Dim iBank As Integer, i As Integer
    iBank = 0
    For i = 6 To 1 Step -1
        If (tbBase(i).Text Like sSym) Then iBank = i
    Next i
    Sym2Bank = iBank
End Function

Private Function Bank2Sym(ByVal iBank As Integer) As String
    'Given a bank number (1..6) return a symbol (A, C, G, T, etc).
    'Return space char if default.
    If (iBank < 1 Or iBank > 6) Then
        Bank2Sym = " "
    Else
        Bank2Sym = Left(tbBase(iBank).Text, 1)
    End If
End Function


'***** Print image considering failed nozzles *****
Private Sub BtnPrint_Click()
    'Print the pattern displayed on screen, ie intArray.
    progDone = False
    PrintPatternOrCatalyst 0
End Sub


Private Sub PrintPatternOrCatalyst(iPattern As Integer)
    'Take the globals intArray and intPrinthead and repeatedly call
    '  PrintArray until the intArray pattern is successfully printed
    '  taking in to account the failed nozzles.
    'Unless iPattern is nonzero.  Then print an entire array of catalyst.
    'Make a copy of intArray called copyArray. Mask out failed nozzles
    '  to make subArray and print it. Remove successfully printed spots
    '  from copyArray and continue.  Offset vertically by 16 spots.
    '  Wrap around and continue by offsetting by 1 spot.
    'User BestArray, EvaluateArray, MakeSubarray, PrintArray subs.
    Dim copyArray(1 To COLZ, 1 To ROWZ) As Integer
    Dim subArray(1 To COLZ, 1 To ROWZ) As Integer
    Dim i As Integer, j As Integer 'Array row x, column y.
    Dim bank As Integer 'Six banks or colors or bases.
    Dim spotCnt As Integer 'How many spots are printed?  Work until spotCnt=0.
    Dim intOffset As Integer   'Best offset for subarray.
    Dim iDown As Integer        'The current down.
    Dim iBstBank As Integer     'The better of two banks (10<iPattern<100)
    
    'Choose the better of two banks, if same chemical in both.
    iBstBank = MoreWorkingNozzles(1, 2)
    
    'Copy intArray to copyArray.  Count how many spots, e.g. 50x32=1600.
    iDown = CurrentDown()
    spotCnt = 0
    For i = 1 To COLZ
        For j = 1 To ROWZ
            If (iPattern = 0) Then
                'The array we print is a pattern of nucleosides.
                'Use (33-j) so laserscans same orientation as picturebox.
                copyArray(i, j) = intArray(i, j, iDown)
                'copyArray(i, j) = intArray(i, (ROWZ + 1 - j), iDown)
            ElseIf (iPattern >= 1 And iPattern <= 6) Then
                'The array we print is all the same bank, ie catalyst.
                If (intArray(i, j, iDown) > 0) Then
                    copyArray(i, j) = iPattern
                    Picture1.PSet (i, (1 + ROWZ - j)), QBColor(iPattern)
                Else
                    copyArray(i, j) = 0
                    Picture1.PSet (i, (1 + ROWZ - j)), 0
                End If
            ElseIf (iPattern = 12) Then
                'The array we print is all the same bank, ie catalyst.
                If (intArray(i, j, iDown) > 0) Then
                    copyArray(i, j) = iBstBank
                    Picture1.PSet (i, (1 + ROWZ - j)), QBColor(iBstBank)
                Else
                    copyArray(i, j) = 0
                    Picture1.PSet (i, (1 + ROWZ - j)), 0
                End If
            Else
                'Error: no pattern to print specified.
                copyArray(i, j) = 0
            End If
            If (copyArray(i, j) >= 1) And (copyArray(i, j) <= 6) Then spotCnt = spotCnt + 1
        Next j
    Next i
    
    lblStatus.Caption = "Total spots: " & spotCnt
    MainFrm.Refresh
    
    'Limited number of attempts to print array.
    printDone = False
    servo.MoveY (-12500)
    For i = 1 To CMAXPRINTHEADPASSES
        intOffset = BestSubarray(copyArray)
        spotCnt = spotCnt - EvaluateSubarray(intOffset, copyArray)
        stat = MakeSubarray(intOffset, copyArray, subArray)
        If Not TESTMODE Then servo.MoveY (Int(222.222 * intOffset)) 'Was 220.
        PrintArray (subArray)
        If Not TESTMODE Then servo.MoveY (Int(-222.222 * intOffset))
        lblStatus.Caption = "Spots remaining: " & spotCnt
        lblStatus.Refresh
        If (spotCnt <= 0) Then Exit For
        DoEvents 'Allow user to click Stop Program button.
        If printDone Then Exit For
        If progDone Then Exit For
    Next i
    servo.MoveY (12500)
    If (spotCnt > 0) Then
        'Too many nozzle failures.  Move the printhead up and give the user
        'the option to quit the program.
        Rem ErrorMessage.Display ("Unable to print " & spotCnt & " spots.  Proceeding to wash with reagent" & CACETONITRILE), 30
        Rem ProgWash (CACETONITRILE)
        Rem ProgDry (0)
        servo.MoveZ (40000): servo.MoveY (20000)
        ErrorMessage.Display ("Unable to print " & spotCnt & " spots.  System halted."), 0
        If Not progDone Then servo.MoveY (-20000): servo.MoveZ (-40000)
    End If
    
    'Repaint main panel.
    PaintPattern
    lblStatus.Caption = "Status: Idle.": lblStatus.Refresh
    Beep
End Sub


Private Function BestSubarray(theArray) As Integer
    'Return the printhead offset that prints the most spots.
    'Start from offset zero.  Move up, then down.
    Dim j As Integer            'Try this offset.
    Dim cnt As Integer          'How many spots will be printed.
    Dim bestCnt As Integer      'Most spots will be printed.
    Dim bestOff As Integer      'Which offset is best.
    bestCnt = 0: bestOff = 0
    For j = 0 To (ROWZ - 1)
        cnt = EvaluateSubarray(j, theArray)
        If (cnt > bestCnt) Then bestCnt = cnt: bestOff = j
    Next j
    For j = -1 To (1 - ROWZ) Step -1
        cnt = EvaluateSubarray(j, theArray)
        If (cnt > bestCnt) Then bestCnt = cnt: bestOff = j
    Next j
    BestSubarray = bestOff
End Function


Private Function EvaluateSubarray(intOffset As Integer, theArray) As Integer
    'Count how many spots can be printed with this offset.
    'Take these two parameters, also use intPrinthead global.
    Dim i As Integer, j As Integer
    Dim a As Integer, b As Integer
    Dim bank As Integer, cnt As Integer
    
    'Look at which rows overlap, from row a to row b.
    If (intOffset > (ROWZ - 1) Or intOffset < (1 - ROWZ)) Then
        ErrorMessage.Display "Error in function EvaluateSubarray", 0
        Exit Function
    End If
    If (intOffset >= 0) Then
        a = 1: b = (ROWZ - intOffset)
    Else
        a = (1 - intOffset): b = ROWZ
    End If
    
    'Count how many spots will be printed
    cnt = 0
    For i = 1 To COLZ
        For j = a To b
            bank = theArray(i, j + intOffset)
            If (bank >= 1) And (bank <= 6) Then _
                If (intPrinthead(bank, j) = 1) Then cnt = cnt + 1
        Next j
    Next i
    EvaluateSubarray = cnt
End Function


Private Function MakeSubarray(intOffset As Integer, array1, array2) As Integer
    'Make array2 by offsetting array1 and skipping failed nozzles.
    'To-be-printed spots are removed from array1 (elements set to 0).
    'Take these three parameters, also use intPrinthead global.
    Dim i As Integer, j As Integer
    Dim a As Integer, b As Integer
    Dim bank As Integer, cnt As Integer
    
    'Look at which rows overlap, from row a to row b.
    If (intOffset > (ROWZ - 1) Or intOffset < (1 - ROWZ)) Then MakeSubarray = 1: Exit Function
    If (intOffset >= 0) Then
        a = 1: b = (ROWZ - intOffset)
    Else
        a = (1 - intOffset): b = ROWZ
    End If
    
    'Initialize array2() with zeros.
    For i = 1 To COLZ
        For j = 1 To ROWZ: array2(i, j) = 0: Next j
    Next i
    'Transfer information from array1() to array2().
    For i = 1 To COLZ
        For j = a To b
            bank = array1(i, j + intOffset)
            If (bank >= 1) And (bank <= 6) Then
                array2(i, j) = bank * intPrinthead(bank, j)
            End If
            If (array2(i, j) <> 0) Then
                'Erase spot in source array and on picture.
                array1(i, j + intOffset) = 0
                Rem Picture1.PSet (i, j + intOffset), 7
                Picture1.PSet (i, (1 + ROWZ - j) - intOffset), QBColor(0)
            End If
        Next j
    Next i
    MakeSubarray = 0
End Function


Private Function MoreWorkingNozzles(ByVal b1 As Integer, ByVal b2 As Integer) As Integer
    'Return the bank number that has more working nozzles.
    Dim i As Integer
    Dim c1 As Integer, c2 As Integer
    c1 = 0: c2 = 0 'Count working nozzles.
    MoreWorkingNozzles = 0
    If (b1 < 1 Or b1 > 6) Then Exit Function
    If (b2 < 1 Or b2 > 6) Then Exit Function
    For i = 1 To ROWZ
        If (intPrinthead(b1, i) = 1) Then c1 = c1 + 1
        If (intPrinthead(b2, i) = 1) Then c2 = c2 + 1
    Next i
    If (c1 > c2) Then MoreWorkingNozzles = b1 Else MoreWorkingNozzles = b2
End Function


Private Sub PrintArray(theArray)
    'Print contents of theArray not Picture1 or intArray.
    'Originally we would print 32x32 array 280 microns apart.
    'Now it is COLZxROWZ array 280 microns apart.
    Dim x As Integer, y As Integer
    Dim b As Integer, d As Integer
    Dim usedBanks(6) As Boolean
    Dim i As Integer
    
    'Number of drops per spot.
    d = Int(Val(tbDrops.Text))
    If (d < 1 Or d > 600) Then MsgBox "Drops out of range": Exit Sub
    If (d = 1) Then PrintArrayFast (theArray): Exit Sub
    
    'Which banks are used?
    For x = 1 To 6: usedBanks(x) = False: Next x
    For x = 1 To COLZ
        For y = 1 To ROWZ
            i = theArray(x, y)
            If (i > 0) Then usedBanks(i) = True
        Next y
    Next x
    
    'Actually print.
    Screen.MousePointer = vbHourglass
    For b = 1 To 6 'For each bank of nozzles.
        If (usedBanks(b)) Then
            servo.MoveX (BankXOffset(b) - 1500)
            For x = 1 To COLZ
            Rem For x = 1 To 49 Step 2
                'Turn on desired nozzles.
                ink.NozzlesAllOff
                For y = 1 To ROWZ
                    If (theArray(x, y) = b) Then ink.Nozzle((b - 1) * 32 + y) = True
                Next y
                'Spew drops and move 280 microns.
                ink.Spew (d)
                servo.MoveX (222)
                Rem servo.MoveX (444)
            Next x
            servo.MoveX (-222 * COLZ - BankXOffset(b) + 1500)
        End If
    Next b
    Screen.MousePointer = vbDefault
End Sub


Private Sub PrintArrayFast(theArray)
    'Print contents of theArray not Picture1 or intArray.
    'Originally we would print 32x32 array 280 microns apart.
    'Now it is COLZxROWZ array 280 microns apart.
    'Now do Fire on the Fly.
    Dim x As Integer, y As Integer
    Dim b As Integer, d As Integer
    Dim i As Integer, iErr As Integer
    Dim noz As Integer, state As Integer, targ As Long
    Dim cnt As Long
    Dim iStatus As Integer
    iStatus = 0 'No error printing.

    Screen.MousePointer = vbHourglass
    'Configure a big buffer of data to guide entirearray ink spewing.
    ink.InitFireOnFlyBuffer 'Set buffer zero values, clock pulses, latches.
    state = 1
    For x = 1 To COLZ '70 columns.  Used to be 32, then 50.
        For y = 1 To 32 '32 rows on current print head.
            'Determine the nozzle number from the bank and the row.
            b = theArray(x, y)
            noz = (b - 1) * 32 + y
            If (noz < 1 Or noz > 192) Then noz = 0
            'Determine the target positions from the bank and the column.
            If (b = 6) Then targ = x
            If (b = 5) Then targ = x + 8
            If (b = 4) Then targ = x + 8 + 28
            If (b = 3) Then targ = x + 8 + 28 + 8
            If (b = 2) Then targ = x + 8 + 28 + 8 + 28
            If (b = 1) Then targ = x + 8 + 28 + 8 + 28 + 8 'temp
            'Configure the big buffer to spew monomers.
            Rem If (noz = 0) Then state = 0 Else state = 1
            If (noz >= 1 And noz <= 192 And targ >= 1 And targ <= 150) Then
                ink.CfgFireOnFly noz, state, targ
            End If
        Next y
    Next x
    
    'Set trigger and start the motion.
    servo.MoveX (-30000)
    iErr = servo.SetTriggers((servo.absX + 30000 - 17778 - 1500), 222, 150)
    lblStatus.Caption = "Trigger at " & (servo.absX + 30000 - 17778 - 1500)
    lblStatus.Refresh
    If (iErr <> 0) Then Exit Sub
    ink.CfgTriggeredOutput
    cnt = 0
    ink.SetTriggered (cnt)
    sw.Reset
    servo.SetVelocity (0.8) 'Maximum appears to be about 1.2.
    servo.MoveXNoWait (50000) 'Don't seem to need servo.MoveXNoWait, can use servo.MoveX.  Bug?
    
    'The critical jetting loop.
    While ((cnt < 149) And Not sw.Elapsed(15))
        Do
        Loop Until (ink.HasBeenTriggered) Or sw.Elapsed(15)
        cnt = cnt + 1
        ink.SetTriggered (cnt)
        lblStatus.Caption = "Trigger #" & cnt
        lblStatus.Refresh
    Wend
    
    'Return to original position.
    servo.SetVelocity (0)
    servo.WaitForMotionStop
    'servo.MoveY (99): servo.MoveY (-99)  'A hack to fix this servo.MoveXNoWait bug.
    servo.MoveX (-20000)
    ink.EndTriggeredOutput
    
    'Check for errors
    If (cnt < 149) Then iStatus = iStatus + 1 'Triggers missed by PrintArrayFast.
    If (servo.TriggersTripped < 149) Then iStatus = iStatus + 2
    If (servo.TriggersMissed > 0) Then iStatus = iStatus + 4
    Screen.MousePointer = vbDefault
    
    'Error reporting.
    If (iStatus <> 0) Then
        servo.MoveZ (40000): servo.MoveY (20000)
        ErrorMessage.Display ("Triggers missed in MainFrm.PrintArrayFast: " & iStatus), 0
        If Not progDone Then servo.MoveY (-20000): servo.MoveZ (-40000)
    End If
End Sub


Private Function BankXOffset(bank As Integer) As Integer
    Dim x As Integer
    x = 0
    If (bank = 2) Then x = 1778
    If (bank = 3) Then x = 1778 + 6222
    If (bank = 4) Then x = 1778 + 6222 + 1778
    If (bank = 5) Then x = 1778 + 6222 + 1778 + 6222
    If (bank = 6) Then x = 1778 + 6222 + 1778 + 6222 + 1778
    BankXOffset = -x
End Function



'***** Misc buttons and textboxes on the main form *****

Private Sub btnFirstDown_Click()
    'Set the "down" box to "1" on the main panel.
    tbDown.Text = "1"
    PaintPattern
End Sub
    
Private Sub btnIncrementDown_Click()
    'Increment the "down" text box on the main panel.
    Dim x As Integer
    tbDown.Text = Format((CurrentDown() + 1), "0")
    x = CurrentDown()
    PaintPattern
End Sub

Private Sub tbDown_Change()
    'Update the display with the pattern of the new down.
    PaintPattern
End Sub

Private Function CurrentDown() As Integer
    'Check which down is currently displayed/used.
    Dim z As Integer
    z = Int(Val(tbDown.Text))
    If (z < 1 Or z > DOWNZ) Then z = 1
    tbDown.Text = z
    tbDown.Refresh
    CurrentDown = z
End Function


Private Sub tbBase_Change(Index As Integer)
    'Clear the Picture1 display so that we force the
    'user to reload a csv file or create a new one.
    BtnClear_Click
End Sub


Private Sub PaintPattern()
    Dim x As Integer, y As Integer, z As Integer
    z = CurrentDown()
    For x = 1 To COLZ
        For y = 1 To ROWZ
            Picture1.PSet (x, y), QBColor(intArray(x, (ROWZ + 1 - y), z)) 'New! Flip the displayed image 9/15/2003.
        Next y
    Next x
    MainFrm.Refresh
End Sub


Private Sub btnFireBank_Click(Index As Integer)
    'Spew 100 droplets from every nozzle.
    Dim i As Integer
    ink.NozzlesAllOff
    For i = (Index * 32 - 31) To (Index * 32)
        ink.Nozzle(i) = True
    Next i
    For i = 1 To 1
        ink.Spew (100)
    Next i
    Beep
End Sub


Private Sub cbN2Jet_Click()
    'This is the checkbox for the gas stream (N2 or Ar) that dries the slides.
    If (cbN2Jet.value = 1) Then
        multio.N2JetOn
    Else
        multio.N2JetOff
    End If
End Sub


Private Sub btnCleanHead_Click()
    'Move printhead overtop a small silicone vacuum cleaner.
    Dim i As Integer, j As Integer
    Dim dblVel As Double
    Dim sweepx, sweepy
    
    'Sweep printhead over the cleaner.
    'Gap between printhead and cleaner ~ 4000.
    sweepy = Array(0, -1, 1, -1, 1, -1, 1)
    sweepx = Array(0, (BankXOffset(2) - BankXOffset(1)), (BankXOffset(3) - BankXOffset(2)), _
        (BankXOffset(4) - BankXOffset(3)), (BankXOffset(5) - BankXOffset(4)), _
        (BankXOffset(6) - BankXOffset(5)), (-BankXOffset(6)))
    ImpCoor.GoToPosition (3)
    For i = 1 To 6
        servo.MoveY (sweepy(i) * 8000)
        servo.MoveX (sweepx(i))
    Next i
    
    'Contact cleaner momentarily over each small grouping of nozzles.
    'Gap about ~ 2000 when moving.
    servo.MoveZ (-2000)
    For i = 1 To 6
        For j = 1 To 4
            servo.MoveY (sweepy(i) * 2000)
            servo.MoveZ (-2000)
            'ProgWait (1.5)
            MsgBox "Continue?"
            servo.MoveZ (2000)
        Next j
        servo.MoveX (sweepx(i))
    Next i
    
    'Sweep again.  Gap ~ 2000.
    For i = 1 To 6
        servo.MoveY (sweepy(i) * 8000)
        servo.MoveX (sweepx(i))
    Next i
    servo.MoveZ (2000)
    
    'Purge.
    Rem ImpCoor.GoToPosition (2)
    Rem ProgPurge (6)
End Sub


Private Sub btnPressure_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    multio.PressureOn
End Sub
Private Sub btnPressure_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    multio.PressureOff
End Sub


Private Sub BtnRunSolenoids_Click()
    Dim stat As Integer
    stat = solenoid.Pump(Val(tbPump), Val(tbPumpDur.Text))
End Sub


Private Sub btnShowHelp_Click()
    HelpFrm.Show
End Sub


Private Sub btnGetPosition_Click()
    'This reports the actual encoder position,
    'not the servo commanded position.
    Dim stat As Integer
    Dim x As Long, y As Long, z As Long
    stat = servo.GetPos(x, y, z)
    If stat = 0 Then
        MsgBox "X:" & x & " Y:" & y & " Z:" & z
    Else
        MsgBox "Error communicating with 6K4"
    End If
End Sub


Private Sub btnMovePosition_Click()
    ImpCoor.Show
End Sub


Private Sub btnExit_Click()
    Unload MainFrm
    End
End Sub



'***** Printhead working nozzle checks *****

Private Sub btnResetDD_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    multio.ResetDropletDetector
    btnResetDD.BackColor = "&H8000000F"
    btnResetDD.Refresh
End Sub


Private Sub btnResetDD_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    'Indicate a high signal on this digital input by painting button red.
    If (multio.ReadDropletDetector = True) Then
        btnResetDD.BackColor = "&H000000FF"
        btnResetDD.Refresh
    Else
        btnResetDD.BackColor = "&H8000000F"
        btnResetDD.Refresh
    End If
End Sub


Private Sub btnResetNozzles_Click()
    Dim i As Integer, j As Integer
    For i = 1 To 6
        For j = 1 To 32
            intPrinthead(i, j) = 1 '1 is working, 0 is failed.
            Picture2.PSet (i, j), QBColor(i)
        Next j
    Next i
    MainFrm.Refresh
End Sub


Private Sub btnTestNozzles_Click()
    'Move to Position 1 and test the nozzles
    ImpCoor.GoToPosition (1)
    TestNozzles (6)
End Sub

Private Sub TestNozzles(ByVal iBanks As Integer)
    'Test bank #1 to #iBanks.  Usually 6.
    'Fire each individual nozzle.
    'Save the good ones as a value of 1 in global intPrinthead array.
    'If new nozzle failures, set global lessNozzles to number.
    'If nozzles return online, set global moreNozzles to number
    'Assume print head is positioned with bank on in laser line.
    Dim i As Integer, j As Integer
    Dim noz As Integer
    Dim goodnoz As Integer
    Dim txt As String
    lessNozzles = 0: moreNozzles = 0
    
    Screen.MousePointer = vbHourglass
    If (iBanks < 1 Or iBanks > 6) Then iBanks = 6
    ink.NozzlesAllOff
    
    'Fire each sequentially.  We start positioned at bank 1.
    For i = 1 To iBanks
        If (i > 1) Then servo.MoveX (BankXOffset(i) - BankXOffset(i - 1))
        For j = 1 To 32
            multio.ResetDropletDetector
            noz = (i - 1) * 32 + j
            ink.Nozzle(noz) = True
            ink.Spew (100)
            ink.Nozzle(noz) = False
            If (multio.ReadDropletDetector = True) Then goodnoz = 1 Else goodnoz = 0
            If (goodnoz = 1 And intPrinthead(i, j) = 0) Then moreNozzles = moreNozzles + 1
            If (goodnoz = 0 And intPrinthead(i, j) = 1) Then lessNozzles = lessNozzles + 1
            intPrinthead(i, j) = goodnoz
            Picture2.PSet (i, j), (QBColor(i) * goodnoz)
        Next j
    Next i
    servo.MoveX (-BankXOffset(iBanks))
    multio.ResetDropletDetector
    MainFrm.Refresh
    
    'List failed nozzles in error log.
    txt = "Failed nozzles: "
    For i = 1 To 6
        For j = 1 To 32
            If intPrinthead(i, j) = 0 Then txt = txt & i & "," & j & "; "
        Next j
    Next i
    ErrorMessage.Log (txt)
    
    'Note the addition or loss of nozzles.
    If (moreNozzles > 0) Then ErrorMessage.Display (moreNozzles & " new nozzles working again."), 2
    If (lessNozzles > 0) Then ErrorMessage.Display (lessNozzles & " new nozzle failures."), 2
    Screen.MousePointer = vbDefault
End Sub


Private Sub Picture2_MouseDown(btn As Integer, shft As Integer, x As Single, y As Single)
    'This sub allows editing of the nozzle picture box.
    x = Int(x + 0.5): y = Int(y + 0.5)
    If (x < 1) Then x = 1 Else If (x > 6) Then x = 6
    If (y < 1) Then y = 1 Else If (y > 32) Then y = 32
    intPrinthead(x, y) = 0
    Picture2.PSet (x, y), QBColor(0)
End Sub


Private Sub btnCenterDetector_Click()
    'Find the center of the laser beam.
    'Move left to right in increments of 250.
    'Take the average position.
    Dim txt As String, rDrop As Boolean
    Dim meanPos As Long, cntPos As Long
    Dim xPos As Long, yPos As Long, zPos As Long
    Dim i As Integer, incr As Integer
    Dim stat As Integer
    
    incr = 100
    meanPos = 0: cntPos = 0
    txt = "Have you set the z axis and moved the x axis slightly left of the detector?"
    If MsgBox(txt, vbYesNo) = vbNo Then Exit Sub
    
    'Set up some nozzles of bank 1 to fire.
    Screen.MousePointer = vbHourglass
    For i = 1 To 192: ink.Nozzle(i) = False: Next i
    For i = 4 To 32 Step 4: ink.Nozzle(i) = True: Next i
    
    'Sweep left to right.  30 steps.
    For i = 1 To 40
        multio.ResetDropletDetector
        ink.Spew (10)
        rDrop = multio.ReadDropletDetector
        If rDrop Then
            meanPos = meanPos + i
            cntPos = cntPos + 1
            btnCenterDetector.BackColor = "&H000000FF"
            btnCenterDetector.Refresh
        Else
            btnCenterDetector.BackColor = "&H8000000F"
            btnCenterDetector.Refresh
        End If
        servo.MoveX (incr)
        If (cntPos > 2) And (rDrop = False) Then Exit For
    Next i
    btnCenterDetector.BackColor = "&H8000000F"
    btnCenterDetector.Refresh
    multio.ResetDropletDetector
    
    'Move to center position and report to user.
    If (cntPos > 0) Then
        meanPos = Int(incr * meanPos / cntPos)
        servo.MoveX (meanPos - (incr * i))
        stat = servo.GetPos(xPos, yPos, zPos)
        MsgBox "Centered at x=" & xPos & " z=" & zPos
    Else
        servo.MoveX (-incr * i)
        MsgBox "Error finding center position"
    End If
    
    Screen.MousePointer = vbDefault
End Sub


Private Sub timerHyg_Timer()
    ' Check the hygrometer and show RH on screen every 10 seconds.
    On Error GoTo SkipToEnd
    lblHyg.Caption = Format(multio.ReadHumidity, "0.0") & "% RH"
SkipToEnd:
End Sub


' Description: Turn on/off 120VAC to N2/Ar solenoid for drying the box.
Public Sub chkDryerOn_Click()
    If (chkDryerOn.value = vbChecked) Then
        multio.Relay5On
    Else
        multio.Relay5Off
    End If
End Sub



'********** Settings file ******************

Private Sub SaveSettings()
    Dim fnum, n As Integer
    fnum = FreeFile
    Open SETTINGSFILE For Output As #fnum
    'Save base assignments.
    For n = 1 To 6
        Print #fnum, tbBase(n).Text
    Next n
    'Save editable boxes on main form.
    Print #fnum, tbDrops.Text
    Print #fnum, tbDown.Text
    Print #fnum, tbSlideCount.Text
    Print #fnum, tbPumpDur.Text
    Print #fnum, tbPump.Text
    'Save important coordinates.
    For n = 1 To 8
        Print #fnum, ImpCoor.tbX(n).Text
        Print #fnum, ImpCoor.tbY(n).Text
        Print #fnum, ImpCoor.tbZ(n).Text
        Print #fnum, ImpCoor.tbName(n).Text
    Next n
    'Save hygrometer calibration.
    Print #fnum, Format(multio.hygSlope, "0.0000")
    Print #fnum, Format(multio.hygOffset, "0.0000")
    'Close.
    Close #fnum
End Sub

Private Sub LoadSettings()
    Dim fnum, x, n As Integer
    Dim txt As String
    fnum = FreeFile
    On Error GoTo SkipLoadSettings
    If (Len(dir(SETTINGSFILE)) < 1) Then Exit Sub
    txt = "Would you like to load settings from file " & SETTINGSFILE & _
        "?  It is recommended that you choose Yes."
    If (MsgBox(txt, vbYesNo) = vbNo) Then Exit Sub
    Open SETTINGSFILE For Input As #fnum
    'Load base assignments.
    For n = 1 To 6
        Input #fnum, x: tbBase(n).Text = x
    Next n
    'Load editable boxes on main form.
    Input #fnum, x: tbDrops.Text = x
    Input #fnum, x: tbDown.Text = x
    Input #fnum, x: tbSlideCount.Text = x
    Input #fnum, x: tbPumpDur.Text = x
    Input #fnum, x: tbPump.Text = x
    'Load important coordinates.
    For n = 1 To 8
        Input #fnum, x: ImpCoor.tbX(n).Text = x
        Input #fnum, x: ImpCoor.tbY(n).Text = x
        Input #fnum, x: ImpCoor.tbZ(n).Text = x
        Input #fnum, x: ImpCoor.tbName(n).Text = x
    Next n
    'Load hygrometer calibration.
    Input #fnum, x: multio.hygSlope = x
    Input #fnum, x: multio.hygOffset = x
    'Close.
    Close #fnum
SkipLoadSettings:
End Sub
