VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Solenoids"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'SOLENOIDS CLASS MODULE
'This class requires use of the ErrorMessage class.

'   Copyright (C) 2004  The Institute for Systems Biology
'   For license information, read Copying.txt
'

Option Base 1

Private Declare Function DIG_Prt_Config Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal mode As Integer, _
    ByVal dir As Integer) As Integer
Private Declare Function DIG_Out_Line Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal line As Integer, _
    ByVal state As Integer) As Integer
Private Declare Function DIG_Out_Prt Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByVal pattern As Long) _
    As Integer
Private Declare Function DIG_In_Prt Lib "nidaq32.dll" (ByVal DEV _
    As Integer, ByVal PORT As Integer, ByRef pattern As Long) _
    As Integer

Private Const DEV As Integer = 1 'DIO-32HS.
Private Const PORT As Integer = 1 'Port B.
Private Const INPUTPRT As Integer = 0
Private Const OUTPUTPRT As Integer = 1
Private Const NOHSHAKE As Integer = 0
Private Const motionOff As Integer = 0 'Was once 128 + 64
Private Const motionCW As Integer = 128 'Obsolete.
Private Const motionCCW As Integer = 64 'Obsolete.
Private sw As Stopwatch
Private stat As Integer


'Object constructor.
Private Sub Class_Initialize()
    Dim pattern As Long
    
    'Create stopwatch.
    Set sw = New Stopwatch
    
    'Check if 1702 mux board present
    stat = DIG_Prt_Config(DEV, PORT, NOHSHAKE, INPUTPRT)
    If (stat <> 0) Then ErrorMessage.Display ("Port config error:" & stat), 15
    stat = DIG_In_Prt(DEV, PORT, pattern)
    If (stat <> 0) Then ErrorMessage.Display ("Port input error:" & stat), 15
    If (pattern <> motionOff) Then
        ErrorMessage.Display "Error: No multiplex board #1702 detected.", 15
    End If
    
    'Configure an output port to control solenoids.
    stat = DIG_Prt_Config(DEV, PORT, NOHSHAKE, OUTPUTPRT)
    If (stat <> 0) Then ErrorMessage.Display ("Port config error:" & stat), 15
    'Bits 6 and 7 set high so there is no motion.
    stat = DIG_Out_Prt(DEV, PORT, motionOff)
    If (stat <> 0) Then ErrorMessage.Display ("Port output error:" & stat), 15
End Sub


'Object destructor.
Private Sub Class_Terminate()
    'Release stopwatch.
    Set sw = Nothing
    'Be sure motion off by changing output port to input port.
    stat = DIG_Prt_Config(DEV, PORT, NOHSHAKE, INPUTPRT)
    If (stat <> 0) Then ErrorMessage.Display ("Port config error:" & stat), 15
End Sub


Public Function Pump(ByVal intPump As Integer, ByVal sglTime As Single) As Integer
    'Hold a solenoid open for sglTime seconds.
    
    'Error checking.
    If (intPump > 7 Or intPump < 0) Then Exit Function
    If (sglTime > 30 Or sglTime < 0) Then Exit Function
    
    'Set timer and start solenoid dispensing.
    Screen.MousePointer = vbHourglass
    sw.Reset
    stat = DIG_Out_Prt(DEV, PORT, intPump)
    If (stat <> 0) Then ErrorMessage.Display ("Error activating solenoid: " & stat), 15
    While (sw.Elapsed(sglTime) = False): Wend 'Wait until done.
    stat = DIG_Out_Prt(DEV, PORT, motionOff)
    If (stat <> 0) Then ErrorMessage.Display ("Error deactivating solenoid: " & stat), 15
    Screen.MousePointer = Default
    'Return any error code.
    Pump = stat
End Function


