VERSION 5.00
Begin VB.Form zInkTest 
   Caption         =   "Inkjet Class Test Form"
   ClientHeight    =   8925
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   12930
   LinkTopic       =   "Form1"
   ScaleHeight     =   100
   ScaleMode       =   0  'User
   ScaleWidth      =   20000
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton btnFastAdvance 
      Caption         =   ">>"
      Height          =   495
      Left            =   8160
      TabIndex        =   7
      Top             =   8280
      Width           =   495
   End
   Begin VB.CommandButton btnFastRewind 
      Caption         =   "<<"
      Height          =   495
      Left            =   4320
      TabIndex        =   6
      Top             =   8280
      Width           =   615
   End
   Begin VB.CommandButton btnRewind 
      Caption         =   "Rewind"
      Height          =   495
      Left            =   5040
      TabIndex        =   4
      Top             =   8280
      Width           =   1455
   End
   Begin VB.CommandButton btnAdvance 
      Caption         =   "Advance"
      Height          =   495
      Left            =   6600
      TabIndex        =   3
      Top             =   8280
      Width           =   1455
   End
   Begin VB.PictureBox pbxDigital 
      BackColor       =   &H00FFFFFF&
      Height          =   5295
      Left            =   120
      ScaleHeight     =   11
      ScaleMode       =   0  'User
      ScaleWidth      =   300
      TabIndex        =   2
      Top             =   2760
      Width           =   12615
   End
   Begin VB.PictureBox pbxAnalog 
      BackColor       =   &H00FFFFFF&
      Height          =   2535
      Left            =   120
      ScaleHeight     =   256
      ScaleMode       =   0  'User
      ScaleWidth      =   300
      TabIndex        =   1
      Top             =   120
      Width           =   12615
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Default         =   -1  'True
      Height          =   495
      Left            =   11400
      TabIndex        =   0
      Top             =   8280
      Width           =   1335
   End
   Begin VB.Label lblPos 
      Caption         =   "1"
      Height          =   375
      Left            =   240
      TabIndex        =   5
      Top             =   8280
      Width           =   1215
   End
End
Attribute VB_Name = "zInkTest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This form zInkTest is used to troubleshoot the Inkjet class.
'When TESTMODE is true on MainFrm, this is called rather than
' the usual Inkjet methods.  Many 6k4 and Nidaq error will
' appear when using the test mode.  None are fatal.
' C Lausted 010716.

'   Copyright (C) 2004  The Institute for Systems Biology
'   For license information, read Copying.txt
'

'Epson interface constants.
Private Const LAT As Integer = 256
Private Const CLK As Integer = 512
Private Const SG1 As Integer = 1024
Private Const SG2 As Integer = 2048
Private Const SG3 As Integer = 4096
Private Const NCHG As Integer = 8192
Private Const WBIGSIZE As Long = 1510002

Dim iA(WBIGSIZE) As Integer
Dim lPos As Long


Private Sub btnClose_Click()
    Unload zInkTest
End Sub


Public Sub DisplayBigArray(iBigArray() As Integer)
    Dim n As Long, m
    'Dimensioning
    pbxAnalog.ScaleWidth = 300
    pbxAnalog.ScaleHeight = 256
    pbxAnalog.DrawWidth = 2
    pbxDigital.ScaleWidth = 300
    pbxDigital.ScaleHeight = 12
    pbxDigital.DrawWidth = 2
    'Make a copy of this big array.
    For n = 1 To WBIGSIZE
        iA(n) = iBigArray(n)
    Next n
    'Display a bit of the array.
    zInkTest.Show
    lPos = 1
    MyRefresh
End Sub


Private Sub MyRefresh()
    Dim m
    pbxAnalog.Cls
    pbxDigital.Cls
    For n = 1 To 300
        pbxAnalog.PSet (n, (256 - (iA(n + lPos) And 255))), 1
        If ((iA(n + lPos) And LAT) <> 0) Then m = 1 Else m = 0
        pbxDigital.PSet (n, 2 - m), QBColor(m * 4)
        If ((iA(n + lPos) And CLK) <> 0) Then m = 1 Else m = 0
        pbxDigital.PSet (n, 4 - m), QBColor(m * 4)
        If ((iA(n + lPos) And SG1) <> 0) Then m = 1 Else m = 0
        pbxDigital.PSet (n, 6 - m), QBColor(m * 4)
        If ((iA(n + lPos) And SG2) <> 0) Then m = 1 Else m = 0
        pbxDigital.PSet (n, 8 - m), QBColor(m * 4)
        If ((iA(n + lPos) And SG3) <> 0) Then m = 1 Else m = 0
        pbxDigital.PSet (n, 10 - m), QBColor(m * 4)
    Next n
    lblPos = Format(lPos)
End Sub


Private Sub btnAdvance_Click()
    If ((lPos + 300) < WBIGSIZE) Then lPos = lPos + 250 Else lPos = 1
    MyRefresh
End Sub

Private Sub btnFastAdvance_Click()
    If ((lPos + 10100) < WBIGSIZE) Then lPos = lPos + 10000 Else lPos = 1
    MyRefresh
End Sub

Private Sub btnRewind_Click()
    If (lPos > 251) Then lPos = lPos - 250 Else lPos = 1
    MyRefresh
End Sub

Private Sub btnFastRewind_Click()
    If (lPos > 10001) Then lPos = lPos - 10000 Else lPos = 1
    MyRefresh
End Sub
