package org.sStu.Neringute.Similarity;

import org.sStu.*;


/**
 * Char comparator is used with score matrixes.
 * It returns matrix[a][b].
 * @copyright: Copyright (c) 2003 Audrius Meskauskas, General public license (GPL)
 * @see http://www.gnu.org/licenses/gpl.txt
 */

public class ScoreMatrixComparator extends CharComparator {
  /** The score matrix. */
  public char[][] matrix;
  public ScoreMatrixComparator(char [][] scoreMatrix) {
    matrix = scoreMatrix;
  }

  /** @returns the score from matrix (matrix[a][b]).
   *  Compares characters returning.
   *  If one or both the chars are outside the score matrix size
   *  returns DefaultMatchValue if they are equal, DefaultMismatchValue otherwise.
   */
  public int compare(char a, char b) throws ArrayIndexOutOfBoundsException {
    try {
      return matrix[a][b];
    }
    catch (ArrayIndexOutOfBoundsException ex) {
      if (a==b) return DefaultMatchValue;
      else return DefaultMismatchValue;
    }
  }

  public int DefaultMatchValue = 2;
  public int DefaultMismatchValue = -1;

}