/*
 * Decompiled with CFR 0.152.
 */
package dataframe;

import dataframe.TextArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChipData
implements Serializable {
    private int mnColumns;
    private int mnRows;
    private String[] mProbeIDs;
    private String[] mColumnNames;
    private double[][] mdData;
    private String mstrErrorMessage;
    private String mstrFileName;
    private int mnSkip;

    public ChipData() {
        this.mnColumns = 0;
        this.mnRows = 0;
        this.mnSkip = 0;
        this.mstrErrorMessage = "";
        this.mstrFileName = "";
    }

    public ChipData(String file) {
        this.mnColumns = 0;
        this.mnRows = 0;
        this.mnSkip = 1;
        this.mstrErrorMessage = "";
        this.mstrFileName = "";
        this.load(file, this.mnSkip);
    }

    public ChipData(double[][] data, String[] ids, String[] columnnames) {
        int i;
        this.mnSkip = 1;
        this.mstrErrorMessage = "";
        this.mstrFileName = "";
        this.mnRows = data.length;
        this.mnColumns = data[0].length;
        this.mdData = new double[this.mnRows][this.mnColumns];
        this.mProbeIDs = new String[this.mnRows];
        this.mColumnNames = new String[this.mnColumns];
        for (i = 0; i < this.mnColumns; ++i) {
            this.mColumnNames[i] = columnnames[i];
        }
        for (i = 0; i < this.mnRows; ++i) {
            this.mProbeIDs[i] = ids[i];
            for (int j = 0; j < this.mnColumns; ++j) {
                this.mdData[i][j] = data[i][j];
            }
        }
    }

    public int getNumberOfColumns() {
        return this.mnColumns;
    }

    public int getNumberOfRows() {
        return this.mnRows;
    }

    public String getErrorMessage() {
        return this.mstrErrorMessage;
    }

    public double[][] data() {
        return this.mdData;
    }

    public String[] probeid() {
        return this.mProbeIDs;
    }

    public String[] columnnames() {
        return this.mColumnNames;
    }

    public String columnnamem(int index) {
        if (index < 1 || index > this.mnColumns) {
            return "Index out of bound";
        }
        return this.mColumnNames[index - 1];
    }

    public String columnnamej(int index) {
        return this.columnnamem(index + 1);
    }

    public String probeidm(int index) {
        if (index < 1 || index > this.mnRows) {
            return "Index out of bound";
        }
        return this.mProbeIDs[index - 1];
    }

    public String probeidj(int index) {
        return this.probeidm(index + 1);
    }

    public ChipData select(Object[] list) {
        return this.select((String[])list);
    }

    public ChipData select(char[] list) {
        return this.select(TextArray.toStrings(list));
    }

    public ChipData select(char[][] list) {
        return this.select(TextArray.toStrings(list));
    }

    public ChipData select(String[] list) {
        int i;
        Vector CleanList = this.parseObjectArray(list);
        if (CleanList.isEmpty()) {
            System.out.println("Input list is empty");
            return null;
        }
        if (CleanList.size() != list.length) {
            System.out.println("Invalid probe ids found");
            return null;
        }
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        for (i = 0; i < this.mProbeIDs.length; ++i) {
            if (!CleanList.contains(this.mProbeIDs[i])) continue;
            table.put(this.mProbeIDs[i], new Integer(i));
        }
        if (table.isEmpty()) {
            System.out.println("No matched probe ids are found.");
            return null;
        }
        for (i = 0; i < CleanList.size(); ++i) {
            if (table.containsKey(CleanList.get(i))) continue;
            System.out.println("Invalid probe id found:" + (String)CleanList.get(i));
            return null;
        }
        int row = CleanList.size();
        double[][] d = new double[row][this.mnColumns];
        String[] id = new String[row];
        for (int i2 = 0; i2 < row; ++i2) {
            int ix = (Integer)table.get(CleanList.get(i2));
            id[i2] = this.mProbeIDs[ix];
            for (int j = 0; j < this.mnColumns; ++j) {
                d[i2][j] = this.mdData[ix][j];
            }
        }
        return new ChipData(d, id, this.mColumnNames);
    }

    public boolean save(String FileName) {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
            if (this.mnColumns > 0) {
                int i;
                if (this.mnSkip > 0) {
                    fw.write("ProbeID");
                    for (i = 0; i < this.mnColumns; ++i) {
                        fw.write("\t");
                        fw.write(this.mColumnNames[i]);
                    }
                    fw.newLine();
                }
                if (this.mnRows > 0) {
                    for (i = 0; i < this.mnRows; ++i) {
                        fw.write(this.mProbeIDs[i]);
                        for (int j = 0; j < this.mnColumns; ++j) {
                            fw.write("\t");
                            fw.write(Double.toString(this.mdData[i][j]));
                        }
                        if (i == this.mnRows - 1) continue;
                        fw.newLine();
                    }
                }
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Save file " + FileName + " failed");
            return false;
        }
        return true;
    }

    public boolean load(String FileName, int skip) {
        String str;
        this.mnColumns = 0;
        this.mnRows = 0;
        this.mnSkip = skip;
        this.mstrFileName = FileName;
        int nLineCount = 0;
        BufferedReader br = TextArray.getBufferedReader(FileName);
        if (br == null) {
            return false;
        }
        try {
            while ((str = br.readLine()) != null) {
                if (++nLineCount <= this.mnSkip || this.mnColumns != 0) continue;
                StringTokenizer st = new StringTokenizer(str.trim());
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    ++this.mnColumns;
                }
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        this.mnRows = nLineCount - this.mnSkip;
        --this.mnColumns;
        this.mProbeIDs = new String[this.mnRows];
        this.mdData = new double[this.mnRows][this.mnColumns];
        nLineCount = 0;
        try {
            br = TextArray.getBufferedReader(FileName);
            if (br == null) {
                return false;
            }
            while ((str = br.readLine()) != null) {
                int nrow;
                String token;
                if (++nLineCount == 1) {
                    this.mColumnNames = new String[this.mnColumns];
                    for (int i = 0; i < this.mnColumns; ++i) {
                        this.mColumnNames[i] = new Integer(i + 1).toString();
                    }
                    StringTokenizer st = new StringTokenizer(str);
                    int ncolumn = 0;
                    boolean bskipone = true;
                    while (st.hasMoreTokens() && ncolumn < this.mnColumns) {
                        token = st.nextToken();
                        if (bskipone) {
                            bskipone = false;
                            continue;
                        }
                        this.mColumnNames[ncolumn] = token.trim();
                        ++ncolumn;
                    }
                }
                if ((nrow = nLineCount - this.mnSkip - 1) < 0 || nrow >= this.mnRows) continue;
                StringTokenizer st = new StringTokenizer(str.trim());
                int ncolumn = 0;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (ncolumn == 0) {
                        this.mProbeIDs[nrow] = token.trim();
                    } else if (ncolumn <= this.mnColumns) {
                        this.mdData[nrow][ncolumn - 1] = Double.parseDouble(token);
                    }
                    ++ncolumn;
                }
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    private Vector parseObjectArray(String[] oa) {
        Vector<String> v = new Vector<String>();
        if (oa.length > 0) {
            for (int i = 0; i < oa.length; ++i) {
                String str = oa[i];
                if (str == null || str.length() <= 0) continue;
                v.add(str.trim());
            }
        }
        return v;
    }
}

