/*
 * Decompiled with CFR 0.152.
 */
package dataframe;

import dataframe.BrowserLauncher;
import dataframe.TextArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChipDescription
implements Serializable {
    private String mChipName;
    private String[] mID;
    private String[] mDesc;
    private String[] mDesc_no_id;
    private Hashtable mTable;
    private int mnRows;
    private int mnSkip;
    private String mstrSeparator;

    public ChipDescription() {
        this.init("unknown");
    }

    public ChipDescription(String name) {
        this.init(name);
    }

    public ChipDescription(String name, String[] descs) {
        this.init(name);
        if (descs == null || descs.length == 0) {
            return;
        }
        this.mTable.clear();
        this.mnRows = descs.length;
        this.mID = new String[this.mnRows];
        this.mDesc = new String[this.mnRows];
        this.mDesc_no_id = new String[this.mnRows];
        for (int i = 0; i < this.mnRows; ++i) {
            String str = descs[i];
            if (str == null || str.length() == 0) {
                System.out.println("Invalid Input");
                return;
            }
            StringTokenizer st = new StringTokenizer(str.trim(), this.mstrSeparator);
            this.mID[i] = st.hasMoreTokens() ? st.nextToken().trim() : new Integer(i).toString() + "_";
            this.mDesc[i] = str.trim();
            this.mDesc_no_id[i] = str.substring(this.mID[i].length()).trim();
            this.mTable.put(this.mID[i], new Integer(i));
        }
    }

    public boolean save(String FileName) {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(FileName));
            if (this.mnRows > 0) {
                for (int i = 0; i < this.mnRows; ++i) {
                    fw.write(this.mID[i] + "\t" + this.mDesc_no_id[i]);
                    if (i == this.mnRows - 1) continue;
                    fw.newLine();
                }
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Save file " + FileName + " failed");
            return false;
        }
        return true;
    }

    public TextArray toTextArray(boolean idOnly) {
        TextArray result = new TextArray(this.mDesc, "\t");
        if (idOnly) {
            TextArray res = new TextArray(result.columnm(1), "\t");
            String[] headers = new String[]{"probeid"};
            res.setColumnNames(headers);
            res.setKeys(result.columnj(0));
            return res;
        }
        String[] headers = new String[]{"probeid", "description"};
        result.setColumnNames(headers);
        result.setKeys(result.columnj(0));
        return result;
    }

    private void init(String name) {
        this.mTable = new Hashtable();
        this.mnRows = 0;
        this.mnSkip = 0;
        this.mChipName = name;
        this.mstrSeparator = " \t\n\r\f";
    }

    public ChipDescription(String name, String file, int skip) {
        this.init(name);
        this.load(file, skip);
    }

    public ChipDescription(String name, String file) {
        this.init(name);
        this.load(file, 0);
    }

    public void set(String sep) {
        this.mstrSeparator = sep;
        if (sep.equalsIgnoreCase("\\t") || sep.equalsIgnoreCase("tab")) {
            this.mstrSeparator = "\t";
        }
        if (sep.equalsIgnoreCase("space")) {
            this.mstrSeparator = " ";
        }
        if (sep.equalsIgnoreCase("comma")) {
            this.mstrSeparator = ",";
        }
        if (sep.equalsIgnoreCase("semicolon")) {
            this.mstrSeparator = ";";
        }
        if (sep.equalsIgnoreCase("default")) {
            this.mstrSeparator = " \t\n\r\f";
        }
    }

    public String chipname() {
        return this.mChipName;
    }

    public String[] getID() {
        return this.mID;
    }

    public String getIDm(int index) {
        if (index < 1 || index > this.mnRows) {
            System.out.println("Index out of bound");
            return null;
        }
        return this.mID[index - 1];
    }

    public String[] getIDm(int[] indexList) {
        if (indexList == null || indexList.length == 0) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < indexList.length; ++i) {
            if (indexList[i] <= 0 || indexList[i] > this.mnRows) continue;
            result.add(this.mID[indexList[i] - 1]);
        }
        if (result.size() == 0) {
            return null;
        }
        String[] res = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            res[i] = (String)result.get(i);
        }
        return res;
    }

    public String[] getDesc() {
        return this.mDesc;
    }

    public String[] getDesc(Object idlist) {
        Object[] list = new Object[]{idlist};
        return this.getDesc(list);
    }

    public int[] getIndexm(Object[] idlist) {
        if (idlist == null || idlist.length == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < idlist.length; ++i) {
            String strid;
            if (idlist[i] == null || (strid = idlist[i].toString().trim()).length() <= 0) continue;
            v.add(strid);
        }
        if (v.size() == 0) {
            return null;
        }
        Vector<Integer> result = new Vector<Integer>();
        for (int i = 0; i < v.size(); ++i) {
            if (!this.mTable.containsKey(v.get(i))) continue;
            int index = (Integer)this.mTable.get(v.get(i));
            result.add(new Integer(index + 1));
        }
        if (result.size() == 0) {
            return null;
        }
        int[] res = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            res[i] = (Integer)result.get(i);
        }
        return res;
    }

    public int[] getIndexm(Object idlist) {
        Object[] list = new Object[]{idlist};
        return this.getIndexm(list);
    }

    public int[] getIndexm(char[][] idlist) {
        return this.getIndexm(TextArray.toStrings(idlist));
    }

    public int[] getIndexm(char[] idlist) {
        return this.getIndexm(TextArray.toStrings(idlist));
    }

    public int[] getIndexm(String[] idlist) {
        return this.getIndexm((Object[])idlist);
    }

    public int size() {
        return this.mnRows;
    }

    public String[] getProbeList(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            System.out.println("Failed to open file " + filename);
            return null;
        }
        Vector<String> list = new Vector<String>();
        try {
            String str;
            BufferedReader br = new BufferedReader(new FileReader(f));
            block2: while ((str = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(str);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.endsWith("_at") || !this.mTable.containsKey(token)) continue;
                    list.add(token);
                    continue block2;
                }
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (String)list.get(i);
        }
        return result;
    }

    public String getDescm(int index) {
        if (index > 0 && index <= this.mnRows) {
            return this.mDesc[index - 1];
        }
        return null;
    }

    public String[] getDescm(int[] indexList) {
        if (indexList == null || indexList.length == 0) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < indexList.length; ++i) {
            if (indexList[i] <= 0 || indexList[i] > this.mnRows) continue;
            result.add(this.mDesc[indexList[i] - 1]);
        }
        if (result.size() == 0) {
            return null;
        }
        String[] res = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            res[i] = (String)result.get(i);
        }
        return res;
    }

    public String[] getDesc(char[][] idlist) {
        return this.getDesc(TextArray.toStrings(idlist));
    }

    public String[] getDesc(char[] idlist) {
        return this.getDesc(TextArray.toStrings(idlist));
    }

    public String[] getDesc(String[] idlist) {
        return this.getDesc((Object[])idlist);
    }

    public String[] getDesc(Object[] idlist) {
        if (idlist == null || idlist.length == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < idlist.length; ++i) {
            String strid;
            if (idlist[i] == null || (strid = idlist[i].toString().trim()).length() <= 0) continue;
            v.add(strid);
        }
        if (v.size() == 0) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < v.size(); ++i) {
            if (!this.mTable.containsKey(v.get(i))) continue;
            int index = (Integer)this.mTable.get(v.get(i));
            result.add(this.mDesc[index]);
        }
        if (result.size() == 0) {
            return null;
        }
        String[] res = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            res[i] = (String)result.get(i);
        }
        return res;
    }

    public static void search() {
        Thread linkThread = new Thread(){

            public void run() {
                try {
                    BrowserLauncher.openURL("http://www.isds.duke.edu/~quanli/PubmedSearchApplet.html");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        linkThread.start();
    }

    public boolean load(String FileName) {
        return this.load(FileName, 0);
    }

    public boolean load(String FileName, int skip) {
        String str;
        this.mnRows = 0;
        this.mnSkip = skip;
        this.mTable.clear();
        int nLineCount = 0;
        BufferedReader br = TextArray.getBufferedReader(FileName);
        if (br == null) {
            return false;
        }
        try {
            while ((str = br.readLine()) != null) {
                ++nLineCount;
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        this.mnRows = nLineCount - this.mnSkip;
        this.mID = new String[this.mnRows];
        this.mDesc = new String[this.mnRows];
        this.mDesc_no_id = new String[this.mnRows];
        nLineCount = 0;
        try {
            br = TextArray.getBufferedReader(FileName);
            if (br == null) {
                return false;
            }
            while ((str = br.readLine()) != null) {
                int nrow;
                if ((nrow = ++nLineCount - this.mnSkip - 1) < 0 || nrow >= this.mnRows) continue;
                StringTokenizer st = new StringTokenizer(str.trim(), this.mstrSeparator);
                boolean ncolumn = false;
                this.mID[nrow] = st.hasMoreTokens() ? st.nextToken().trim() : new Integer(nrow).toString() + "_";
                this.mDesc[nrow] = str.trim();
                this.mDesc_no_id[nrow] = str.substring(this.mID[nrow].length()).trim();
                this.mTable.put(this.mID[nrow], new Integer(nrow));
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        return true;
    }
}

