function [t]=clust(X,p,figindex,char) 

% takes Nxn expression data matrix X and clusters into p groups
% X has genes as rows, arrays as columns
% returns group membership vector t 
% plots in figure indexed
%
% cluster genes if char is 'G' or 'g', otherwise arrays 
%  

if (char(1)=='G' | char(1)=='g') 
	x=std_rows(X);
        xl='Genes'; yl='Samples';
	tit='Clustering of genes';
else
	x=std_rows(X'); 
        xl='Samples'; yl='Genes'; 
	tit='Clustering of samples';
end;


[N,n]=size(x); 
y= pdist(x); 
z= linkage(y,'average'); 

figure(figindex)
subplot(2,1,1)
[numlabel,t]=Xdendrogram(z,p);  
%%title(tit)
imx=[]; m=1.1*max(max(x))*ones(1,n); 
for i=1:p
    imx=[imx;x(find(t==numlabel(i)),:)]; 
    if i<p
        imx=[imx;m]; 
    end;
end;
subplot(2,1,2)
imagesc(imx'); axis([0 N+p-1 0 n+1]); colormap jet
xlabel(xl); ylabel(yl) 
%
