function [o2 o1 sortVec] = imagepc( z, reordCol, reordRow, highContrast, sortVec )
%IMAGEPC Summary of this function goes here
%   Detailed explanation goes here
if(nargin>=5)
    [a b]=size(sortVec);
    if(a>1 & b>1)
        'Pattern vector must not be a matrix.'
        return;
    end;
    if(a==1)
        sortVec=sortVec';
    end;
end;
if(nargin<4)
    highContrast=0;
end;
if(nargin<3)
    reordRow=1;
end;
if(nargin<2)
    reordCol=1;
end;

if(sum(sum(isnan(z)))>0)
    nanset=isnan(z);
    hasnan=1;
    for(i=1:size(z,1))
        kp=find(~isnan(z(i,:)));
        z(i,kp)=z(i,kp)-mean(z(i,kp));
        if(length(kp)>1) 
            z(i,kp)=z(i,kp)/std(z(i,kp));
        end;
    end;
    z(find(nanset))=0;
    mn=find(min(z')'==0);
    mx=find(max(z')'==0);
    drp=intersect(mn,mx);
    kp=1:size(z,1);
    kp(drp)=[];
%     z(drp,:)=[];
%     nanset(drp,:)=[];
else
    hasnan=0;
    z=z-repmat(mean(z,2),1,size(z,2));
    z=z./repmat(std(z')',1,size(z,2));
    kp=1:size(z,1);
end;
if(reordCol | reordRow)
    if(nargin<5)
        [a,d,f]=svd0(z(kp,:));
        sortVec=f(1,:)';
    end;
end;
if(reordCol)
%     [jnk o1]=sort(f(1,:));
    [jnk o1]=sort(sortVec);
else
    o1=1:size(z,2);
end;
if(reordRow)
%     scrs=z*f(1,:)';
    scrs=z*sortVec;
    [jnk o2]=sort(scrs);
else
    o2=1:size(z,1);
end;

if(hasnan)
    z(nanset)=NaN;
    kr=jet;
    kr(1,:)=[1 1 1];
    colormap(kr);
end;

if(~highContrast)
    imagesc(z(o2,o1))
else
    imagesc(abs(z(o2,o1)).^(1/3).*sign(z(o2,o1)));
%     imagesc(z(o2,o1).^(1/3));
end;
