function [matchA matchB]=intersectGenelist(ida, idb)

if (iscell(ida)~=1)
    ida=cellstr(ida);
end;
if (iscell(idb)~=1)
    idb=cellstr(idb);
end;

ap=size(ida,1);
ida=[ida num2cell(1:ap)'];
bp=size(idb,1);
idb=[idb num2cell(1:bp)'];

keepers=intersect(ida(:,1),idb(:,1));
keepers=sort(keepers);
ida=sortrows(ida,1);
idb=sortrows(idb,1);

N=size(keepers,1);
cnta=1;
cntb=1;
matchA=[zeros(size(keepers,1),2)];
matchB=[zeros(size(keepers,1),2)];
for(i=1:N)
    while(strcmp(ida(cnta,1),keepers(i))==0)
        cnta=cnta+1;
    end;
    while(strcmp(idb(cntb,1),keepers(i))==0)
        cntb=cntb+1;
    end;
    matchA(i,1)=cnta;
    matchA(i,2)=cell2mat(ida(cnta,2));
    matchB(i,1)=cntb;
    matchB(i,2)=cell2mat(idb(cntb,2));
end;

matchA=matchA(:,2);
matchB=matchB(:,2);