function [ loc ] = locMax( x )
%accepts a matrix and returns the locations within each column
% that contains the maximum value for that column.

[p n]=size(x);
bx=(x-repmat(max(x),p,1)==0);
if(sum(bx*ones(p,1))==p)
    loc=(1:p)*bx;
else
    'maxima are not unique, result will contain the last occurence'
    loc=max(bx.*repmat((1:p)',1,n));
end;
