function[p] = logdwishart(V,r,n,S);
% evaluate log density (up to normalisation constant) of singular Wishart
% V is W_m(n,S) with dimension m implicit
% S has rank r<n<m
% note that E(V)=S/n in this notation 
% nb. may be non-singular of course (???)
%

m=size(S); m=m(1); i=1:r; 
[A,D,F]=svd_mw(V); [B,E,G]=svd_mw(S); 
p=(-n*sum(log(D(i)))+(n-m-1)*sum(log(E(i)))-sum(diag(A(:,i)*diag(1./D(i))*A(:,i)'*S)))/2;
%