function [beta,v,prob,haty,e,mliktau]=mregbayes(y,x,tau,A)
% fits a multiple linear regression model to response data y 
%  using predictor matrix x 
%
% Conjugate shrinkage prior: zero mean, common variance tau for all predictors
% 	note that the intercept has a very large prior variance -- vague on intercept
% 	Residual precision has Gamma(a/2, b/2) prior : A=[a b]
% Also computes model marginal likelihood -- for given tau 
%
% A may be absent on input -- in which case the reference prior is used for res variance
%
%
%  ouputs are the posterior mean beta, the SDs of elements of beta in V, 
%  approximate probability level for each coeff, fitted values haty and residuals e
%
%  y is nx1 column vector, x is pxn matrix 
%  plots betas and approximate 90% intervals


if nargin == 3 
	A=[0 0];
end


[p,n]=size(x); X=x; y=reshape(y,n,1); 

% model fit ...
H=[ones(n,1),X'];       	        % create design matrix with intercept and center genes
C=eye(p+1)/tau; C(1,1)=1e-12;	 	% prior precision mx
B=H'*H+C; V=inv(B); beta=V*(H'*y);	% compute posterior mean/precision
					% n.b. note its a trivial change to LSE 
haty=H*beta; 				% fitted values
e=y-haty;  				% residuals

ag=A(1); bg=A(2); 	 		% prior for residual variance - deals with proper and ref
if (ag==0 | bg==0) 
	ag=0; bg=0; k=0;
else
	k=(ag/2)*log(bg/2)-gammaln(ag/2); 	 
end
	
ag=ag+n; bg=bg+y'*e; 			% posterior for residual variance
s=bg/ag;		 		% posterior mean for residual precision

mliktau=k+gammaln(ag/2)+0.5*(log(det(C))-log(det(B))-ag*log(bg));
					% log of model marginal likelihood 

v=sqrt(s*diag(V));              	% compute standard errors of beta coefficients
df=n;
prob=2*(1-pt(abs(beta./v),df));         % prob level for each coeff 
qtc=qt(0.975,df); 			% 95% intervals





figure(1) 
plot([0 1+p],[0 0]); hold on
for j=1:p
   plot([j,j],[beta(j+1)+qtc*v(j+1),beta(j+1)-qtc*v(j+1)],'k')
   text(j,beta(j+1),'+','HorizontalAlignment','Center')
end;
xlabel('Predictor gene index'); ylabel('Coeff')
title('Regression coefficients') 
hold off;

