function [B,V]= mvn_regn(Sigma,i,j)
% given a p-dim variance matrix Sigma and index vestors i, j
% produce regression matrix and conditional variance for regression
% of x(i) on x(j)
% need some checks. ...
%
B=0; V=0; 

[p,q]=size(Sigma); 
if (p~=q)
	error('Sigma is not square')
end;
ep=1e-9; s=sum(sum(abs(Sigma'-Sigma)<ep)); 
if (s~=p*p)
	error('Sigma is not symmetric')
end;
[v,d]=eig(Sigma); q=prod(diag(d)); 
if (q<0) 
	error('Sigma is not positive semi-definite')
end;

R=Sigma(i,j); B=R*ginv(Sigma(j,j),ep); V=Sigma(i,i)-B*R'; 

