function y = rbinomial(probs,denom);
% RBINOMIAL simulates binomial observations with success prob and denom.
%
% This algorithm is terribly inefficient, and gets worse as the denominator
% gets large.

if size(probs) == size(denom)

  y = zeros(size(probs));
  u = zeros(size(probs));
  md = max(max(denom));
  for i=1:md
	u = rand(size(probs));
	j = find(u<probs);
	k = (denom>=i);
	y(j) = y(j)+k(j);
  end
else
  error('size of binomial probability array not the same as denominator')
end
